/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpAttributeExpectedArgumentsProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCollectionExternalizer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpExitPointFunctionData;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMetaExpectedArgumentsProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PhpExitPointFunctionIndex
extends FileBasedIndexExtension<String, Collection<PhpExitPointFunctionData>> {
    @NonNls
    public static final ID<String, Collection<PhpExitPointFunctionData>> KEY = ID.create((String)"php.exit.point.function.index");
    public static final String EXIT_POINT_FUNCTION_NAME = "exitPoint";
    private static final DataExternalizer<PhpExitPointFunctionData> MY_EXTERNALIZER = new DataExternalizer<PhpExitPointFunctionData>(){

        public void save(@NotNull DataOutput out, PhpExitPointFunctionData data) throws IOException {
            String className;
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeBoolean((className = data.getClassName()) != null);
            if (className != null) {
                out.writeUTF(className);
            }
            out.writeUTF(data.getFunctionName());
            out.writeUTF(data.getNamespaceFQN());
            out.writeBoolean(data.fromAttribute());
            PhpExpectedFunctionArgumentsIndex.VALUE_EXTERNALIZER.save(out, data.getExpectedFunctionArguments());
        }

        public PhpExitPointFunctionData read(@NotNull DataInput in) throws IOException {
            boolean isClass;
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            String fqn = (isClass = in.readBoolean()) ? in.readUTF() : null;
            String methodName = in.readUTF();
            String namespace = in.readUTF();
            boolean fromAttribute = in.readBoolean();
            Object expectedArguments = PhpExpectedFunctionArgumentsIndex.VALUE_EXTERNALIZER.read(in);
            return new PhpExitPointFunctionData(fqn, methodName, namespace, fromAttribute, (Collection<PhpExpectedFunctionArgument>)expectedArguments);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpExitPointFunctionIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final PhpCollectionExternalizer<PhpExitPointFunctionData> COLLECTION_EXTERNALIZER = new PhpCollectionExternalizer<PhpExitPointFunctionData>(MY_EXTERNALIZER, ArrayList::new);

    protected Collection<PhpExitPointFunctionData> collectValues(@NotNull PhpFile file) {
        if (file == null) {
            PhpExitPointFunctionIndex.$$$reportNull$$$0(0);
        }
        if (PhpParameterBasedTypeProvider.isMeta((PsiFile)file)) {
            PhpMetaExitPointFunctionCollector registeredArgumentsSetCollector = new PhpMetaExitPointFunctionCollector();
            PhpControlFlowUtil.processFile(file, registeredArgumentsSetCollector);
            return registeredArgumentsSetCollector.myRegisteredArguments;
        }
        return (Collection)PhpFuncGetArgUsageProvider.findTopLevelFunctions((PsiFile)file).flatMap(f -> PhpAttributeExpectedArgumentsProvider.INSTANCE.getExitDataFromAttributes((Function)f).stream()).collect(Collectors.toList());
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataIndexer<String, Collection<PhpExitPointFunctionData>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            PsiFile file = inputData.getPsiFile();
            if (file instanceof PhpFile) {
                Collection<PhpExitPointFunctionData> values = this.collectValues((PhpFile)file);
                HashMap<String, Collection> m = new HashMap<String, Collection>();
                for (PhpExitPointFunctionData value : values) {
                    m.computeIfAbsent(value.getFunctionName(), a -> new ArrayList()).add(value);
                }
                return m;
            }
            return Collections.emptyMap();
        };
        if (dataIndexer == null) {
            PhpExitPointFunctionIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpExitPointFunctionIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public ID<String, Collection<PhpExitPointFunctionData>> getName() {
        ID<String, Collection<PhpExitPointFunctionData>> iD = KEY;
        if (iD == null) {
            PhpExitPointFunctionIndex.$$$reportNull$$$0(3);
        }
        return iD;
    }

    @NotNull
    public DataExternalizer<Collection<PhpExitPointFunctionData>> getValueExternalizer() {
        PhpCollectionExternalizer<PhpExitPointFunctionData> phpCollectionExternalizer = COLLECTION_EXTERNALIZER;
        if (phpCollectionExternalizer == null) {
            PhpExitPointFunctionIndex.$$$reportNull$$$0(4);
        }
        return phpCollectionExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpExitPointFunctionIndex.$$$reportNull$$$0(5);
        }
        return inputFilter;
    }

    private static PhpExitPointFunctionData createExitPointFunctionData(FunctionReference reference) {
        String namespaceFQN;
        if (!PhpExpectedFunctionArgumentsIndex.metaFunctionWithName(reference, EXIT_POINT_FUNCTION_NAME)) {
            return null;
        }
        FunctionReference parameter = (FunctionReference)ObjectUtils.tryCast((Object)reference.getParameter(0), FunctionReference.class);
        if (parameter == null) {
            return null;
        }
        ClassReference classReference = parameter instanceof MethodReference ? (ClassReference)ObjectUtils.tryCast((Object)((MethodReference)parameter).getClassReference(), ClassReference.class) : null;
        String methodName = parameter.getName();
        String string = namespaceFQN = classReference != null ? classReference.getImmediateNamespaceName() : parameter.getImmediateNamespaceName();
        if (methodName == null) {
            return null;
        }
        String className = classReference != null ? classReference.getName() : null;
        return new PhpExitPointFunctionData(className, methodName, namespaceFQN, false, PhpMetaExpectedArgumentsProvider.META_INSTANCE.getExpectedArguments((ParameterListOwner)parameter));
    }

    public int getVersion() {
        return 10;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpExitPointFunctionIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpExitPointFunctionIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectValues";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PhpMetaExitPointFunctionCollector
    extends PhpInstructionProcessor {
        private final Collection<PhpExitPointFunctionData> myRegisteredArguments = new ArrayList<PhpExitPointFunctionData>();

        PhpMetaExitPointFunctionCollector() {
        }

        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
            PhpExitPointFunctionData data = PhpExitPointFunctionIndex.createExitPointFunctionData(instruction.getFunctionReference());
            if (data == null) {
                return true;
            }
            this.myRegisteredArguments.add(data);
            return true;
        }
    }
}

