/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.classAlias.PhpClassAliasProvider;
import com.jetbrains.php.lang.classAlias.PhpClassAliasUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpClassToClassAliasIndex
extends FileBasedIndexExtension<String, String> {
    public static final ID<String, String> KEY = ID.create((String)"php.class.to.class.alias");

    @NotNull
    public ID<String, String> getName() {
        ID<String, String> iD = KEY;
        if (iD == null) {
            PhpClassToClassAliasIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return PhpClassAliasUtil.getVersion() + 1;
    }

    @NotNull
    public DataIndexer<String, String, FileContent> getIndexer() {
        DataIndexer dataIndexer = input -> {
            List<PhpClassAliasProvider> providers = PhpClassAliasNameIndex.getRelevantProviders(input);
            if (!providers.isEmpty()) {
                THashMap map = new THashMap();
                PsiFile file = input.getPsiFile();
                if (file instanceof PhpFile) {
                    PhpClassAliasUtil.processClassAliasDeclarations((PsiElement)file, providers, (reference, result) -> map.put((Object)StringUtil.toLowerCase((String)result.getOriginalFqn()), (Object)result.getAliasFqn()));
                    return map;
                }
            }
            return Collections.emptyMap();
        };
        if (dataIndexer == null) {
            PhpClassToClassAliasIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpClassToClassAliasIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpClassToClassAliasIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpClassToClassAliasIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpClassToClassAliasIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

