/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStubBase;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStub;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStubImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PhpVariableElementType
extends PhpStubElementType<PhpVariableStub, Variable> {
    public PhpVariableElementType(@NotNull String debugName) {
        if (debugName == null) {
            PhpVariableElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    public Variable createPsi(@NotNull PhpVariableStub stub) {
        if (stub == null) {
            PhpVariableElementType.$$$reportNull$$$0(1);
        }
        return new VariableImpl(stub);
    }

    @NotNull
    public PhpVariableStub createStub(@NotNull Variable psi, StubElement parentStub) {
        if (psi == null) {
            PhpVariableElementType.$$$reportNull$$$0(2);
        }
        PhpType type = PhpVariableElementType.inferredAssignedTypeToGlobalVariable(psi);
        String name = psi.getName();
        return new PhpVariableStubImpl(parentStub, (IStubElementType)this, StringRef.fromString((String)name), psi.getType(), type, PhpNamedStubBase.packDocCommentPresence((PhpNamedElement)psi));
    }

    @NotNull
    public static PhpType inferredAssignedTypeToGlobalVariable(Variable variable) {
        PhpVariableStub stub;
        if (variable instanceof VariableImpl && (stub = (PhpVariableStub)((VariableImpl)variable).getGreenStub()) instanceof PhpVariableStubImpl) {
            PhpType phpType = ((PhpVariableStubImpl)stub).getInferredAssignedType();
            if (phpType == null) {
                PhpVariableElementType.$$$reportNull$$$0(3);
            }
            return phpType;
        }
        if (PhpVariableElementType.prevVariableForStubExists(variable.getNode())) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpVariableElementType.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        if (scopeHolder != null && instruction != null) {
            PhpTypeAnalyserVisitor visitor = new PhpTypeAnalyserVisitor();
            PhpType inferredType = visitor.inferVariableType(variable, variable.getName(), (PhpInstruction)scopeHolder.getControlFlow().getExitPoint(), scopeHolder);
            PhpType typeWithoutVariableSignature = inferredType.filterOut(t -> PhpTypeSignatureKey.VARIABLE.isSigned(t) && PhpLangUtil.equalsVariableNames(t.substring(2), variable.getName()));
            boolean originalDeclarationReached = typeWithoutVariableSignature.size() != inferredType.size() || inferredType.isEmpty();
            PhpType phpType = originalDeclarationReached ? new PhpType().add(typeWithoutVariableSignature).add(variable.getType()) : typeWithoutVariableSignature;
            if (phpType == null) {
                PhpVariableElementType.$$$reportNull$$$0(5);
            }
            return phpType;
        }
        PhpType phpType = variable.getType();
        if (phpType == null) {
            PhpVariableElementType.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    public void serialize(@NotNull PhpVariableStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PhpVariableElementType.$$$reportNull$$$0(7);
        }
        if (dataStream == null) {
            PhpVariableElementType.$$$reportNull$$$0(8);
        }
        dataStream.writeName(stub.getName());
        PhpVariableElementType.writePhpType(dataStream, stub.getType());
        dataStream.writeShort((int)stub.getFlags());
        PhpVariableElementType.writePhpType(dataStream, ((PhpVariableStubImpl)stub).getInferredAssignedType());
    }

    @NotNull
    public PhpVariableStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PhpVariableElementType.$$$reportNull$$$0(9);
        }
        StringRef name = dataStream.readName();
        PhpType type = PhpVariableElementType.readPhpType(dataStream);
        short flags = dataStream.readShort();
        PhpType inferredAssignedType = PhpVariableElementType.readPhpType(dataStream);
        return new PhpVariableStubImpl(parentStub, (IStubElementType)this, name, type, inferredAssignedType, flags);
    }

    public boolean shouldCreateStub(ASTNode node) {
        return PhpVariableElementType.isApplicableForStub(node);
    }

    private static boolean prevVariableForStubExists(ASTNode node) {
        PhpPsiElement variable = (PhpPsiElement)node.getPsi();
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        final Ref prevStubVariableExists = new Ref((Object)false);
        if (instruction != null) {
            PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (PhpVariableElementType.isApplicableForStub(instruction.getAnchor().getNode())) {
                        prevStubVariableExists.set((Object)true);
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }
            });
        }
        return (Boolean)prevStubVariableExists.get();
    }

    private static boolean isApplicableForStub(ASTNode node) {
        if (node.getElementType() != PhpStubElementTypes.VARIABLE) {
            return false;
        }
        for (ASTNode parent = node.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            IElementType type = parent.getElementType();
            if (type == PhpElementTypes.WHILE || type == PhpElementTypes.DO_WHILE || type == PhpElementTypes.FOR || type == PhpElementTypes.FOREACH || type == PhpElementTypes.IF || type == PhpElementTypes.CONCATENATION_EXPRESSION || type == PhpElementTypes.METHOD_REFERENCE || type == PhpElementTypes.FIELD_REFERENCE || type == PhpElementTypes.PARAMETER_LIST) {
                return false;
            }
            if (type != PhpStubElementTypes.CLASS_METHOD && type != PhpStubElementTypes.FUNCTION) continue;
            return false;
        }
        PsiElement element = node.getPsi();
        return ((Variable)element).isDeclaration();
    }

    @Override
    public void indexStub(@NotNull PhpVariableStub stub, @NotNull IndexSink sink) {
        String shortName;
        if (stub == null) {
            PhpVariableElementType.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            PhpVariableElementType.$$$reportNull$$$0(11);
        }
        if ((shortName = stub.getName()) != null) {
            sink.occurrence(PhpVariableIndex.KEY, (Object)shortName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/PhpVariableElementType";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/PhpVariableElementType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inferredAssignedTypeToGlobalVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

