/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpLanguageTypeMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpStubElementType<S extends StubElement<?>, T extends PhpPsiElement>
extends IStubElementType<S, T> {
    public PhpStubElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            PhpStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, (Language)PhpLanguage.INSTANCE);
    }

    public void indexStub(@NotNull S stub, @NotNull IndexSink sink) {
        if (stub == null) {
            PhpStubElementType.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            PhpStubElementType.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public String getExternalId() {
        String string = "php." + super.toString();
        if (string == null) {
            PhpStubElementType.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void writeLanguageTypeMap(@Nullable PhpLanguageTypeMap map, StubOutputStream dataStream) throws IOException {
        if (map == null) {
            dataStream.writeBoolean(false);
        } else {
            dataStream.writeBoolean(true);
            Map m = map.getLanguageTypeMap();
            dataStream.writeInt(m.size());
            for (Map.Entry entry : m.entrySet()) {
                dataStream.writeName((String)entry.getKey());
                PhpStubElementType.writePhpType(dataStream, (PhpType)entry.getValue());
            }
            PhpStubElementType.writePhpType(dataStream, map.getDefaultType());
        }
    }

    @Nullable
    protected PhpLanguageTypeMap readLanguageTypeMap(StubInputStream dataStream) throws IOException {
        if (!dataStream.readBoolean()) {
            return null;
        }
        int size = dataStream.readInt();
        HashMap<String, PhpType> m = new HashMap<String, PhpType>(size);
        for (int i = 0; i < size; ++i) {
            m.put(dataStream.readNameString(), PhpStubElementType.readPhpType(dataStream));
        }
        return new PhpLanguageTypeMap(m, PhpStubElementType.readPhpType(dataStream));
    }

    protected static void writePhpType(StubOutputStream dataStream, @NotNull PhpType type) throws IOException {
        if (type == null) {
            PhpStubElementType.$$$reportNull$$$0(4);
        }
        Set types = type.getTypes();
        dataStream.writeVarInt(types.size());
        for (String s : types) {
            dataStream.writeName(s);
        }
    }

    @NotNull
    protected static PhpType readPhpType(StubInputStream dataStream) throws IOException {
        PhpType t = new PhpType();
        int i = dataStream.readVarInt();
        for (int j = 0; j < i; ++j) {
            String s = dataStream.readNameString();
            if (s == null) continue;
            t.add(s);
        }
        PhpType phpType = t;
        if (phpType == null) {
            PhpStubElementType.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    static void writeStringArray(StubOutputStream dataStream, String[] names) throws IOException {
        int size = Math.min(127, names.length);
        dataStream.writeByte(size);
        for (int i = 0; i < size; ++i) {
            String name = names[i];
            dataStream.writeName(name);
        }
    }

    static String[] readStringArray(StubInputStream dataStream) throws IOException {
        int supersNumber = dataStream.readByte();
        String[] superClasses = ArrayUtil.newStringArray((int)supersNumber);
        for (int i = 0; i < supersNumber; ++i) {
            superClasses[i] = dataStream.readNameString();
        }
        return superClasses;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/PhpStubElementType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/PhpStubElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readPhpType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writePhpType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

