/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import com.jetbrains.php.lang.psi.stubs.PhpClassStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInheritanceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitIndex;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PhpClassElementType
extends PhpStubElementType<PhpClassStub, PhpClass> {
    public PhpClassElementType(@NotNull String debugName) {
        if (debugName == null) {
            PhpClassElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    public PhpClass createPsi(@NotNull PhpClassStub stub) {
        if (stub == null) {
            PhpClassElementType.$$$reportNull$$$0(1);
        }
        return new PhpClassImpl(stub);
    }

    @NotNull
    public PhpClassStub createStub(@NotNull PhpClass psi, StubElement parentStub) {
        if (psi == null) {
            PhpClassElementType.$$$reportNull$$$0(2);
        }
        return new PhpClassStubImpl(parentStub, this, StringRef.fromString((String)psi.getName()), StringRef.fromString((String)psi.getNamespaceName()), PhpClassStubImpl.packFlags(psi), psi.getSuperFQN(), psi.getInterfaceNames(), psi.getTraitNames(), psi.getMixinNames(), StringRef.fromString((String)PhpNamedElementImpl.getDeprecatedSinceVersion((PhpNamedElement)psi)), PhpClassElementType.getStubData((Collection)StreamEx.of((Object[])psi.getOwnFields()).select(PhpClassImpl.MyRenamableFakePsiElement.class).collect(Collectors.toList())), ((PhpClassImpl)psi).getDeprecationInfo());
    }

    private static PhpClassStub.PhpConstructorFieldStubData[] getStubData(Collection<PhpClassImpl.MyRenamableFakePsiElement> fields) {
        return (PhpClassStub.PhpConstructorFieldStubData[])StreamEx.of(fields).map(f -> new PhpClassStub.PhpConstructorFieldStubData(f.getName(), f.getType(), f.getTextRange(), f.isDynamic())).toArray(PhpClassStub.PhpConstructorFieldStubData.class);
    }

    public void serialize(@NotNull PhpClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PhpClassElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            PhpClassElementType.$$$reportNull$$$0(4);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getNamespaceName());
        dataStream.writeShort((int)stub.getFlags());
        dataStream.writeName(stub.getSuperclass());
        PhpClassElementType.writeStringArray(dataStream, stub.getInterfaces());
        PhpClassElementType.writeStringArray(dataStream, stub.getTraits());
        PhpClassElementType.writeStringArray(dataStream, stub.getMixins());
        dataStream.writeName(stub.getDeprecatedSinceVersion());
        PhpClassStub.PhpConstructorFieldStubData[] data = stub.getConstructionFieldsStubData();
        dataStream.writeInt(data.length);
        for (PhpClassStub.PhpConstructorFieldStubData datum : data) {
            dataStream.writeInt(datum.getRange().getStartOffset());
            dataStream.writeInt(datum.getRange().getEndOffset());
            dataStream.writeName(datum.getName());
            PhpClassElementType.writePhpType(dataStream, datum.getType());
            dataStream.writeBoolean(datum.isDynamic());
        }
        PhpDeprecationAttributeOwner.PhpDeprecationInfo.write((PhpDeprecationAttributeOwner.PhpDeprecationInfo)stub.getDeprecationInfo(), (StubOutputStream)dataStream);
    }

    @NotNull
    public PhpClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PhpClassElementType.$$$reportNull$$$0(5);
        }
        StringRef name = dataStream.readName();
        StringRef namespace = dataStream.readName();
        short flags = dataStream.readShort();
        String superclass = dataStream.readNameString();
        String[] interfaces = PhpClassElementType.readStringArray(dataStream);
        String[] traits = PhpClassElementType.readStringArray(dataStream);
        String[] mixins = PhpClassElementType.readStringArray(dataStream);
        StringRef deprecatedSinceRef = dataStream.readName();
        int constructorFieldStubDataSize = dataStream.readInt();
        PhpClassStub.PhpConstructorFieldStubData[] data = new PhpClassStub.PhpConstructorFieldStubData[constructorFieldStubDataSize];
        for (int i = 0; i < constructorFieldStubDataSize; ++i) {
            int startOffset = dataStream.readInt();
            int endOffset = dataStream.readInt();
            String dataName = dataStream.readNameString();
            PhpType type = PhpClassElementType.readPhpType(dataStream);
            boolean isDynamic = dataStream.readBoolean();
            data[i] = new PhpClassStub.PhpConstructorFieldStubData(dataName, type, TextRange.create((int)startOffset, (int)endOffset), isDynamic);
        }
        PhpDeprecationAttributeOwner.PhpDeprecationInfo deprecationInfo = PhpDeprecationAttributeOwner.PhpDeprecationInfo.read((StubInputStream)dataStream);
        return new PhpClassStubImpl(parentStub, this, name, namespace, flags, superclass, interfaces, traits, mixins, deprecatedSinceRef, data, deprecationInfo);
    }

    @Override
    public void indexStub(@NotNull PhpClassStub stub, @NotNull IndexSink sink) {
        String shortName;
        if (stub == null) {
            PhpClassElementType.$$$reportNull$$$0(6);
        }
        if (sink == null) {
            PhpClassElementType.$$$reportNull$$$0(7);
        }
        if ((shortName = stub.getName()) != null) {
            StubIndexKey<String, PhpClass> indexKey = stub.isInterface() ? PhpInterfaceIndex.KEY : (stub.isTrait() ? PhpTraitIndex.KEY : PhpClassIndex.KEY);
            sink.occurrence(indexKey, (Object)StringUtil.toLowerCase((String)shortName));
        }
        if (stub.getSuperclass() != null) {
            sink.occurrence(PhpInheritanceIndex.KEY, (Object)StringUtil.toLowerCase((String)stub.getSuperclass()));
        }
        for (String superName : stub.getInterfaces()) {
            sink.occurrence(PhpInheritanceIndex.KEY, (Object)StringUtil.toLowerCase((String)superName));
        }
        if (stub.isTrait()) {
            sink.occurrence(PhpTraitFqnIndex.KEY, (Object)PhpLangUtil.concat(stub.getNamespaceName(), stub.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/PhpClassElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

