/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.diagnostic.PluginException;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider2;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTypeInfo {
    public static final Logger LOG = Logger.getInstance(PhpTypeInfo.class);
    private static final RecursionGuard<PsiElement> RECURSION_GUARD = RecursionManager.createGuard((String)"php.type.info");

    public static PhpType getType(@Nullable PsiElement psi) {
        return PhpTypeInfo.getType(psi, new PhpTypeAnalyserVisitor()).createImmutableType();
    }

    private static PhpType getType(@Nullable PsiElement psi, PhpTypeAnalyserVisitor analyser) {
        StubElement stub;
        ProgressManager.checkCanceled();
        if (psi == null) {
            return PhpType.EMPTY;
        }
        Map<PsiElement, PhpType> type_cache = PhpCaches.getInstance((Project)psi.getProject()).TYPE_CACHE;
        PhpType type = type_cache.get(psi);
        if (type == null && psi instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)psi).getGreenStub()) instanceof PhpTypedStub) {
            type = ((PhpTypedStub)stub).getType();
        }
        if (type == null) {
            RecursionGuard.StackStamp mark = RecursionManager.markStack();
            List currentStack = RECURSION_GUARD.currentStack();
            if (currentStack.size() > 100) {
                PsiElement top = (PsiElement)currentStack.get(0);
                LOG.debug("RECURSION LIMIT for " + top + " `" + top.getText() + "`:" + top.getTextOffset() + " on " + psi + " `" + StringUtil.trimLog((String)psi.getText(), (int)50) + "`:" + psi.getTextOffset() + "+" + psi.getTextLength() + " in " + PsiUtilCore.getVirtualFile((PsiElement)psi));
                RECURSION_GUARD.prohibitResultCaching((Object)psi);
            } else {
                type = PhpTypeInfo.getTypeFromAST(psi, analyser);
            }
            if (type == null) {
                type = PhpType.EMPTY;
            }
            if (type_cache.size() > 7000) {
                type_cache.clear();
            }
            if (mark.mayCacheNow()) {
                type_cache.put(psi, type);
            }
        }
        return type;
    }

    @NotNull
    public static PhpType getTypeFromAST(@NotNull PsiElement psi, PhpTypeAnalyserVisitor typeAnalyser) {
        if (psi == null) {
            PhpTypeInfo.$$$reportNull$$$0(0);
        }
        PhpType type = (PhpType)RECURSION_GUARD.doPreventingRecursion((Object)psi, true, () -> {
            PhpType provided;
            PhpType providedTypes = new PhpType();
            psi.accept((PsiElementVisitor)typeAnalyser);
            PhpType analysed = typeAnalyser.getType();
            if (typeAnalyser.shouldStop()) {
                return analysed;
            }
            for (PhpTypeProvider4 provider : ((PhpIndexImpl)PhpIndex.getInstance((Project)psi.getProject())).getTypeProviders()) {
                try {
                    ProgressManager.checkCanceled();
                    provided = provider.getType(psi);
                    if (provided != null && !provided.isEmpty() && LOG.isTraceEnabled()) {
                        LOG.trace("TypeProvider4 " + provider.getClass() + " +'" + provided + " @" + psi);
                    }
                    providedTypes.add(provided);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass((String)("TypeProvider contract violation? by " + provider.getClass() + " on " + psi.getText()), (Throwable)e, provider.getClass());
                }
            }
            if (!providedTypes.isEmpty()) {
                analysed = analysed.add(providedTypes);
            }
            for (PhpTypeProvider4 provider : PhpTypeProvider3.EP_NAME.getExtensionList()) {
                try {
                    ProgressManager.checkCanceled();
                    provided = provider.getType(psi);
                    if (provided != null && !provided.isEmpty() && LOG.isTraceEnabled()) {
                        LOG.trace("TypeProvider3 " + provider.getClass() + " +'" + provided + " @" + psi);
                    }
                    providedTypes.add(provided);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass((String)("TypeProvider contract violation? by " + provider.getClass() + " on " + psi.getText()), (Throwable)e, provider.getClass());
                }
            }
            if (!providedTypes.isEmpty()) {
                return analysed.add(providedTypes);
            }
            for (PhpTypeProvider4 provider : PhpTypeProvider2.EP_NAME.getExtensionList()) {
                ProgressManager.checkCanceled();
                String providerType = provider.getType(psi);
                if (providerType == null) continue;
                StringUtil.split((String)providerType, (String)"|").stream().map(arg_0 -> PhpTypeInfo.lambda$getTypeFromAST$0((PhpTypeProvider2)provider, arg_0)).forEach(arg_0 -> ((PhpType)providedTypes).add(arg_0));
            }
            if (!providedTypes.isEmpty()) {
                return analysed.add(providedTypes);
            }
            return analysed;
        });
        PhpType phpType = (PhpType)ObjectUtils.notNull((Object)type, (Object)PhpType.EMPTY);
        if (phpType == null) {
            PhpTypeInfo.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    private static /* synthetic */ String lambda$getTypeFromAST$0(PhpTypeProvider2 provider, String s) {
        return "#" + provider.getKey() + s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromAST";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromAST";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

