/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceByVariableTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceInObjectContextTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableDeclaredTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.intentions.PhpReplaceIfWithTernaryIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpOptionalCompletionTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTypeAnalyserVisitor
extends PhpElementVisitor
implements PhpElementTypes {
    public static final boolean INFER_FROM_CONSTRUCTOR = true;
    @NotNull
    private PhpType type = new PhpType();
    private boolean myShouldStop;

    public void addType(@Nullable PsiElement element) {
        this.type.add(element);
    }

    public void addType(@Nullable String signature) {
        this.type.add(signature);
    }

    public void addType(@NotNull PhpType phpType) {
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(0);
        }
        if (!phpType.isEmpty()) {
            this.type.add(phpType);
        }
    }

    public boolean addTypeFromExpression(@NotNull PhpExpression curAnchor) {
        ArrayAccessExpression arrayAccessExpression;
        ArrayIndex arrayIndex;
        PhpPsiElement value;
        PsiElement parent;
        if (curAnchor == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(1);
        }
        if (curAnchor instanceof Variable) {
            Variable assignedVariable;
            AssignmentExpression assignment;
            Function function;
            Variable variable = (Variable)curAnchor;
            PsiElement parent2 = variable.getParent();
            if (parent2 instanceof Catch) {
                PhpType phpType = new PhpType().add(PhpType.EXCEPTION);
                ((Catch)parent2).getExceptionTypes().forEach(arg_0 -> ((PhpType)phpType).add(arg_0));
                this.addType(phpType);
                return true;
            }
            if (parent2 instanceof Global) {
                this.addType(new PhpType().add(variable.getSignature()));
                return true;
            }
            if (parent2 instanceof PhpUseList && PhpReplaceIfWithTernaryIntention.isPassedByReference((PsiElement)variable) && (function = (Function)ObjectUtils.tryCast((Object)parent2.getParent(), Function.class)) != null && function.isClosure() && (assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)function, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF)) != null && (assignedVariable = (Variable)ObjectUtils.tryCast((Object)assignment.getVariable(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(assignedVariable.getName(), variable.getName()) && PsiTreeUtil.isAncestor((PsiElement)assignment.getValue(), (PsiElement)function, (boolean)false)) {
                this.addType(new PhpType().add(assignedVariable.getType()));
                return true;
            }
        }
        if (PhpPsiUtil.isOfType(parent = curAnchor.getParent(), ARRAY_VALUE)) {
            PsiElement grandParent = parent.getParent();
            PsiElement psiElement = parent = grandParent instanceof ArrayCreationExpression ? grandParent.getParent() : grandParent;
        }
        if (parent instanceof MultiassignmentExpression) {
            PhpPsiElement valueExpression = ((MultiassignmentExpression)parent).getValue();
            if (PhpPsiUtil.isOfType((PsiElement)valueExpression, EXPRESSION)) {
                value = valueExpression.getFirstPsiChild();
                if (value instanceof ArrayCreationExpression) {
                    List arrayValues = ArrayCreationExpressionImpl.children((ArrayCreationExpression)value).stream().map(e -> e instanceof ArrayHashElement ? ((ArrayHashElement)e).getValue() : e.getFirstPsiChild()).collect(Collectors.toList());
                    int pos = PhpTypeAnalyserVisitor.findPos(curAnchor.getParent());
                    if (!arrayValues.isEmpty() && pos < arrayValues.size()) {
                        this.addType((PsiElement)arrayValues.get(pos));
                        return true;
                    }
                }
                if (value instanceof PhpTypedElement) {
                    this.addType(((PhpTypedElement)value).getType().elementType());
                    return true;
                }
            }
        } else if (parent instanceof SelfAssignmentExpression) {
            SelfAssignmentExpression selfAssignmentExpression = (SelfAssignmentExpression)parent;
            PhpPsiElement variable = selfAssignmentExpression.getVariable();
            if (variable == curAnchor) {
                PsiElement operation = selfAssignmentExpression.getOperation();
                if (operation != null && PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
                    this.addType(PhpType.STRING);
                    return true;
                }
                PhpPsiElement value2 = selfAssignmentExpression.getValue();
                if (value2 instanceof PhpTypedElement) {
                    PhpType type = ((PhpTypedElement)value2).getType();
                    this.addType(type);
                    return type.getTypes().stream().noneMatch(t -> PhpType.isArray((String)t) || PhpType.isPluralType((String)t));
                }
            }
        } else if (parent instanceof AssignmentExpression) {
            AssignmentExpression assignmentExpression = (AssignmentExpression)parent;
            if (assignmentExpression.getVariable() == curAnchor && (value = assignmentExpression.getValue()) instanceof PhpTypedElement) {
                this.addType(((PhpTypedElement)value).getType());
                return true;
            }
        } else if (parent instanceof ArrayAccessExpression && (arrayIndex = (arrayAccessExpression = (ArrayAccessExpression)parent).getIndex()) != null && arrayIndex.getFirstPsiChild() == null) {
            this.addType(PhpType.ARRAY);
            return false;
        }
        return false;
    }

    private static int findPos(PsiElement element) {
        int i = 0;
        while ((element = PhpPsiUtil.getPrevSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opCOMMA)))) != null) {
            ++i;
        }
        return i;
    }

    public boolean shouldStop() {
        return this.myShouldStop;
    }

    @Nullable
    private static PhpType inferType(@NotNull PhpPsiElement curAnchor) {
        ArrayAccessExpression arrayAccessExpression;
        ArrayIndex arrayIndex;
        PhpPsiElement value;
        PsiElement grandParent;
        PsiElement parent;
        if (curAnchor == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(2);
        }
        if (curAnchor instanceof Variable) {
            Variable assignedVariable;
            AssignmentExpression assignment;
            Function function;
            Variable variable = (Variable)curAnchor;
            PsiElement parent2 = variable.getParent();
            if (parent2 instanceof Catch) {
                PhpType phpType = new PhpType().add(PhpType.EXCEPTION);
                ((Catch)parent2).getExceptionTypes().forEach(arg_0 -> ((PhpType)phpType).add(arg_0));
                return phpType;
            }
            if (parent2 instanceof Global) {
                return new PhpType().add(variable.getSignature());
            }
            if (parent2 instanceof PhpUseList && PhpReplaceIfWithTernaryIntention.isPassedByReference((PsiElement)variable) && (function = (Function)ObjectUtils.tryCast((Object)parent2.getParent(), Function.class)) != null && function.isClosure() && (assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)function, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF)) != null && (assignedVariable = (Variable)ObjectUtils.tryCast((Object)assignment.getVariable(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(assignedVariable.getName(), variable.getName()) && PsiTreeUtil.isAncestor((PsiElement)assignment.getValue(), (PsiElement)function, (boolean)false)) {
                return new PhpType().add(assignedVariable.getType());
            }
        }
        if (PhpPsiUtil.isOfType(parent = curAnchor.getParent(), ARRAY_VALUE) && (grandParent = parent.getParent()) instanceof ArrayCreationExpression) {
            parent = grandParent.getParent();
        }
        if (parent instanceof MultiassignmentExpression) {
            PhpPsiElement valueExpression = ((MultiassignmentExpression)parent).getValue();
            if (PhpPsiUtil.isOfType((PsiElement)valueExpression, EXPRESSION) && (value = valueExpression.getFirstPsiChild()) instanceof PhpTypedElement) {
                return ((PhpTypedElement)value).getType().elementType();
            }
        } else if (parent instanceof SelfAssignmentExpression) {
            SelfAssignmentExpression selfAssignmentExpression = (SelfAssignmentExpression)parent;
            PhpPsiElement variable = selfAssignmentExpression.getVariable();
            if (variable == curAnchor) {
                PsiElement operation = selfAssignmentExpression.getOperation();
                if (operation != null && PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
                    return PhpType.STRING;
                }
                PhpPsiElement value2 = selfAssignmentExpression.getValue();
                if (value2 instanceof PhpTypedElement) {
                    return ((PhpTypedElement)value2).getType();
                }
            }
        } else if (parent instanceof AssignmentExpression) {
            AssignmentExpression assignmentExpression = (AssignmentExpression)parent;
            if (assignmentExpression.getVariable() == curAnchor && (value = assignmentExpression.getValue()) instanceof PhpTypedElement) {
                return ((PhpTypedElement)value).getType();
            }
        } else if (parent instanceof ArrayAccessExpression && (arrayIndex = (arrayAccessExpression = (ArrayAccessExpression)parent).getIndex()) != null && arrayIndex.getFirstPsiChild() == null) {
            return PhpType.ARRAY;
        }
        return null;
    }

    @NotNull
    public PhpType getType() {
        PhpType phpType = this.type;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    protected void visitPhpReference(PhpReference ref) {
        PhpType localType = ref.resolveLocalType();
        if (!localType.isEmpty()) {
            this.addType(localType);
        } else {
            this.addSignature(ref);
        }
    }

    private void addSignature(PhpReference ref) {
        String signature = ref.getSignature();
        if (signature.indexOf(124) < 0) {
            this.addType(signature);
        } else {
            List split = StringUtil.split((String)signature, (String)"|");
            for (String s : split) {
                this.addType(s);
            }
        }
    }

    @NotNull
    private static PhpType getNumericTypes(PsiElement e) {
        PhpTypedElement element = (PhpTypedElement)ObjectUtils.tryCast((Object)e, PhpTypedElement.class);
        PhpType phpType = element != null ? element.getType().filterOut(s -> !PhpType.FLOAT_INT.getTypes().contains(s)) : PhpType.EMPTY;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    private void addNumericTypes(@Nullable PhpPsiElement value) {
        PhpType valueType = new PhpType().add((PsiElement)value);
        PhpType numericTypes = valueType.filterOut(s -> !PhpType.intersects((PhpType)PhpType.FLOAT_INT, (PhpType)new PhpType().add(s)));
        if (!numericTypes.isEmpty() && numericTypes.equals((Object)valueType)) {
            this.addType(numericTypes);
        } else {
            this.addType(PhpType.FLOAT_INT);
        }
    }

    public void visitPhpUnaryExpression(UnaryExpression expression) {
        IElementType o = expression.getOperation().getNode().getElementType();
        if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.INFIX_EXPRESSION)) {
            if (o == PhpTokenTypes.opPLUS || o == PhpTokenTypes.opMINUS) {
                this.addNumericTypes(expression.getValue());
            } else if (o == PhpTokenTypes.opBIT_NOT) {
                PhpType type = new PhpType().add((PsiElement)expression.getValue());
                if (type.equals((Object)PhpType.STRING)) {
                    this.addType(PhpType.STRING);
                } else if (PhpTypeAnalyserVisitor.isUnresolvedWithoutString(type)) {
                    this.addType(PhpType.INT);
                } else {
                    this.addType(PhpType.STRING);
                    this.addType(PhpType.INT);
                }
            } else {
                this.addType(PhpType.BOOLEAN);
            }
        } else if (PhpTokenTypes.tsCAST_OPS.contains(o)) {
            this.addType(PhpTypeAnalyserVisitor.getCastOperationType(o));
        } else if (o == PhpTokenTypes.opNOT) {
            this.addType(PhpType.BOOLEAN);
        } else if (!PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.INFIX_WRITE_EXPRESSION)) {
            this.addType((PsiElement)expression.getValue());
        }
    }

    public static PhpType getCastOperationType(IElementType o) {
        if (o == PhpTokenTypes.opINTEGER_CAST) {
            return PhpType.INT;
        }
        if (o == PhpTokenTypes.opFLOAT_CAST) {
            return PhpType.FLOAT;
        }
        if (o == PhpTokenTypes.opBOOLEAN_CAST) {
            return PhpType.BOOLEAN;
        }
        if (o == PhpTokenTypes.opSTRING_CAST) {
            return PhpType.STRING;
        }
        if (o == PhpTokenTypes.opARRAY_CAST) {
            return PhpType.ARRAY;
        }
        if (o == PhpTokenTypes.opOBJECT_CAST) {
            return PhpType.OBJECT;
        }
        if (o == PhpTokenTypes.opUNSET_CAST) {
            return PhpType.UNSET;
        }
        return PhpType.EMPTY;
    }

    private static boolean isUnresolvedWithoutString(@NotNull PhpType type) {
        if (type == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(5);
        }
        return !type.hasUnresolved() && !PhpType.intersects((PhpType)PhpType.STRING, (PhpType)type);
    }

    public void visitPhpVariable(Variable variable) {
        PhpType docType = variable.getDocType();
        this.addType(docType);
        if (!docType.isEmpty()) {
            this.myShouldStop = true;
            return;
        }
        this.addInferredType(variable, new PhpVariableDeclaredTypeAnalyzerProcessor(variable));
    }

    public void addInferredType(Variable variable, PhpTypeAnalyzerProcessor variableDeclaredTypeAnalyzer) {
        PhpScopeHolder scopeHolder;
        CharSequence variableName;
        if (PhpLangUtil.isThisReference((PsiElement)variable)) {
            this.type.add((PsiElement)PhpClassImpl.getContainingClass((PhpPsiElement)variable));
        }
        if (StringUtil.isEmpty((CharSequence)(variableName = variable.getNameCS()))) {
            return;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        PhpType inferredDocType = PhpTypeAnalyserVisitor.inferDocType(variableDeclaredTypeAnalyzer, instruction);
        this.addType(inferredDocType);
        if (inferredDocType.isNotExtendablePrimitiveType()) {
            return;
        }
        PsiElement parent = variable.getParent();
        if (parent instanceof ForeachStatement && (((ForeachStatement)parent).getKey() == variable || ((ForeachStatement)parent).getValue() == variable)) {
            return;
        }
        boolean finish = this.addTypeFromExpression((PhpExpression)variable);
        if (!finish && (scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable)) != null && instruction != null) {
            PhpType inferredType = this.inferVariableType(variable, variableName, (PhpInstruction)instruction, scopeHolder);
            this.addType(!inferredDocType.isEmpty() ? inferredType.filterMixed() : inferredType);
        }
    }

    @NotNull
    private static PhpType inferDocType(PhpTypeAnalyzerProcessor variableDeclaredTypeAnalyzer, PhpAccessVariableInstruction instruction) {
        if (instruction == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(6);
            }
            return phpType;
        }
        PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction, true, variableDeclaredTypeAnalyzer);
        PhpType phpType = variableDeclaredTypeAnalyzer.getType();
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    @NotNull
    public PhpType inferVariableType(Variable variable, CharSequence variableName, PhpInstruction instruction, PhpScopeHolder scopeHolder) {
        PhpType phpType = PhpVariableInferredTypeAnalyzerProcessor.inferTypeDfaBasedTypeStateAware(variable, variableName, scopeHolder, instruction);
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
        this.addType((PsiElement)expr.getValue());
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        PsiElement operation = expression.getOperation();
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
            this.addType(PhpType.STRING);
        } else {
            this.visitPhpAssignmentExpression((AssignmentExpression)expression);
        }
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        this.visitPhpAssignmentExpression((AssignmentExpression)multiassignmentExpression);
    }

    public void visitPhpConstant(Constant constant) {
        PsiElement value = constant.getValue();
        if (!(value == null || value instanceof ConstantReference && StringUtil.equalsIgnoreCase((CharSequence)((ConstantReference)value).getName(), (CharSequence)constant.getName()))) {
            this.addType(value);
        }
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        PhpType elementTypePluralised;
        HashSet<PhpType> types = new HashSet<PhpType>();
        for (PhpPsiElement child : ArrayCreationExpressionImpl.children(expression)) {
            PhpTypedElement element = (PhpTypedElement)ObjectUtils.tryCast((Object)(child instanceof ArrayHashElement ? ((ArrayHashElement)child).getValue() : child.getFirstPsiChild()), PhpTypedElement.class);
            if (element == null) {
                this.addType(PhpType.ARRAY);
                return;
            }
            types.add(element.getType());
        }
        PhpType item = (PhpType)ContainerUtil.getOnlyItem(types);
        if (item != null && !(elementTypePluralised = new PhpType().add(item.filterUnknown().pluralise())).isEmpty()) {
            this.addType(elementTypePluralised.createImmutableType());
            return;
        }
        this.addType(PhpType.ARRAY);
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        PhpPsiElement reference = expression.getValue();
        ArrayIndex index = expression.getIndex();
        if (index != null) {
            PhpArrayAccessTypeAnalyzer processor;
            PhpPsiElement key = index.getValue();
            boolean finish = this.addTypeFromExpression((PhpExpression)expression);
            if (finish) {
                return;
            }
            PhpArrayAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)expression, PhpArrayAccessInstruction.class);
            if (instruction != null && (processor = PhpTypeAnalyserVisitor.createProcessor((PsiElement)reference, (PsiElement)key)) != null) {
                PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor);
                PhpType phpType = processor.getType();
                if (!phpType.isEmpty()) {
                    this.addType(phpType);
                    if (processor.foundExactArrayIndexType()) {
                        return;
                    }
                } else {
                    AssignmentExpression assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)expression.getParent(), AssignmentExpression.class);
                    if (assignmentExpression != null && assignmentExpression.getVariable() == expression) {
                        this.addType(PhpType.MIXED);
                    }
                }
            }
        }
        if (index != null) {
            PhpPsiElement value = expression.getValue();
            if (value instanceof PhpTypedElement) {
                PhpType elementType = ((PhpTypedElement)value).getType().elementType();
                Set types = elementType.getTypes();
                for (String s : types) {
                    if (("$this".equals(s) || "static".equals(s)) && reference instanceof MemberReference) {
                        this.addType((PsiElement)((MemberReference)reference).getClassReference());
                        continue;
                    }
                    this.addType(s);
                }
            }
        } else {
            this.addType(PhpType.ARRAY);
        }
    }

    @Nullable
    public static PhpArrayAccessTypeAnalyzer createProcessor(PsiElement arrayValue, @Nullable PsiElement key) {
        if (arrayValue instanceof Variable && StringUtil.isNotEmpty((String)((Variable)arrayValue).getName())) {
            return new PhpVariableArrayAccessTypeAnalyzer(((Variable)arrayValue).getName(), key);
        }
        if (arrayValue instanceof FieldReference) {
            PhpExpression classReference = ((FieldReference)arrayValue).getClassReference();
            String name = ((FieldReference)arrayValue).getName();
            if (classReference instanceof Variable || classReference instanceof ClassReference && PhpLangUtil.isSelfReference((ClassReference)classReference)) {
                return new PhpFieldReferenceArrayAccessTypeAnalyzer((PsiElement)classReference, name, key);
            }
        }
        return null;
    }

    public void visitPhpExpression(PhpExpression expression) {
    }

    public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
        this.addType((PsiElement)expression.extract());
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        IElementType o = expression.getOperationType();
        if (o == PhpTokenTypes.opCONCAT) {
            this.addType(PhpType.STRING);
        }
        if (PhpTokenTypes.opSHIFT_RIGHT == o || PhpTokenTypes.opSHIFT_LEFT == o) {
            this.addType(PhpType.INT);
        } else if (PhpTokenTypes.tsBIT_BINARY_OPS.contains(o)) {
            PhpType left = new PhpType().add(expression.getLeftOperand());
            PhpType right = new PhpType().add(expression.getRightOperand());
            if (left.equals((Object)PhpType.STRING) && right.equals((Object)PhpType.STRING)) {
                this.addType(PhpType.STRING);
            } else if (PhpTypeAnalyserVisitor.isUnresolvedWithoutString(left) || PhpTypeAnalyserVisitor.isUnresolvedWithoutString(right)) {
                this.addType(PhpType.INT);
            } else {
                this.addType(PhpType.INT);
                this.addType(PhpType.STRING);
            }
        } else if (PhpTokenTypes.tsLOGICAL_OPS.contains(o) || PhpTokenTypes.tsCOMPARE_OPS.contains(o)) {
            if (o == PhpTokenTypes.opSPACESHIP) {
                this.addType(PhpType.INT);
            } else {
                this.addType(PhpType.BOOLEAN);
            }
        } else if (o == PhpTokenTypes.opREM || PhpTokenTypes.tsBIT_OPS.contains(o)) {
            this.addType(PhpType.INT);
        } else if (PhpTokenTypes.tsCOMPARE_OPS.contains(o)) {
            this.addType(PhpType.BOOLEAN);
        } else if (PhpTokenTypes.tsMATH_OPS.contains(o)) {
            PsiElement rightOperand = expression.getRightOperand();
            PsiElement leftOperand = expression.getLeftOperand();
            if (PhpPsiUtil.isOfType(rightOperand, PhpElementTypes.NUMBER) && PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)((PhpTypedElement)rightOperand).getType()) || PhpPsiUtil.isOfType(leftOperand, PhpElementTypes.NUMBER) && PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)((PhpTypedElement)leftOperand).getType())) {
                this.addType(PhpType.FLOAT);
                return;
            }
        }
        if (o == PhpTokenTypes.opDIV || o == PhpTokenTypes.opMUL) {
            this.addType(PhpType.INT);
            this.addType(PhpType.FLOAT);
        }
        if (this.type.isEmpty()) {
            PhpTypedElement rightOperand;
            PhpTypedElement leftOperand = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getLeftOperand(), PhpTypedElement.class);
            if (leftOperand != null) {
                PhpType leftOperandType = leftOperand.getType();
                if (o == PhpTokenTypes.opCOALESCE) {
                    this.addType(leftOperandType.filterNull());
                } else {
                    this.addType(leftOperandType);
                }
            }
            if ((rightOperand = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getRightOperand(), PhpTypedElement.class)) != null) {
                this.addType(rightOperand.getType());
            }
        }
    }

    private void addBitwiseOperatorType(PhpType operands) {
        if (operands.getTypes().stream().anyMatch(t -> !PhpType.isUnresolved((String)t) && !PhpType.isString((String)t))) {
            this.addType(PhpType.INT);
        } else if (PhpType.STRING.equals((Object)operands)) {
            this.addType(PhpType.STRING);
        } else {
            this.addType(PhpType.STRING);
            this.addType(PhpType.INT);
        }
    }

    public void visitPhpTernaryExpression(TernaryExpression expression) {
        this.type = new PhpType();
        PhpType trueType = new PhpType().add((PsiElement)expression.getTrueVariant());
        PhpType falseType = new PhpType().add((PsiElement)expression.getFalseVariant());
        this.type.add(expression.isShort() ? trueType.filterNull() : trueType);
        this.type.add(falseType);
        if (trueType.isEmpty() != falseType.isEmpty()) {
            this.type.add(PhpType.MIXED);
        }
    }

    public void visitPhpParameter(Parameter parameter) {
        this.addType(parameter.getLocalType());
    }

    public void visitPhpNewExpression(NewExpression value) {
        ClassReference reference = value.getClassReference();
        if (reference != null) {
            PhpType resolvedType = reference.resolveLocalType();
            if (!resolvedType.isEmpty()) {
                this.addType(resolvedType);
            } else {
                this.addType(PhpType.MIXED);
            }
        } else {
            PhpPsiElement child = value.getFirstPsiChild();
            if (child instanceof PhpClass) {
                this.addType((PsiElement)child);
            }
        }
    }

    public void visitPhpFunction(Function function) {
        this.addType(function.getLocalType(false));
    }

    public void visitPhpMethod(Method method) {
        this.addType(method.getLocalType(false));
    }

    public void visitPhpField(Field field) {
        PhpType declaredType = !field.isConstant() ? field.getDeclaredType() : PhpType.EMPTY;
        PhpType docType = field.getDocType();
        PhpClass phpClass = field.getContainingClass();
        if (phpClass != null) {
            MultiMap<String, FieldReference> accessMap = PhpClassImpl.getConstructorAssignmentsPerField(phpClass);
            for (FieldReference fieldReference : accessMap.get((Object)field.getName())) {
                if (fieldReference == null) continue;
                this.addInferredType(fieldReference);
            }
            if (!this.type.isEmpty() && PhpTypeAnalyserVisitor.fieldAssignmentAlwaysReachable(field)) {
                this.addType(PhpTypeAnalyserVisitor.getTypeWithoutOverridingGenericArrays(this.type, declaredType));
                this.addType(docType);
                return;
            }
        }
        PhpType typeFromDeclarations = new PhpType().add(declaredType).add(docType);
        this.addType(PhpTypeAnalyserVisitor.getTypeWithoutOverridingGenericArrays(docType, PhpTypeAnalyserVisitor.filterFalseFromDefaultValueTypeIfNeeded(typeFromDeclarations, field.getDefaultValue()).add(declaredType)));
        this.addType(docType);
    }

    @NotNull
    private static PhpType filterFalseFromDefaultValueTypeIfNeeded(PhpType declaredType, @Nullable PsiElement defaultValue) {
        PhpType defaultValueType = new PhpType().add(defaultValue);
        PhpType phpType = !PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.FALSE) ? ParameterImpl.replaceFalseWithBoolean(defaultValueType) : defaultValueType;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    private static PhpType getTypeWithoutOverridingGenericArrays(PhpType toSearchPlurals, PhpType toAddWithoutOverridingArrays) {
        return toSearchPlurals.getTypes().stream().anyMatch(PhpType::isPluralType) ? toAddWithoutOverridingArrays.filterOut(PhpType::isArray) : toAddWithoutOverridingArrays;
    }

    public static boolean fieldAssignmentAlwaysReachable(final @NotNull Field field) {
        if (field == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(10);
        }
        if (!field.getModifier().isPrivate()) {
            return false;
        }
        PhpClass phpClass = field.getContainingClass();
        if (phpClass == null) {
            return false;
        }
        Method constructor = phpClass.getOwnConstructor();
        if (constructor == null) {
            return false;
        }
        final Ref canBeUndefined = new Ref((Object)Boolean.FALSE);
        PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)constructor.getControlFlow().getExitPoint(), false, new PhpInstructionProcessor(){

            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                FieldReference anchor = instruction.getFieldReference();
                if (anchor != null && PhpTypeAnalyserVisitor.isReferenceTo(anchor, field) && instruction.getAccess().isWrite()) {
                    Collection fieldReferencesInAssignmentValue;
                    AssignmentExpression condition = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)anchor, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
                    return condition != null && condition.getVariable() == anchor && ContainerUtil.exists((Iterable)(fieldReferencesInAssignmentValue = PsiTreeUtil.findChildrenOfAnyType((PsiElement)condition.getValue(), (boolean)false, (Class[])new Class[]{FieldReference.class})), r -> PhpTypeAnalyserVisitor.isReferenceTo(r, field));
                }
                return super.processAccessFieldByVariableInstruction(instruction);
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                canBeUndefined.set((Object)true);
                return super.processEntryPointInstruction(instruction);
            }
        });
        return canBeUndefined.get() == Boolean.FALSE;
    }

    private static boolean isReferenceTo(FieldReference anchor, @NotNull Field field) {
        if (field == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(11);
        }
        return anchor.resolveLocal().contains(field);
    }

    public void visitPhpClassReference(ClassReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpReturnType(PhpReturnType returnType) {
        this.addType(returnType.getType());
    }

    public void visitPhpMethodReference(MethodReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpClassConstantReference(ClassConstantReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpFieldReference(FieldReference fieldReference) {
        if (this.addInferredType(fieldReference)) {
            Collection elements = fieldReference.resolveLocal();
            if (elements.isEmpty()) {
                for (String s : StringUtil.split((String)fieldReference.getSignature(), (String)"|")) {
                    this.addType(PhpOptionalCompletionTP.TYPE_KEY.sign((CharSequence)s));
                }
            }
            for (PhpNamedElement element : elements) {
                this.addType(element.getDocType());
                this.addType(PhpTypeAnalyserVisitor.getTypeWithoutOverridingGenericArrays(this.getType(), element.getDeclaredType()));
            }
            return;
        }
        this.visitPhpReference((PhpReference)fieldReference);
    }

    public boolean addInferredType(FieldReference fieldReference) {
        CharSequence fieldName = fieldReference.getNameCS();
        if (!StringUtil.isEmpty((CharSequence)fieldName)) {
            boolean finish = this.addTypeFromExpression((PhpExpression)fieldReference);
            if (finish) {
                return true;
            }
            PhpExpression reference = fieldReference.getClassReference();
            if (reference instanceof ClassReference) {
                PhpAccessFieldInObjectContextInstruction instruction;
                if (PhpLangUtil.isSelfReference((ClassReference)reference) && (instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldInObjectContextInstruction.class)) != null) {
                    PhpFieldReferenceInObjectContextTypeAnalyzer processor = new PhpFieldReferenceInObjectContextTypeAnalyzer(fieldName);
                    PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor);
                    PhpType phpType = processor.getType();
                    if (!phpType.isEmpty()) {
                        this.addType(phpType);
                    }
                }
            } else if (reference != null) {
                CharSequence variableName = reference instanceof Variable ? ((Variable)reference).getNameCS() : null;
                PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldByVariableInstruction.class);
                if (instruction != null) {
                    PhpFieldReferenceByVariableTypeAnalyzer processor = new PhpFieldReferenceByVariableTypeAnalyzer(instruction, fieldName, variableName);
                    PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor);
                    PhpType phpType = processor.getType();
                    if (!phpType.isEmpty()) {
                        this.addType(phpType);
                        return !processor.isAmbiguousResult();
                    }
                }
            }
        }
        return false;
    }

    public void visitPhpConstantReference(ConstantReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpFunctionCall(FunctionReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpDocType(PhpDocType type) {
        this.addType(PhpDocTypeImpl.getType((PhpReference)type, type.getText()));
    }

    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        for (PhpMatchArm arm : matchExpression.getMatchArms()) {
            PhpExpression bodyExpression = arm.getBodyExpression();
            if (bodyExpression == null) continue;
            this.addType(bodyExpression.getType());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curAnchor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeAnalyserVisitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeAnalyserVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumericTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "inferDocType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "inferVariableType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFalseFromDefaultValueTypeIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolvedWithoutString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fieldAssignmentAlwaysReachable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

