/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class PhpTraitSignatureTP
implements PhpTypeProvider3 {
    public static final char SEPARATOR = '.';

    public char getKey() {
        return '\u2020';
    }

    @Nullable
    public PhpType getType(PsiElement e) {
        if (e instanceof ClassReference) {
            PhpClass phpClass;
            PhpType result = new PhpType();
            String className = ((ClassReference)e).getFQN();
            if (PhpLangUtil.isClassNameSpecial(className) && (phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)e, PhpClass.class)) != null && phpClass.isTrait()) {
                PhpType type = result.add("#" + this.getKey() + "#C" + phpClass.getFQN() + "." + className);
                return type;
            }
        }
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        int separator = expression.lastIndexOf(46);
        if (separator >= 0) {
            String refSignature = expression.substring(0, separator);
            PhpIndex index = PhpIndex.getInstance((Project)project);
            Collection context = index.getBySignature(refSignature);
            Collection result = context.stream().filter(c -> c instanceof PhpClass && ((PhpClass)c).isTrait()).map(c -> index.getTraitUsages((PhpClass)c)).flatMap(Collection::stream).flatMap(phpClass -> phpClass.getSuperClasses().stream()).filter(Objects::nonNull).collect(Collectors.toList());
            return result;
        }
        return null;
    }
}

