/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.google.common.base.Predicates;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaTypeMappingsTable;
import com.jetbrains.php.lang.psi.resolve.types.PhpPotentialGlobalEntryTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMetaTypeInferenceMappingIndex;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterBasedTypeProvider
implements PhpTypeProvider4 {
    private static final Logger LOG = Logger.getInstance(PhpParameterBasedTypeProvider.class);
    private static final Key<CachedValue<Map<String, PhpMetaTypeMappingsTable>>> STATIC_FACTORY_TYPE_MAP = new Key("STATIC_FACTORY_TYPE_MAP");
    public static final String PHPSTORM_META_PHP = ".phpstorm.meta.php";
    public static final String PATTERN_KEY = "\u03c0";
    public static final String TYPE_KEY = "\u03c0\u2020";
    public static final String ELEMENT_TYPE_KEY = "\u03c0e\u2020";
    public static final char SEPARATOR = '.';
    public static final char ESCAPED_SEPARATOR = '\u2265';
    public static final String ONE_ARG_PATTERN = "@";
    public static final String ARG_PATTERN = "$";
    public static final String PARAM_SEPARATATOR = "~";
    private static final String ESCAPED_TYPES_SEPARATOR = "\u00b1";
    private static final char NAMED_ARGUMENT_SEPARATOR = '\u1932';
    private static final String PARAM_END_SYMBOL = "&";

    public char getKey() {
        return '\u03c0';
    }

    @Nullable
    public PhpType getType(PsiElement e) {
        String param;
        String subject = null;
        PsiElement[] parameters = null;
        if (e instanceof FunctionReference) {
            String name;
            if (e instanceof MethodReference && (name = ((MethodReference)e).getName()) == null) {
                return null;
            }
            parameters = ((FunctionReference)e).getParameters();
            if (parameters.length == 0) {
                return null;
            }
            subject = ((FunctionReference)e).getSignature();
        } else if (e instanceof ArrayAccessExpression) {
            PhpPsiElement value = ((ArrayAccessExpression)e).getValue();
            if (value instanceof PhpReference) {
                subject = ((PhpReference)value).getSignature();
                PsiElement[] types = StringUtil.split((String)subject, (String)"|");
                if (types.stream().anyMatch(PhpType::isPluralType)) {
                    PhpType type = new PhpType();
                    types.forEach(arg_0 -> ((PhpType)type).add(arg_0));
                    return type.elementType();
                }
                ArrayIndex index = ((ArrayAccessExpression)e).getIndex();
                if (index != null) {
                    parameters = new PsiElement[]{index.getValue()};
                }
            }
        } else if (e instanceof FieldReference) {
            subject = ((FieldReference)e).getSignature();
            parameters = PsiElement.EMPTY_ARRAY;
        }
        if (parameters == null || StringUtil.isEmpty((String)subject) || PhpType.isPrimitiveClassAccess((String)subject)) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (PsiElement parameter : parameters) {
            PsiElement identifier;
            Object signature = PhpParameterBasedTypeProvider.getParameterSignature(parameter, e);
            if (((String)signature).contains("|")) {
                signature = this.removeNestedMetaCalls((String)signature);
            }
            if ((identifier = ParameterListImpl.getNameIdentifier(parameter)) != null) {
                signature = (String)signature + "\u1932" + identifier.getText();
            }
            params.add((String)signature);
        }
        String string = param = params.isEmpty() ? "\u00f8" : StringUtil.join(params, (String)PARAM_SEPARATATOR);
        if (params.isEmpty() && !(e instanceof FieldReference)) {
            return null;
        }
        if (subject.length() > 200 || param.length() > 300) {
            return null;
        }
        PhpType result = new PhpType();
        String finalParam = param + PARAM_END_SYMBOL;
        StringUtil.split((String)subject, (String)"|").stream().filter(s -> !s.contains("#\u03c0")).map(s -> "#" + this.getKey() + s + "\u2265" + finalParam).forEach(arg_0 -> ((PhpType)result).add(arg_0));
        return result;
    }

    @NotNull
    private String removeNestedMetaCalls(String signature) {
        String string = StringUtil.split((String)signature, (String)"|").stream().filter(s -> !s.contains("#\u03c0")).collect(Collectors.joining(ESCAPED_TYPES_SEPARATOR));
        if (string == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getParameterSignature(PsiElement parameter, PsiElement originalReference) {
        if (parameter instanceof StringLiteralExpression) {
            String string = ((StringLiteralExpression)parameter).getContents();
            if (string == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (parameter instanceof NewExpression) {
            ClassReference reference = ((NewExpression)parameter).getClassReference();
            if (reference != null) {
                String string = StringUtil.notNullize((String)reference.getFQN());
                if (string == null) {
                    PhpParameterBasedTypeProvider.$$$reportNull$$$0(2);
                }
                return string;
            }
        } else {
            if (parameter instanceof PhpExpressionImpl && PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER)) {
                String string = originalReference instanceof ArrayAccessExpression ? PhpPsiUtil.getLiteralText(parameter) : ((PhpExpressionImpl)parameter).getNumberType();
                if (string == null) {
                    PhpParameterBasedTypeProvider.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (parameter instanceof ClassConstantReference && StringUtil.equals((CharSequence)"class", (CharSequence)((ClassConstantReference)parameter).getNameCS())) {
                ClassReference reference = (ClassReference)((ClassConstantReference)parameter).getClassReference();
                if (reference != null) {
                    String string = StringUtil.notNullize((String)reference.getFQN());
                    if (string == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(4);
                    }
                    return string;
                }
            } else {
                if (parameter instanceof ConstantReference || parameter instanceof ClassConstantReference) {
                    String string = ((PhpReference)parameter).getSignature();
                    if (string == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(5);
                    }
                    return string;
                }
                if (parameter instanceof Variable) {
                    String string = PhpParameterBasedTypeProvider.signatures((Variable)parameter).collect(Collectors.joining("|"));
                    if (string == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(6);
                    }
                    return string;
                }
                if (parameter instanceof ArrayCreationExpression) {
                    HashSet<String> signatures = new HashSet<String>();
                    for (PhpPsiElement child : ArrayCreationExpressionImpl.children((ArrayCreationExpression)parameter)) {
                        PhpTypedElement element = (PhpTypedElement)ObjectUtils.tryCast((Object)(child instanceof ArrayHashElement ? ((ArrayHashElement)child).getValue() : child.getFirstPsiChild()), PhpTypedElement.class);
                        if (element instanceof Variable) {
                            PhpParameterBasedTypeProvider.signatures((Variable)element).forEach(signatures::add);
                            continue;
                        }
                        if (element instanceof StringLiteralExpression || PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER)) {
                            signatures.addAll(new PhpType().add((PsiElement)element).getTypes());
                            continue;
                        }
                        signatures.add(PhpParameterBasedTypeProvider.getParameterSignature((PsiElement)element, parameter));
                    }
                    String string = signatures.stream().map(s -> PhpType.pluralise((String)s, (int)1)).collect(Collectors.joining("|"));
                    if (string == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                if (parameter instanceof PhpReference) {
                    String string = ((PhpReference)parameter).getSignature();
                    if (string == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(8);
                    }
                    return string;
                }
            }
        }
        return "";
    }

    private static Stream<String> signatures(Variable parameter) {
        List types = ContainerUtil.filter((Collection)PhpParameterBasedTypeProvider.inferTypeIgnoreInitialBackEdges(parameter).getTypes(), type -> PhpType.isPrimitiveType((String)type) || !PhpType.isUnresolved((String)type) && PhpType.isPluralType((String)type));
        Collection<String> signature = VariableImpl.getSignatures((VariableImpl)parameter);
        return StreamEx.of((Collection)types).append(signature);
    }

    static boolean hasMethodCandidates(Map<String, PhpMetaTypeMappingsTable> methods, String name) {
        String finalName = "." + name;
        return methods.keySet().stream().noneMatch(s -> s.startsWith("#M") && s.endsWith(finalName));
    }

    private static boolean hasNoFunctionOverride(Map<String, PhpMetaTypeMappingsTable> methods, String subject) {
        return StringUtil.split((String)subject, (String)"|").stream().noneMatch(methods::containsKey);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        int separator = expression.indexOf(8805);
        if (separator >= 0) {
            String refSignature = PhpParameterBasedTypeProvider.completeSubject(project, expression.substring(0, separator));
            PhpNamedElement target = PhpParameterBasedTypeProvider.getTarget(refSignature, visited, depth, project);
            PhpMetaTypeMappingsTable types = PhpParameterBasedTypeProvider.getTargets(refSignature, project, target);
            PhpIndex index = PhpIndex.getInstance((Project)project);
            if (types != null) {
                Collection<String> type;
                String key = PhpParameterBasedTypeProvider.getKeysSignature(expression, separator);
                List<String> keys = PhpParameterBasedTypeProvider.getKeys(refSignature, target, key);
                Collection<PhpPassedArgument> passedArguments = PhpParameterBasedTypeProvider.convertFromNamedToPositional(keys, target);
                List typesFromMappedArguments = PhpParameterBasedTypeProvider.getTypesFromMappedArguments(types, passedArguments).collect(Collectors.toList());
                Collection<String> collection = type = typesFromMappedArguments.isEmpty() ? Collections.emptyList() : Collections.singleton(StringUtil.join(typesFromMappedArguments, (String)"|"));
                if (type.isEmpty() && (key.startsWith("#D") || key.startsWith("#K"))) {
                    Collection signature = index.getBySignature(key);
                    for (PhpNamedElement element : signature) {
                        if (element instanceof Constant) {
                            type = types.get(StringUtil.unquoteString((String)StringUtil.defaultIfEmpty((String)((Constant)element).getValuePresentation(), (String)"")));
                        }
                        if (!(element instanceof Field)) continue;
                        type = types.get(StringUtil.unquoteString((String)StringUtil.defaultIfEmpty((String)((Field)element).getDefaultValuePresentation(), (String)"")));
                    }
                }
                return PhpParameterBasedTypeProvider.computeMappedType(types, index, key, passedArguments, type);
            }
        }
        return Collections.emptySet();
    }

    private static List<PhpNamedElement> computeMappedType(PhpMetaTypeMappingsTable types, PhpIndex index, String key, Collection<PhpPassedArgument> passedArguments, Collection<String> type) {
        if (type.isEmpty()) {
            type = types.get(PATTERN_KEY);
            if (!type.isEmpty()) {
                String firstType = (String)ContainerUtil.getFirstItem(type);
                for (PhpPassedArgument argument : passedArguments) {
                    firstType = StringUtil.replace((String)firstType, (String)(ARG_PATTERN + argument.myIndex), (String)argument.myArgument);
                }
                type = Collections.singleton(StringUtil.replace((String)firstType, (String)ONE_ARG_PATTERN, (String)PhpParameterBasedTypeProvider.findMappedParameter(passedArguments, 0)));
            } else {
                type = types.get(TYPE_KEY);
                if (!type.isEmpty()) {
                    type = type.stream().map(s -> StringUtil.parseInt((String)s, (int)Integer.MAX_VALUE)).map(i -> PhpParameterBasedTypeProvider.findMappedParameter(passedArguments, i)).collect(Collectors.toSet());
                } else {
                    type = types.get(ELEMENT_TYPE_KEY);
                    if (!type.isEmpty()) {
                        type = Collections.singleton(new PhpType().add(key).elementType().toString());
                    }
                }
            }
        }
        if (type.isEmpty()) {
            type = Collections.singleton(PhpParameterBasedTypeProvider.findMappedParameter(passedArguments, 0));
        }
        return type.stream().flatMap(t -> PhpParameterBasedTypeProvider.computeMappedType(index, t)).collect(Collectors.toList());
    }

    private static Stream<PhpNamedElement> computeMappedType(PhpIndex index, String type) {
        return StringUtil.split((String)type, (String)"|").stream().flatMap(s -> s.contains("#") ? index.getBySignature(s).stream() : index.getAnyByFQN(s).stream());
    }

    @NotNull
    private static List<String> getKeys(String refSignature, PhpNamedElement target, String key) {
        List keys;
        List list = keys = "\u00f8".equals(key) ? Collections.emptyList() : StringUtil.split((String)key, (String)PARAM_SEPARATATOR, (boolean)true, (boolean)false);
        if (keys.isEmpty() && target instanceof Method && refSignature.length() > 1 && PhpTypeSignatureKey.FIELD.is(refSignature.charAt(1))) {
            int dotIndex = refSignature.lastIndexOf(".");
            assert (dotIndex >= 0);
            String fieldName = refSignature.substring(dotIndex + 1);
            List<String> list2 = Collections.singletonList(fieldName);
            if (list2 == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List list3 = keys;
        if (list3 == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(10);
        }
        return list3;
    }

    private static Stream<String> getTypesFromMappedArguments(PhpMetaTypeMappingsTable mappings, Collection<PhpPassedArgument> arguments) {
        return arguments.stream().flatMap(a -> mappings.get(a.myArgument, a.myIndex).stream()).filter(Predicates.not(Objects::isNull));
    }

    @Nullable
    private static PhpMetaTypeMappingsTable getTargets(String refSignature, Project project, PhpNamedElement target) {
        PhpClass aClass;
        Map<String, PhpMetaTypeMappingsTable> methods = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(project);
        if (methods == null) {
            return null;
        }
        Ref types = new Ref();
        if (target instanceof Method) {
            PhpParameterBasedTypeProvider.fillMemberType(methods, (Ref<PhpMetaTypeMappingsTable>)types, (Method)target);
            if (types.isNull()) {
                PhpClassHierarchyUtils.processSuperMethods((Method)((Method)target), (classMember, subClass, baseClass) -> PhpParameterBasedTypeProvider.fillMemberType(methods, (Ref<PhpMetaTypeMappingsTable>)types, classMember));
            }
        } else if (target instanceof Function) {
            types.set((Object)methods.get(PhpTypeSignatureKey.getSignature((Function)((Function)target))));
        } else if (target instanceof PhpClass) {
            PhpMetaTypeMappingsTable value = methods.get(refSignature);
            if (value != null) {
                types.set((Object)value);
            } else {
                types.set((Object)PhpParameterBasedTypeProvider.getClassTargetWithinHierarchy(methods, (PhpClass)target));
            }
        } else if ((target instanceof Variable || target instanceof Field) && (aClass = (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getBySignature("#C" + target.getType().toStringResolved()))) != null) {
            types.set((Object)PhpParameterBasedTypeProvider.getClassTargetWithinHierarchy(methods, aClass));
        }
        return (PhpMetaTypeMappingsTable)types.get();
    }

    private static boolean fillMemberType(Map<String, PhpMetaTypeMappingsTable> methods, Ref<PhpMetaTypeMappingsTable> types, Method method) {
        PhpMetaTypeMappingsTable value = methods.get(PhpTypeSignatureKey.getSignature((Function)method));
        if (value != null) {
            PhpMetaTypeMappingsTable mergedTable = new PhpMetaTypeMappingsTable();
            mergedTable.putAll(value);
            if (!types.isNull()) {
                mergedTable.putAll((PhpMetaTypeMappingsTable)types.get());
            }
            types.set((Object)mergedTable);
        }
        return types.isNull();
    }

    private static PhpNamedElement getTarget(String refSignature, Set<String> visited, int depth, Project project) {
        Optional targets = StringUtil.split((String)refSignature, (String)"|").stream().flatMap(s -> PhpIndex.getInstance((Project)project).getBySignature(s, visited, depth + 1).stream()).findFirst();
        return targets.orElse(null);
    }

    private static PhpMetaTypeMappingsTable getClassTargetWithinHierarchy(Map<String, PhpMetaTypeMappingsTable> methods, PhpClass aClass) {
        Ref types = new Ref();
        PhpClassHierarchyUtils.processSupers((PhpClass)aClass, (boolean)true, (boolean)false, aClass1 -> {
            types.set((Object)((PhpMetaTypeMappingsTable)methods.get("#C" + aClass1.getFQN())));
            return types.isNull();
        });
        return (PhpMetaTypeMappingsTable)types.get();
    }

    @Nullable
    public static Map<String, PhpMetaTypeMappingsTable> getStaticMethodTypesMap(Project project) {
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, STATIC_FACTORY_TYPE_MAP, () -> {
            LOG.debug("COMPUTING MethodTypesMap");
            Map<String, PhpMetaTypeMappingsTable> newMeta = PhpMetaTypeInferenceMappingIndex.getMap(project);
            THashMap result = new THashMap();
            for (Map.Entry<String, PhpMetaTypeMappingsTable> entry : newMeta.entrySet()) {
                PhpMetaTypeMappingsTable current = (PhpMetaTypeMappingsTable)result.get(entry.getKey());
                if (current != null) {
                    current.putAll(entry.getValue());
                    continue;
                }
                current = entry.getValue();
                result.put(entry.getKey(), current);
            }
            LOG.debug("DONE COMPUTING MethodTypesMap => " + result.size());
            return new CachedValueProvider.Result(Collections.unmodifiableMap(result), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    public static boolean isMeta(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(11);
        }
        return (psiFile = element.getContainingFile()) instanceof PhpFile && PhpParameterBasedTypeProvider.isMeta(psiFile.getVirtualFile());
    }

    public static boolean isMeta(@NotNull PsiFile file) {
        if (file == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(12);
        }
        if (!(file instanceof PhpFile)) {
            return false;
        }
        if (PhpLangUtil.equalsIgnoreCase(file.getName(), PHPSTORM_META_PHP)) {
            return true;
        }
        return PhpParameterBasedTypeProvider.isMeta(file.getVirtualFile());
    }

    public static boolean isMeta(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (PhpLangUtil.equalsIgnoreCase(file.getNameSequence(), PHPSTORM_META_PHP)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && PhpLangUtil.equalsIgnoreCase(parent.getNameSequence(), PHPSTORM_META_PHP);
    }

    @NotNull
    private static PhpType inferTypeIgnoreInitialBackEdges(@NotNull Variable variable) {
        if (variable == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(13);
        }
        PhpType phpType = PhpTypeInfo.getTypeFromAST((PsiElement)variable, new PhpTypeAnalyserVisitor(){

            @Override
            @NotNull
            public PhpType inferVariableType(Variable variable, CharSequence variableName, PhpInstruction instruction, PhpScopeHolder scopeHolder) {
                if (PhpLangUtil.isThisReference((PsiElement)variable)) {
                    PhpType phpType = PhpType.EMPTY;
                    if (phpType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return phpType;
                }
                PhpVariableInferredTypeAnalyzerProcessor processor = new PhpVariableInferredTypeAnalyzerProcessor(variable, variableName, scopeHolder, instruction);
                PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, processor);
                PhpType phpType = ((PhpTypeAnalyzerProcessor)processor).getType();
                if (phpType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return phpType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider$1", "inferVariableType"));
            }
        });
        if (phpType == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        PhpType type = PhpParameterBasedTypeProvider.getType(expression, project);
        return type != null ? type.global(project) : null;
    }

    @Nullable
    private static PhpType getType(String expression, Project project) {
        PhpMetaTypeMappingsTable map;
        int separatorIndex = expression.indexOf(8805);
        if (separatorIndex < 0) {
            return null;
        }
        String subject = PhpParameterBasedTypeProvider.completeSubject(project, expression.substring(2, separatorIndex));
        String param = PhpParameterBasedTypeProvider.getKeysSignature(expression, separatorIndex);
        Map<String, PhpMetaTypeMappingsTable> methods = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(project);
        if (PhpParameterBasedTypeProvider.hasNoOverrides(subject, methods)) {
            return null;
        }
        List params = "\u00f8".equals(param) ? Collections.emptyList() : StringUtil.split((String)param, (String)PARAM_SEPARATATOR, (boolean)true, (boolean)false);
        String matchedSubject = methods == null ? null : (String)ContainerUtil.find((Iterable)StringUtil.split((String)subject, (String)"|"), m -> methods.get(m) != null);
        PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = map = matchedSubject != null ? methods.get(matchedSubject) : null;
        if (map != null) {
            Function matchedFunction = (Function)ContainerUtil.find((Iterable)PhpIndex.getInstance((Project)project).getBySignature(matchedSubject), Function.class::isInstance);
            Collection<PhpPassedArgument> arguments = PhpParameterBasedTypeProvider.convertFromNamedToPositional(params, (PhpNamedElement)matchedFunction);
            return PhpParameterBasedTypeProvider.computeMappedParameterType(project, subject, map, arguments);
        }
        return null;
    }

    @NotNull
    private static String getKeysSignature(String expression, int separatorIndex) {
        String string = StringUtil.trimEnd((String)expression.substring(separatorIndex + 1), (String)PARAM_END_SYMBOL);
        if (string == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static PhpType computeMappedParameterType(Project project, String subject, PhpMetaTypeMappingsTable map, Collection<PhpPassedArgument> arguments) {
        Collection subjectFunctions;
        String target;
        block8: {
            List<String> typesFormMappedArguments = PhpParameterBasedTypeProvider.getTypesFromMappedArguments(map, arguments).collect(Collectors.toList());
            if (!typesFormMappedArguments.isEmpty()) {
                PhpType type = new PhpType();
                typesFormMappedArguments.forEach(arg_0 -> ((PhpType)type).add(arg_0));
                return type;
            }
            target = (String)ContainerUtil.getFirstItem(map.get(PATTERN_KEY));
            if (target != null) {
                for (PhpPassedArgument argument : arguments) {
                    target = StringUtil.replace((String)target, (String)(ARG_PATTERN + argument.myIndex), (String)argument.myArgument);
                }
                target = StringUtil.replace((String)target, (String)ONE_ARG_PATTERN, (String)PhpParameterBasedTypeProvider.findMappedParameter(arguments, 0));
                return PhpParameterBasedTypeProvider.addParamType(target);
            }
            Collection<String> targets = map.get(TYPE_KEY);
            subjectFunctions = PhpIndex.getInstance((Project)project).getBySignature(subject);
            if (targets.isEmpty()) break block8;
            PhpType t = new PhpType();
            for (String s : targets) {
                PhpType paramTypeGlobal;
                String mappedParam;
                block11: {
                    Collection<Parameter> parameters;
                    block9: {
                        block10: {
                            int idx = StringUtil.parseInt((String)s, (int)Integer.MAX_VALUE);
                            mappedParam = PhpParameterBasedTypeProvider.findMappedParameter(arguments, idx);
                            paramTypeGlobal = PhpParameterBasedTypeProvider.addParamType(mappedParam).global(project).filterUnknown();
                            parameters = PhpParameterBasedTypeProvider.getParameters(idx, subjectFunctions);
                            if (parameters.isEmpty() || !ContainerUtil.all(parameters, Parameter::isVariadic)) break block9;
                            paramTypeGlobal = new PhpType();
                            if (StringUtil.isEmpty((String)mappedParam)) break block10;
                            if (PhpParameterBasedTypeProvider.addTypesFromVariadic(project, arguments, subjectFunctions, paramTypeGlobal)) break block11;
                        }
                        parameters.forEach(arg_0 -> ((PhpType)t).add(arg_0));
                        break block11;
                    }
                    if (paramTypeGlobal.isEmpty()) {
                        parameters.forEach(arg_0 -> ((PhpType)t).add(arg_0));
                        continue;
                    }
                }
                if (!PhpParameterBasedTypeProvider.isValidMappedParam(mappedParam)) continue;
                t.add(paramTypeGlobal);
            }
            return t;
        }
        target = (String)ContainerUtil.getFirstItem(map.get(ELEMENT_TYPE_KEY));
        if (target != null) {
            int idx = StringUtil.parseInt((String)target, (int)Integer.MAX_VALUE);
            String mappedParam = PhpParameterBasedTypeProvider.findMappedParameter(arguments, idx);
            PhpType paramTypeGlobal = PhpParameterBasedTypeProvider.addParamType(mappedParam).global(project).filterUnknown().elementType();
            if (paramTypeGlobal.isEmpty()) {
                PhpType type = new PhpType();
                PhpParameterBasedTypeProvider.getParameters(idx, subjectFunctions).forEach(arg_0 -> ((PhpType)type).add(arg_0));
                return type;
            }
            if (!PhpParameterBasedTypeProvider.isValidMappedParam(mappedParam)) {
                return null;
            }
            return paramTypeGlobal;
        }
        return null;
    }

    private static boolean isValidMappedParam(String mappedParam) {
        return mappedParam.isEmpty() || mappedParam.startsWith("#") || PhpLangUtil.isFqn(mappedParam);
    }

    private static boolean addTypesFromVariadic(Project project, Collection<PhpPassedArgument> arguments, Collection<? extends PhpNamedElement> subjectFunctions, PhpType type) {
        if (arguments.isEmpty()) {
            return false;
        }
        boolean noUnresolvedTypesFromArguments = true;
        for (PhpPassedArgument argument : arguments) {
            Collection<Parameter> resolvedParameters = PhpParameterBasedTypeProvider.getParameters(argument.myIndex, subjectFunctions);
            if (!ContainerUtil.all(resolvedParameters, Parameter::isVariadic)) continue;
            String mappedParam = PhpParameterBasedTypeProvider.findMappedParameter(arguments, argument.myIndex);
            PhpType paramTypeGlobal = PhpParameterBasedTypeProvider.addParamType(mappedParam).global(project).filterUnknown().filterMixed();
            if (paramTypeGlobal.isEmpty()) {
                noUnresolvedTypesFromArguments = false;
                continue;
            }
            type.add(paramTypeGlobal);
        }
        return noUnresolvedTypesFromArguments;
    }

    private static String findMappedParameter(Collection<PhpPassedArgument> arguments, int i) {
        PhpPassedArgument firstArgument = (PhpPassedArgument)ContainerUtil.find(arguments, a -> a.myIndex == i);
        return firstArgument != null ? firstArgument.myArgument : "";
    }

    private static Collection<PhpPassedArgument> convertFromNamedToPositional(List<String> arguments, PhpNamedElement matchedFunction) {
        List parameters = matchedFunction instanceof Function ? Arrays.asList(((Function)matchedFunction).getParameters()) : Collections.emptyList();
        ArrayList<PhpPassedArgument> passedArguments = new ArrayList<PhpPassedArgument>();
        Parameter lastParameter = (Parameter)ContainerUtil.getLastItem(parameters);
        boolean variadic = lastParameter != null && lastParameter.isVariadic();
        for (int i = 0; i < arguments.size(); ++i) {
            String argument = arguments.get(i);
            int namedArgumentSeparator = argument.lastIndexOf(6450);
            if (namedArgumentSeparator >= 0) {
                String argumentWithoutName = argument.substring(0, namedArgumentSeparator);
                String name = argument.substring(namedArgumentSeparator + 1);
                int parameterIndex = ContainerUtil.indexOf(parameters, p -> PhpLangUtil.equalsParameterNames(name, p.getName()));
                if (parameterIndex < 0 && variadic) {
                    parameterIndex = parameters.size() - 1;
                }
                if (parameterIndex >= 0) {
                    passedArguments.add(new PhpPassedArgument(argumentWithoutName, parameterIndex));
                    continue;
                }
            }
            passedArguments.add(new PhpPassedArgument(argument, i));
        }
        return passedArguments;
    }

    private static String completeSubject(Project project, String incompleteSubject) {
        if (incompleteSubject.startsWith("#") && PhpPotentialGlobalEntryTP.TYPE_KEY.is(incompleteSubject.charAt(1))) {
            PhpNamedElement item = (PhpNamedElement)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getBySignature(incompleteSubject));
            if (item instanceof Function) {
                return PhpTypeSignatureKey.getSignature((Function)((Function)item));
            }
            if (item instanceof Constant) {
                return PhpTypeSignatureKey.CONSTANT.sign((CharSequence)item.getFQN());
            }
        }
        return incompleteSubject;
    }

    @NotNull
    private static PhpType addParamType(String mappedParam) {
        PhpType type = new PhpType();
        StringUtil.split((String)mappedParam, (String)ESCAPED_TYPES_SEPARATOR).forEach(arg_0 -> ((PhpType)type).add(arg_0));
        PhpType phpType = type;
        if (phpType == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(16);
        }
        return phpType;
    }

    private static Collection<Parameter> getParameters(int idx, Collection<? extends PhpNamedElement> functions) {
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        for (PhpNamedElement phpNamedElement : functions) {
            if (!(phpNamedElement instanceof Function)) continue;
            ContainerUtil.addIfNotNull(parameters, (Object)PhpParameterBasedTypeProvider.getParameter(idx, (Function)phpNamedElement));
        }
        return parameters;
    }

    @Nullable
    private static Parameter getParameter(int idx, Function element) {
        Parameter parameter = element.getParameter(idx);
        Object[] parameters = element.getParameters();
        if (parameter != null) {
            return parameter;
        }
        Parameter lastParameter = (Parameter)ArrayUtil.getLastElement((Object[])parameters);
        return lastParameter != null && lastParameter.isVariadic() ? lastParameter : parameter;
    }

    private static boolean hasNoOverrides(String subject, Map<String, PhpMetaTypeMappingsTable> methods) {
        if (subject.startsWith("#M")) {
            int i;
            String firstType = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)subject, (String)"|"));
            if (firstType != null && (i = firstType.indexOf(".")) >= 0) {
                String methodName = firstType.substring(i);
                if (methods != null && !PhpParameterBasedTypeProvider.hasMethodCandidates(methods, methodName)) {
                    return true;
                }
            }
        } else if (subject.startsWith("#F") && methods != null && PhpParameterBasedTypeProvider.hasNoFunctionOverride(methods, subject)) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNestedMetaCalls";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSignature";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeIgnoreInitialBackEdges";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysSignature";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addParamType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMeta";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeIgnoreInitialBackEdges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpPassedArgument {
        private final String myArgument;
        private final int myIndex;

        private PhpPassedArgument(String argument, int parameterIndex) {
            this.myArgument = argument;
            this.myIndex = parameterIndex;
        }
    }

    static class MyCompletionContributor
    extends CompletionContributor
    implements DumbAware {
        MyCompletionContributor() {
        }

        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                MyCompletionContributor.$$$reportNull$$$0(0);
            }
            if (result == null) {
                MyCompletionContributor.$$$reportNull$$$0(1);
            }
            ProcessingContext context = new ProcessingContext();
            PsiElement position = parameters.getPosition();
            if (parameters.getCompletionType() == CompletionType.BASIC && ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).accepts((Object)position, context)) {
                PhpMetaTypeMappingsTable metaMappings = MyCompletionContributor.getMetaMappings(position);
                Object expression = PhpPsiUtil.getParentByCondition(position, false, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
                int parameterIndex = expression != null ? Math.max(PhpWorkaroundUtil.resolveMappedParameterIndex(expression), 0) : 0;
                for (String s : metaMappings.getKeys()) {
                    if (metaMappings.get(s, parameterIndex).isEmpty()) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)s.replace('\u2265', '.')).withTypeText(StringUtil.join(metaMappings.get(s), (String)"|"), true));
                }
            }
            super.fillCompletionVariants(parameters, result);
        }

        @NotNull
        private static PhpMetaTypeMappingsTable getMetaMappings(@NotNull PsiElement position) {
            ParameterListOwner parameterListOwner;
            ArrayIndex index;
            if (position == null) {
                MyCompletionContributor.$$$reportNull$$$0(2);
            }
            if ((index = (ArrayIndex)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)position, ArrayIndex.class)) != null) {
                PhpPsiElement value;
                ArrayAccessExpression accessExpression = (ArrayAccessExpression)ObjectUtils.tryCast((Object)index.getParent(), ArrayAccessExpression.class);
                PhpPsiElement phpPsiElement = value = accessExpression != null ? accessExpression.getValue() : null;
                if (value instanceof PhpReference) {
                    PhpNamedElement target = PhpParameterBasedTypeProvider.getTarget(((PhpReference)value).getSignature(), null, 0, position.getProject());
                    PhpMetaTypeMappingsTable map = PhpParameterBasedTypeProvider.getTargets(((PhpReference)value).getSignature(), position.getProject(), target);
                    PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = (PhpMetaTypeMappingsTable)ObjectUtils.notNull((Object)map, (Object)PhpMetaTypeMappingsTable.EMPTY);
                    if (phpMetaTypeMappingsTable == null) {
                        MyCompletionContributor.$$$reportNull$$$0(3);
                    }
                    return phpMetaTypeMappingsTable;
                }
            }
            if ((parameterListOwner = (ParameterListOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)position, ParameterListOwner.class)) instanceof FunctionReference) {
                PhpNamedElement target = PhpParameterBasedTypeProvider.getTarget(((FunctionReference)parameterListOwner).getSignature(), null, 0, position.getProject());
                PhpMetaTypeMappingsTable map = PhpParameterBasedTypeProvider.getTargets(((FunctionReference)parameterListOwner).getSignature(), position.getProject(), target);
                PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = (PhpMetaTypeMappingsTable)ObjectUtils.notNull((Object)map, (Object)PhpMetaTypeMappingsTable.EMPTY);
                if (phpMetaTypeMappingsTable == null) {
                    MyCompletionContributor.$$$reportNull$$$0(4);
                }
                return phpMetaTypeMappingsTable;
            }
            PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = PhpMetaTypeMappingsTable.EMPTY;
            if (phpMetaTypeMappingsTable == null) {
                MyCompletionContributor.$$$reportNull$$$0(5);
            }
            return phpMetaTypeMappingsTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider$MyCompletionContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider$MyCompletionContributor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaMappings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fillCompletionVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetaMappings";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

