/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaTypeMappingsTable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PhpPBMetaBuilderNew {
    private static final Logger LOG = Logger.getInstance(PhpPBMetaBuilderNew.class);
    public static final Collection<String> PROCESSORS_NAMES = ContainerUtil.immutableList((Object[])new String[]{"map", "type", "elementType"});
    public static final String META_NAMESPACE_NAME = "\\PHPSTORM_META\\";
    public static final String OVERRIDE_TYPE_PROVIDER_NAME = "override";

    @NotNull
    public static Map<String, PhpMetaTypeMappingsTable> getMap(Collection<PsiFile> files) {
        HashMap<String, PhpMetaTypeMappingsTable> map = new HashMap<String, PhpMetaTypeMappingsTable>();
        Collection<FunctionReference> overrides = PhpPBMetaBuilderNew.topLevel(files, OVERRIDE_TYPE_PROVIDER_NAME);
        for (FunctionReference override : overrides) {
            FunctionReference instruction;
            PsiElement[] parameters;
            if (!META_NAMESPACE_NAME.equals(override.getNamespaceName()) || (parameters = override.getParameters()).length != 2) continue;
            PsiElement callable = parameters[0];
            FunctionReference functionReference = instruction = parameters[1] instanceof FunctionReference ? (FunctionReference)parameters[1] : null;
            if (instruction == null) continue;
            PhpReference reference = null;
            if (callable instanceof PhpReference) {
                reference = (PhpReference)callable;
            } else if (callable instanceof NewExpression) {
                reference = ((NewExpression)callable).getClassReference();
            }
            String matchSignature = reference != null ? reference.getSignature() : null;
            PhpMetaTypeMappingsTable types = (PhpMetaTypeMappingsTable)map.get(matchSignature);
            if (matchSignature != null && types == null) {
                types = new PhpMetaTypeMappingsTable();
                map.put(matchSignature, types);
            }
            PhpPBMetaBuilderNew.addMetaTypeMappings(instruction, types, PhpPBMetaBuilderNew.getParameterIndex(callable));
        }
        HashMap<String, PhpMetaTypeMappingsTable> hashMap = map;
        if (hashMap == null) {
            PhpPBMetaBuilderNew.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    private static int getParameterIndex(PsiElement callable) {
        PsiElement firstParameter;
        if (callable instanceof FunctionReference && PhpPsiUtil.isOfType(firstParameter = ((FunctionReference)callable).getParameter(0), PhpElementTypes.NUMBER)) {
            try {
                return Integer.parseInt(firstParameter.getText());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private static void addMetaTypeMappings(FunctionReference instruction, PhpMetaTypeMappingsTable types, int parameterIndex) {
        String instructionName;
        switch (instructionName = StringUtil.notNullize((String)instruction.getName())) {
            case "map": {
                PhpPBMetaBuilderNew.collectParameterValueMapping(types, instruction, parameterIndex);
                break;
            }
            case "type": {
                PhpPBMetaBuilderNew.collectParameterTypeMapping(types, instruction);
                break;
            }
            case "elementType": {
                PhpPBMetaBuilderNew.collectParameterElementTypeMapping(types, instruction);
                break;
            }
            default: {
                LOG.warn("no map for " + instructionName);
            }
        }
    }

    private static void collectParameterValueMapping(PhpMetaTypeMappingsTable types, FunctionReference f, int parameterIndex) {
        PsiElement[] parameters = f.getParameters();
        if (parameters.length != 1) {
            return;
        }
        PhpPsiElement arr = (PhpPsiElement)parameters[0];
        if (arr instanceof ArrayCreationExpression) {
            for (ArrayHashElement element : ((ArrayCreationExpression)arr).getHashElements()) {
                PhpPsiElement key = element.getKey();
                PhpPsiElement value = element.getValue();
                String className = null;
                if (value instanceof ClassConstantReference) {
                    PhpExpression classReference = ((ClassConstantReference)value).getClassReference();
                    if (classReference == null) continue;
                    className = classReference.getText();
                } else if (value instanceof StringLiteralExpression) {
                    className = ((StringLiteralExpression)value).getContents();
                }
                if (className == null) continue;
                if (key instanceof StringLiteralExpression) {
                    String k = ((StringLiteralExpression)key).getContents();
                    if (k.isEmpty()) {
                        k = "\u03c0";
                    }
                    types.put(k, className, parameterIndex);
                    continue;
                }
                if (key instanceof ConstantReference) {
                    types.put(((ConstantReference)key).getSignature(), className, parameterIndex);
                    continue;
                }
                if (!(key instanceof ClassConstantReference)) continue;
                types.put(((ClassConstantReference)key).getSignature(), className, parameterIndex);
            }
        }
    }

    private static void collectParameterTypeMapping(PhpMetaTypeMappingsTable types, FunctionReference f) {
        PsiElement[] parameters = f.getParameters();
        if (parameters.length != 1) {
            return;
        }
        PhpPsiElement r = (PhpPsiElement)parameters[0];
        types.put("\u03c0\u2020", r.getText());
    }

    private static void collectParameterElementTypeMapping(PhpMetaTypeMappingsTable types, FunctionReference f) {
        PsiElement[] parameters = f.getParameters();
        if (parameters.length != 1) {
            return;
        }
        PhpPsiElement r = (PhpPsiElement)parameters[0];
        types.put("\u03c0e\u2020", r.getText());
    }

    private static Collection<FunctionReference> topLevel(Collection<PsiFile> inputs, final String key) {
        SmartList result = new SmartList();
        for (PsiElement psiElement : inputs) {
            if (!(psiElement instanceof PhpPsiElement)) continue;
            psiElement.accept((PsiElementVisitor)new PhpRecursiveElementVisitor((Collection)result){
                final /* synthetic */ Collection val$result;
                {
                    this.val$result = collection;
                }

                public void visitPhpFunctionCall(FunctionReference reference) {
                    if (key.equals(reference.getName())) {
                        this.val$result.add(reference);
                    }
                }
            });
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpPBMetaBuilderNew", "getMap"));
    }
}

