/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExcludeTypeTP
implements PhpTypeProvider4 {
    public static final Logger LOG = Logger.getInstance(PhpExcludeTypeTP.class);

    public char getKey() {
        return '-';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        return null;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        int c = PhpType.getPluralDimension((String)expression);
        int i = (expression = PhpType.unpluralize((String)expression, (int)c)).lastIndexOf("\u2206");
        if (i <= 0) {
            LOG.warn("Invalid exclusion signature: " + expression);
            return null;
        }
        PhpType.PhpTypeExclusion excludeCode = PhpExcludeTypeTP.getExclusion(expression, i);
        if (i + 2 < expression.length() && ApplicationManager.getApplication().isInternal() && !(excludeCode instanceof PhpTypesOutsideClassHierarchyExclusion)) {
            LOG.warn("Non-optimal exclusion signature: " + expression);
        }
        assert (excludeCode != null) : expression;
        return new PhpType().add(expression.substring(2, i)).global(project).filterOut(type -> excludeCode.isNotApplicableType(project, type)).pluralise(c);
    }

    @Nullable
    private static PhpType.PhpTypeExclusion getExclusion(String expression, int separatorIndex) {
        String code = expression.substring(separatorIndex + 1, separatorIndex + 2);
        if (code.equalsIgnoreCase("c")) {
            return new PhpTypesOutsideClassHierarchyExclusion(expression.substring(separatorIndex + 2));
        }
        return PhpType.fromCode((String)code);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        int i = expression.lastIndexOf("\u2206");
        assert (i > 0) : expression;
        String classRef = expression.substring(0, i);
        PhpIndex index = PhpIndex.getInstance((Project)project);
        return StringUtil.startsWithChar((CharSequence)classRef, (char)'#') ? index.getBySignature(classRef, visited, depth) : index.getAnyByFQN(classRef);
    }

    public boolean emptyResultIsComplete() {
        return true;
    }

    public static class PhpTypesOutsideClassHierarchyExclusion
    implements PhpType.PhpTypeExclusion {
        private static final String CODE = "c";
        private final String myInstanceofClassFqn;

        public PhpTypesOutsideClassHierarchyExclusion(String fqn) {
            this.myInstanceofClassFqn = fqn;
        }

        public boolean isNotApplicableType(@Nullable Project project, @NotNull String type) {
            if (type == null) {
                PhpTypesOutsideClassHierarchyExclusion.$$$reportNull$$$0(0);
            }
            if (project == null) {
                return PhpType.isNotExtendablePrimitiveType((String)type) || PhpType.isArray((String)type) || PhpType.isPluralType((String)type);
            }
            Collection classes = PhpIndex.getInstance((Project)project).getAnyByFQN(type);
            if (classes.isEmpty()) {
                return false;
            }
            return !this.superExists(project, classes) && !this.superExists(project, PhpIndex.getInstance((Project)project).getAllSubclasses(type));
        }

        private boolean superExists(@NotNull Project project, Collection<PhpClass> subclasses) {
            if (project == null) {
                PhpTypesOutsideClassHierarchyExclusion.$$$reportNull$$$0(1);
            }
            PhpIndex index = PhpIndex.getInstance((Project)project);
            return ContainerUtil.exists(subclasses, c -> PhpType.findSuper((String)this.myInstanceofClassFqn, (String)c.getFQN(), (PhpIndex)index));
        }

        public String getCode() {
            return CODE + this.myInstanceofClassFqn;
        }

        public boolean filterOnlyUnresolved() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpExcludeTypeTP$PhpTypesOutsideClassHierarchyExclusion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNotApplicableType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "superExists";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

