/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpCustomDocTagTypeProvider
implements PhpTypeProvider4 {
    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof Parameter) {
            PhpDocComment comment = ((Parameter)element).getDocComment();
            String paramName = ((Parameter)element).getName();
            if (comment != null) {
                Collection tags2 = (Collection)((StreamEx)StreamEx.of((Object[])comment.getTagElementsByName(this.getParamTag())).select(PhpDocParamTag.class).filter(tag -> paramName.equals(tag.getVarName()))).collect(Collectors.toList());
                return PhpCustomDocTagTypeProvider.getTypeFromTags(tags2);
            }
        }
        if (element instanceof Function) {
            return PhpCustomDocTagTypeProvider.getTypeFromCustomTag((PhpNamedElement)((Function)element), this.getReturnTag());
        }
        if (element instanceof Field || element instanceof Variable) {
            return PhpCustomDocTagTypeProvider.getTypeFromCustomTag((PhpNamedElement)element, this.getVarTag());
        }
        return null;
    }

    @NotNull
    protected abstract String getParamTag();

    @NotNull
    protected abstract String getReturnTag();

    @NotNull
    protected abstract String getVarTag();

    @Nullable
    public static PhpType getTypeFromCustomTag(PhpNamedElement element, String tagName) {
        PhpDocComment docComment = element.getDocComment();
        PhpDocTag[] tags2 = docComment != null ? docComment.getTagElementsByName(tagName) : PhpDocTag.EMPTY_ARRAY;
        return PhpCustomDocTagTypeProvider.getTypeFromTags(Arrays.asList(tags2));
    }

    @Nullable
    private static PhpType getTypeFromTags(Collection<PhpDocTag> tags2) {
        if (!tags2.isEmpty()) {
            PhpType result = new PhpType();
            for (PhpDocTag tag : tags2) {
                result.add((PsiElement)tag);
            }
            return result;
        }
        return null;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }
}

