/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeAnalyzer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpIteratedAccessTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpKeyTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayAccessTP
implements PhpTypeProvider4 {
    public static final char SEPARATOR = '.';

    public char getKey() {
        return 'E';
    }

    @Nullable
    public PhpType getType(PsiElement e) {
        PsiElement parent;
        if (e instanceof ArrayAccessExpression) {
            // empty if block
        }
        if (e instanceof Variable && (parent = e.getParent()) instanceof ForeachStatement) {
            ForeachStatement foreach = (ForeachStatement)parent;
            PsiElement arr = foreach.getArray();
            if (((ForeachStatement)parent).getKey() != e && arr instanceof PhpTypedElement) {
                int numberOfNestedList = PhpArrayAccessTP.countNestedList(e);
                if (numberOfNestedList > 0) {
                    PhpType type = ((PhpTypedElement)arr).getType().elementType(PhpIteratedAccessTP.TYPE_KEY);
                    for (int i = 0; i < numberOfNestedList; ++i) {
                        type = type.elementType(PhpIteratedAccessTP.TYPE_KEY);
                    }
                    return type;
                }
                if (e == foreach.getValue()) {
                    PhpArrayAccessTypeAnalyzer processor;
                    PhpType type = ((PhpTypedElement)arr).getType().elementType(PhpIteratedAccessTP.TYPE_KEY);
                    PhpAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)arr, PhpAccessInstruction.class);
                    if (instruction != null && (processor = PhpTypeAnalyserVisitor.createProcessor(arr, null)) != null) {
                        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor);
                        return new PhpType().add(type).add(processor.getType());
                    }
                    return type;
                }
            }
        }
        return null;
    }

    private static int countNestedList(PsiElement variable) {
        PsiElement element = PhpPsiUtil.findPrevSiblingOfAnyType(variable, PhpTokenTypes.kwAS);
        ArrayDeque<IntRef> currentListParensDepth = new ArrayDeque<IntRef>();
        while (element != null && element != variable) {
            IntRef p;
            if (PhpPsiUtil.isOfType(element = element.getNextSibling(), PhpTokenTypes.chLBRACKET)) {
                currentListParensDepth.push(new IntRef(1));
                continue;
            }
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.kwLIST)) {
                currentListParensDepth.push(new IntRef(0));
                continue;
            }
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.chLPAREN)) {
                p = (IntRef)currentListParensDepth.peek();
                if (p == null) continue;
                p.inc();
                continue;
            }
            if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN, PhpTokenTypes.chRBRACKET) || (p = (IntRef)currentListParensDepth.peek()) == null) continue;
            int v = p.get() - 1;
            p.set(v);
            if (v != 0) continue;
            currentListParensDepth.pop();
        }
        return currentListParensDepth.size();
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return PhpArrayAccessTP.doComplete(expression, project, (PhpTypeKey)PhpTypeSignatureKey.ARRAY_ELEMENT);
    }

    public static PhpType doComplete(String expression, Project project, PhpTypeKey typeKey) {
        boolean signatureShouldNotBeOmitted;
        int numberOfElementSigns = PhpArrayAccessTP.getNumberOfElementSigns(expression, typeKey);
        String refSignature = expression.substring(numberOfElementSigns * 2);
        PhpType completedSignature = new PhpType().add(refSignature).filterOut(PhpKeyTypeProvider::isArrayKeySignature).global(project);
        PhpType result = new PhpType();
        boolean atLeastOnPluralType = false;
        boolean bl = signatureShouldNotBeOmitted = !PhpIndexImpl.incompleteSignatureCanBeOmitted(refSignature) && Arrays.stream(PhpTypeSignatureKey.values()).anyMatch(s -> s.isSigned(refSignature));
        if (completedSignature.filterUnknown().isEmpty() && signatureShouldNotBeOmitted) {
            return PhpType.MIXED;
        }
        for (String type : completedSignature.getTypes()) {
            if (PhpType.isPluralType((String)type) || PhpType.isArray((String)type)) {
                atLeastOnPluralType = true;
                PhpType partType = new PhpType().add(type);
                for (int i = 0; i < numberOfElementSigns; ++i) {
                    partType = partType.elementType(typeKey);
                }
                result.add(partType);
                continue;
            }
            if (PhpType.isMixedType((String)type) || signatureShouldNotBeOmitted && StringUtil.startsWithChar((CharSequence)type, (char)'?')) {
                atLeastOnPluralType = true;
            }
            result.add(PhpType.MIXED);
        }
        if (!atLeastOnPluralType) {
            return null;
        }
        return result;
    }

    public static int getNumberOfElementSigns(String expression, PhpTypeKey typeKey) {
        int numberOfSignatures = 0;
        int indexOfElementSignature = 0;
        while (typeKey.is(expression.charAt(indexOfElementSignature + 1))) {
            indexOfElementSignature += 2;
            ++numberOfSignatures;
        }
        return numberOfSignatures;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return PhpArrayAccessTP.getBySignature(expression, visited, depth, project, (PhpTypeKey)PhpTypeSignatureKey.ARRAY_ELEMENT, PhpIndexImpl.ARRAY_VALUE_PROVIDERS);
    }

    @NotNull
    public static List<PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project, PhpTypeKey key, Map<String, String> providers) {
        SmartList elements = new SmartList();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        Collection bySignature = index.getBySignature(expression, visited, ++depth);
        for (PsiElement psiElement : bySignature) {
            if (!(psiElement instanceof PhpTypedElement)) continue;
            PhpType type = ((PhpTypedElement)psiElement).getType();
            type = type.elementType(key);
            Set strings = type.getTypes();
            for (String name : strings) {
                Collection interfaces;
                if (PhpType.isUnresolved((String)name)) {
                    if (key.is(name.charAt(1))) {
                        elements.addAll(index.getTypeMethods(name.substring(2), visited, providers, depth));
                        continue;
                    }
                    elements.addAll(index.getBySignature(name));
                    continue;
                }
                Collection classes = index.getClassesByFQN(name);
                if (classes.size() > 0) {
                    elements.addAll(classes);
                }
                if ((interfaces = index.getInterfacesByFQN(name)).size() <= 0) continue;
                elements.addAll(interfaces);
            }
        }
        SmartList smartList = elements;
        if (smartList == null) {
            PhpArrayAccessTP.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpArrayAccessTP", "getBySignature"));
    }
}

