/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TernaryExpressionImpl
extends PhpExpressionImpl
implements TernaryExpression {
    public TernaryExpressionImpl(ASTNode node) {
        super(node);
    }

    @Nullable
    public PhpPsiElement getCondition() {
        return this.getFirstPsiChild();
    }

    public boolean isShort() {
        ASTNode quest = this.getNode().findChildByType(PhpTokenTypes.opQUEST);
        return quest != null && PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(quest.getPsi(), true), PhpTokenTypes.opCOLON);
    }

    @Nullable
    public PhpPsiElement getTrueVariant() {
        if (!this.isShort()) {
            return this.getFirstExpression();
        }
        return this.getCondition();
    }

    @Nullable
    public PhpPsiElement getFalseVariant() {
        if (!this.isShort()) {
            return this.getSecondExpression();
        }
        return this.getFirstExpression();
    }

    @Nullable
    private PhpPsiElement getFirstExpression() {
        PhpPsiElement child = this.getCondition();
        return child != null ? child.getNextPsiSibling() : null;
    }

    @Nullable
    private PhpPsiElement getSecondExpression() {
        PhpPsiElement child = this.getFirstExpression();
        return child != null ? child.getNextPsiSibling() : null;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            TernaryExpressionImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpTernaryExpression((TernaryExpression)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpElementVisitor", "com/jetbrains/php/lang/psi/elements/impl/TernaryExpressionImpl", "accept"));
    }
}

