/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpRegExprPropertiesProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringLiteralExpressionImpl
extends PhpExpressionImpl
implements StringLiteralExpression,
RegExpLanguageHost {
    private String contents;
    private static final Map<Character, Character> whitespaceTokens;

    public StringLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpStringLiteralExpression((StringLiteralExpression)this);
    }

    public boolean isValidHost() {
        int length = this.getTextLength();
        if (this.isHeredoc()) {
            return length > 7;
        }
        ASTNode node = this.getNode();
        if (node.getElementType() == PhpDocElementTypes.phpDocString) {
            CharSequence text = node.getChars();
            return length >= 2 && StringUtil.startsWithChar((CharSequence)text, (char)'\"') && StringUtil.endsWithChar((CharSequence)text, (char)'\"');
        }
        ASTNode[] children = node.getChildren(null);
        return children.length >= 2 && PhpTokenTypes.tsSTRING_EDGE.contains(children[0].getElementType()) && PhpTokenTypes.tsSTRING_EDGE.contains(children[children.length - 1].getElementType());
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        if (this.isHeredoc()) {
            if (!((String)text).startsWith("<<<")) {
                text = "echo <<<" + this.getName() + "\n" + (String)text + "\n" + this.getName() + ";\n";
            } else if (!((String)text).endsWith("\n")) {
                text = (String)text + "\n";
            }
        } else {
            text = StringUtil.unquoteString((String)text);
            char q = this.getNode().getChars().charAt(0);
            text = ((String)text).replaceAll(Character.toString(q), "\\\\" + q);
            text = q + (String)text + q;
        }
        StringLiteralExpression newExpr = PhpPsiElementFactory.createFirstFromText(this.getProject(), StringLiteralExpression.class, (String)text);
        assert (newExpr != null) : text;
        this.replace((PsiElement)newExpr);
        return newExpr;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new StringLiteralEscaper((PsiLanguageInjectionHost)this);
    }

    @NotNull
    public TextRange getValueRange() {
        if (!this.isHeredoc()) {
            return new TextRange(1, Math.max(1, this.getTextLength() - 1));
        }
        PsiElement firstChild = this.getFirstChild();
        assert (firstChild != null) : this.getText();
        int s = firstChild.getTextLength();
        PsiElement end = this.findChildByType(PhpTokenTypes.HEREDOC_END);
        int e = end != null ? this.getTextLength() - end.getTextLength() : this.getTextLength();
        return new TextRange(s, e);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.contents = null;
    }

    @NotNull
    public String getContents() {
        if (this.contents == null) {
            this.contents = this.getValueRange().substring(this.getText());
        }
        String string = this.contents;
        if (string == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isHeredoc() {
        return this.getNode().getElementType() == HEREDOC;
    }

    public boolean isSingleQuote() {
        PsiElement first = this.getFirstChild();
        IElementType firstType = first.getNode().getElementType();
        return firstType == PhpTokenTypes.chLSINGLE_QUOTE || firstType == PhpTokenTypes.HEREDOC_START && first.textToCharArray()[0] == '\'';
    }

    public String getName() {
        if (this.isHeredoc()) {
            String text;
            PsiElement firstChild = this.getFirstChild();
            assert (firstChild != null) : this.getText();
            if ((text = text.substring((text = firstChild.getText().trim()).charAt(3) == ' ' ? 4 : 3)).charAt(0) == '\'' || text.charAt(0) == '\"') {
                text = text.substring(1, text.length() - 1);
            }
            return text;
        }
        return null;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return true;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return true;
    }

    public boolean characterNeedsEscaping(char c) {
        String contents = this.getContents();
        return !contents.isEmpty() && c == contents.charAt(0);
    }

    public boolean supportsPerl5EmbeddedComments() {
        return true;
    }

    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    public boolean supportsPythonConditionalRefs() {
        return true;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return true;
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        for (String[] property : this.getAllKnownProperties()) {
            if (!property[0].equals(category)) continue;
            return true;
        }
        return StringLiteralExpressionImpl.isValidUnicodeScript(category);
    }

    public boolean supportsBoundary(RegExpBoundary boundary) {
        return true;
    }

    private static boolean isValidUnicodeScript(@NotNull String category) {
        if (category == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        try {
            return Character.UnicodeScript.forName(category) != null;
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    public String[] @NotNull [] getAllKnownProperties() {
        return PhpRegExprPropertiesProvider.getAllKnownProperties();
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return PhpRegExprPropertiesProvider.getPropertyDescription(name);
    }

    public String[] @NotNull [] getKnownCharacterClasses() {
        return DefaultRegExpPropertiesProvider.getInstance().getKnownCharacterClasses();
    }

    @Nullable
    public Number getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        try {
            int result = Integer.parseInt(number.getUnescapedText());
            return result > 65535 ? null : Integer.valueOf(result);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, int @Nullable [] sourceOffsets, boolean isHeredoc, boolean isSingleQuote) {
        if (chars == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        if (outChars == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            if ((index = StringLiteralExpressionImpl.processEscapedCharacter(c = chars.charAt(index++), chars, outChars, index, isHeredoc, isSingleQuote)) < 0) {
                return false;
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index;
        }
        return true;
    }

    private static int processEscapedCharacter(char c, @NotNull String chars, @NotNull StringBuilder outChars, int index, boolean isHeredoc, boolean isSingleQuote) {
        if (chars == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        if (outChars == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(9);
        }
        if (whitespaceTokens.containsKey(Character.valueOf(c))) {
            if (isSingleQuote) {
                StringLiteralExpressionImpl.appendEscapedChar(c, outChars);
            } else {
                outChars.append(whitespaceTokens.get(Character.valueOf(c)));
            }
            return index;
        }
        switch (c) {
            case '$': {
                if (isSingleQuote) break;
                outChars.append("$");
                break;
            }
            case '\"': {
                if (isHeredoc) {
                    outChars.append('\\');
                }
                outChars.append('\"');
                break;
            }
            case '\'': {
                if (!isSingleQuote || isHeredoc) {
                    outChars.append('\\');
                }
                outChars.append('\'');
                break;
            }
            case '\\': {
                outChars.append('\\');
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                char startC = c;
                int v = c - 48;
                if (index < chars.length()) {
                    if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                        v <<= 3;
                        v += c - 48;
                        if (startC <= '3' && index < chars.length()) {
                            if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                v <<= 3;
                                v += c - 48;
                            } else {
                                --index;
                            }
                        }
                    } else {
                        --index;
                    }
                }
                outChars.append((char)v);
                break;
            }
            case 'x': {
                try {
                    int code;
                    c = chars.charAt(index);
                    if (c == '+' || c == '-') {
                        return -1;
                    }
                    if (c == '{') {
                        int firstDigitIndex = index + 1;
                        int closingBraceIndex = chars.indexOf(125, firstDigitIndex);
                        if (closingBraceIndex <= firstDigitIndex) {
                            return -1;
                        }
                        code = Integer.parseInt(chars.substring(firstDigitIndex, closingBraceIndex), 16);
                        index = closingBraceIndex + 1;
                    } else {
                        int endIndex = index;
                        endIndex = StringLiteralExpressionImpl.advanceIfDigit(chars, endIndex);
                        if ((endIndex = StringLiteralExpressionImpl.advanceIfDigit(chars, endIndex)) == index) {
                            return index;
                        }
                        code = StringLiteralExpressionImpl.parseCode(chars, index, endIndex);
                        index = endIndex;
                    }
                    outChars.append((char)code);
                    break;
                }
                catch (Exception e) {
                    return -1;
                }
            }
            default: {
                StringLiteralExpressionImpl.appendEscapedChar(c, outChars);
            }
        }
        return index;
    }

    private static int parseCode(@NotNull String chars, int startIndex, int endIndex) {
        if (chars == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(10);
        }
        Object codeString = chars.substring(startIndex, endIndex);
        if (endIndex - startIndex == 1) {
            codeString = "0" + (String)codeString;
        }
        return Integer.parseInt((String)codeString, 16);
    }

    private static int advanceIfDigit(@NotNull String s, int idx) {
        if (s == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(11);
        }
        if (idx < s.length() && StringUtil.isHexDigit((char)s.charAt(idx))) {
            ++idx;
        }
        return idx;
    }

    private static void appendEscapedChar(char c, @NotNull StringBuilder outChars) {
        if (outChars == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(12);
        }
        outChars.append('\\');
        outChars.append(c);
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(13);
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType phpType = PhpType.STRING;
        if (phpType == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    static {
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        map.put(Character.valueOf('b'), Character.valueOf('\b'));
        map.put(Character.valueOf('t'), Character.valueOf('\t'));
        map.put(Character.valueOf('n'), Character.valueOf('\n'));
        map.put(Character.valueOf('f'), Character.valueOf('\f'));
        map.put(Character.valueOf('r'), Character.valueOf('\r'));
        whitespaceTokens = Collections.unmodifiableMap(map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/StringLiteralExpressionImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/StringLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidUnicodeScript";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseStringCharacters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processEscapedCharacter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseCode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "advanceIfDigit";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedChar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StringLiteralEscaper
    extends LiteralTextEscaper<StringLiteralExpression> {
        private int[] outSourceOffsets;

        protected StringLiteralEscaper(@NotNull PsiLanguageInjectionHost host) {
            if (host == null) {
                StringLiteralEscaper.$$$reportNull$$$0(0);
            }
            super((PsiLanguageInjectionHost)((StringLiteralExpression)host));
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            if (rangeInsideHost == null) {
                StringLiteralEscaper.$$$reportNull$$$0(1);
            }
            if (outChars == null) {
                StringLiteralEscaper.$$$reportNull$$$0(2);
            }
            String text = rangeInsideHost.substring(((StringLiteralExpression)this.myHost).getText());
            outChars.ensureCapacity(text.length());
            this.outSourceOffsets = new int[text.length() + 1];
            try {
                boolean b = StringLiteralExpressionImpl.parseStringCharacters(text, outChars, this.outSourceOffsets, ((StringLiteralExpression)this.myHost).isHeredoc(), ((StringLiteralExpression)this.myHost).isSingleQuote());
                return b;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error decoding " + text + " out = " + outChars, e);
            }
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            int result;
            if (rangeInsideHost == null) {
                StringLiteralEscaper.$$$reportNull$$$0(3);
            }
            int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
            if (result == -1) {
                return -1;
            }
            return Math.min(result, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
        }

        public boolean isOneLine() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInsideHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outChars";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/StringLiteralExpressionImpl$StringLiteralEscaper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOffsetInHost";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

