/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.google.common.collect.Iterables;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclarationOwner;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpASTElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTypeDeclarationImpl
extends PhpASTElementImpl
implements PhpTypeDeclaration {
    public PhpTypeDeclarationImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public Collection<ClassReference> getClassReferences() {
        List<ClassReference> list = PhpPsiUtil.getChildren((PsiElement)this, (Condition<? super PsiElement>)((Condition)ClassReference.class::isInstance));
        if (list == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    public boolean isNullable() {
        return PhpPsiUtil.isOfType(this.getFirstChild(), PhpTokenTypes.opQUEST);
    }

    @NotNull
    public PhpType getType() {
        Collection<ClassReference> types = this.getClassReferences();
        if (types.isEmpty()) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpTypeDeclarationImpl.$$$reportNull$$$0(1);
            }
            return phpType;
        }
        PhpType result = new PhpType();
        for (ClassReference child : types) {
            result.add(child.resolveLocalType());
        }
        if (this.isNullable()) {
            result.add(PhpType.NULL);
        }
        PhpType phpType = result.createImmutableType();
        if (phpType == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(3);
        }
        phpElementVisitor.visitPhpTypeDeclaration((PhpTypeDeclaration)this);
    }

    public ClassReference findNullReference() {
        return (ClassReference)ContainerUtil.find(this.getClassReferences(), c -> c.textMatches((CharSequence)"null"));
    }

    public void addTypeReference(@NotNull String typeReferenceText) {
        if (typeReferenceText == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(4);
        }
        PsiElement child = this.getLastChild();
        String textToAdd = PhpTypeDeclarationImpl.createTextToAdd((PsiElement)this, typeReferenceText);
        if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opQUEST) || PhpPsiUtil.isOfType(child, PhpTokenTypes.opBIT_OR)) {
            this.addAfter((PsiElement)PhpPsiElementFactory.createClassReference(this.getProject(), textToAdd), child);
        } else {
            PsiElement pipe = this.addAfter(PhpPsiElementFactory.createFromText(this.getProject(), PhpTokenTypes.opBIT_OR, "function f():string|int {}"), child);
            this.addAfter((PsiElement)PhpPsiElementFactory.createClassReference(this.getProject(), textToAdd), pipe);
        }
    }

    @Nullable
    public abstract PhpDocTag getDocTag();

    @NotNull
    private static String createTextToAdd(PsiElement point, @NotNull String typeReferenceText) {
        if (typeReferenceText == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(5);
        }
        PsiElement anchor = (PsiElement)ObjectUtils.notNull(PhpPsiUtil.getParentByCondition(point, (Condition<? super PsiElement>)((Condition)Function.class::isInstance)), (Object)point);
        PhpScopeHolder scope = PhpPsiUtil.getScopeHolder(anchor);
        if (scope == null) {
            String string = typeReferenceText;
            if (string == null) {
                PhpTypeDeclarationImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = PhpCodeInsightUtil.createQualifiedName((PhpPsiElement)scope, PhpLangUtil.toFQN(typeReferenceText));
        if (string == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void updateElementsFromNewType(PhpType newType, PhpType oldType, List<? extends PhpTypedElement> elementsToUpdate, BiFunction<PhpType, Boolean, PsiElement> elementCreator, IElementType separatorType) {
        List elementsToRemove = ContainerUtil.filter(elementsToUpdate, e -> !PhpTypeDeclarationImpl.intersects(e.getType().global(e.getProject()), newType));
        List typesToAdd = newType.getTypes().stream().map(t -> new PhpType().add(t)).filter(t -> !PhpTypeDeclarationImpl.intersects(oldType, t)).collect(Collectors.toList());
        boolean isUnionType = typesToAdd.size() + (elementsToUpdate.size() - elementsToRemove.size()) > 1;
        PsiElement lastItem = (PsiElement)ContainerUtil.getLastItem(elementsToUpdate);
        if (lastItem == null) {
            return;
        }
        HashSet<String> addedElementTexts = new HashSet<String>();
        for (PhpType typeToAdd : typesToAdd) {
            PsiElement createdElement = elementCreator.apply(typeToAdd, isUnionType);
            if (!addedElementTexts.add(createdElement.getText())) continue;
            PsiElement docPipe = PhpPsiUtil.isOfType(lastItem.getNextSibling(), separatorType) ? lastItem.getNextSibling() : lastItem.getParent().addAfter(PhpTypeDeclarationImpl.createPipe(lastItem.getProject(), separatorType), lastItem);
            lastItem = docPipe.getParent().addAfter(createdElement, docPipe);
        }
        for (PhpTypedElement elementToRemove : elementsToRemove) {
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)elementToRemove, separatorType);
        }
    }

    public static String createTypeToAdd(PsiElement point, boolean isUnionType, PhpType typeToAdd) {
        if (typeToAdd.equals((Object)PhpType.TRUE) || !isUnionType && typeToAdd.equals((Object)PhpType.FALSE)) {
            return PhpTypeDeclarationImpl.getTypePresentation(point, PhpType.BOOLEAN);
        }
        if (typeToAdd.equals((Object)PhpType.NULL)) {
            return "null";
        }
        return PhpTypeDeclarationImpl.getTypePresentation(point, typeToAdd);
    }

    @NotNull
    private static String getTypePresentation(PsiElement point, PhpType typeToAdd) {
        String string = StringUtil.notNullize((String)PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(point.getProject(), typeToAdd, point));
        if (string == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void update() {
        PhpTypeDeclarationImpl.update(this.getDocTag(), this.getType().global(this.getProject()));
    }

    @ApiStatus.Experimental
    public void update(@NotNull PhpType type) {
        Collection<ClassReference> references;
        if (type == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(9);
        }
        type = type.global(this.getProject());
        assert (!type.equals((Object)PhpType.NULL));
        PhpDocTag docTag = this.getDocTag();
        PhpType oldType = this.getType().global(this.getProject());
        boolean oldDeclarationUsesFullNullabilityForm = this.getClassReferences().size() == 2 && this.findNullReference() != null;
        PhpTypeDeclarationImpl.updateElementsFromNewType(type, oldType, new ArrayList<ClassReference>(this.getClassReferences()), (t, isUnionType) -> PhpPsiElementFactory.createClassReference(this.getProject(), PhpTypeDeclarationImpl.createTypeToAdd((PsiElement)this, isUnionType, t)), PhpTokenTypes.opBIT_OR);
        PhpTypeDeclarationImpl.update(docTag, type);
        if (oldType.isNullable() && !type.isNullable() && this.isNullable()) {
            this.getFirstChild().delete();
        } else if (!oldDeclarationUsesFullNullabilityForm && type.isNullable() && !this.isNullable() && this.findNullReference() != null && (references = this.getClassReferences()).size() == 2) {
            ClassReference item = (ClassReference)ContainerUtil.getFirstItem(references);
            assert (item != null);
            item.getParent().addBefore(PhpPsiElementFactory.createQuest(this.getProject()), (PsiElement)item);
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)this.findNullReference(), PhpTokenTypes.opBIT_OR);
        }
        if (this.isNullable() && type.size() > 2) {
            this.getFirstChild().delete();
            PsiElement lastChild = this.getLastChild();
            PsiElement pipe = lastChild.getParent().addAfter(PhpTypeDeclarationImpl.createPipe(this.getProject(), PhpTokenTypes.opBIT_OR), lastChild);
            lastChild.getParent().addAfter((PsiElement)PhpPsiElementFactory.createClassReference(this.getProject(), PhpType.NULL.toString()), pipe);
        }
    }

    public static void update(@Nullable PhpDocTag docTag, @NotNull PhpType newType) {
        if (newType == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(10);
        }
        if (docTag == null) {
            return;
        }
        List docTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag, PhpDocType.class);
        PhpType resolvedNewType = newType.global(docTag.getProject());
        if (docTypes.isEmpty()) {
            if (resolvedNewType.isEmpty()) {
                return;
            }
            PhpTypeDeclarationImpl.createNewDocType(docTag, resolvedNewType);
        } else {
            PhpType docType = docTag.getType().global(docTag.getProject());
            boolean isVariadic = docTag instanceof PhpDocParamTag && ((PhpDocParamTag)docTag).isVariadic();
            PhpTypeDeclarationImpl.updateElementsFromNewType(resolvedNewType, isVariadic ? docType.unpluralize() : docType, docTypes, (t, isUnionType) -> PhpTypeDeclarationImpl.createDocType((PsiElement)docTag, t), PhpDocTokenTypes.DOC_PIPE);
        }
        PhpTypeDeclarationImpl.reorderDocType(docTag);
    }

    private static void createNewDocType(@NotNull PhpDocTag docTag, PhpType resolvedNewType) {
        PsiElement docTagName;
        if (docTag == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(11);
        }
        if ((docTagName = PhpPsiUtil.getChildOfType((PsiElement)docTag, PhpDocTokenTypes.DOC_TAG_NAME)) == null) {
            return;
        }
        Collection<PhpDocType> newDocTypes = PhpTypeDeclarationImpl.createDocTypes((PsiElement)docTag, resolvedNewType);
        PhpDocType first = (PhpDocType)Iterables.getFirst(newDocTypes, null);
        if (first == null) {
            return;
        }
        docTag.addRangeAfter(first.getPrevSibling(), (PsiElement)Iterables.getLast(newDocTypes), docTagName);
    }

    @NotNull
    private static PhpDocType createDocType(PsiElement point, PhpType t) {
        PhpDocType phpDocType = PhpPsiElementFactory.createPhpDocType(point.getProject(), PhpDocUtil.getTypePresentation(point.getProject(), t, (PhpPsiElement)PhpPsiUtil.getScopeHolder(point)));
        if (phpDocType == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(12);
        }
        return phpDocType;
    }

    @NotNull
    private static Collection<PhpDocType> createDocTypes(PsiElement point, PhpType t) {
        Collection<PhpDocType> collection = PhpPsiElementFactory.createPhpDocTypes(point.getProject(), PhpDocUtil.getTypePresentation(point.getProject(), t, (PhpPsiElement)PhpPsiUtil.getScopeHolder(point)));
        if (collection == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    private static PsiElement createPipe(Project project, IElementType separator) {
        return PhpPsiElementFactory.createFromText(project, separator, "class a {/** @var int|float */ private int|float $a; }");
    }

    private static boolean intersects(PhpType type, PhpType docType) {
        return PhpType.isArray((PhpType)type) && PhpType.isArray((PhpType)docType) || type.isBoolean() && docType.isBoolean() || ContainerUtil.intersects((Collection)type.getTypes(), (Collection)docType.getTypes());
    }

    private static Comparator<PhpDocType> phpDocTypeComparator(@Nullable PhpTypeDeclaration sortBy, @Nullable PhpCodeStyleSettings codeStyleSettings) {
        Comparator<String> docTypesComparator = PhpDocUtil.docTypesComparator(sortBy, codeStyleSettings);
        return (o1, o2) -> docTypesComparator.compare(PhpTypeDeclarationImpl.extractSingleType(o1), PhpTypeDeclarationImpl.extractSingleType(o2));
    }

    @NotNull
    private static String extractSingleType(@NotNull PhpDocType type) {
        if (type == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(14);
        }
        String string = (String)type.getGlobalType().getTypes().iterator().next();
        if (string == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    public static PhpTypeDeclarationOwner<?> getTagOwner(@NotNull PhpDocTag tag) {
        Function function;
        PhpDocComment docComment;
        if (tag == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(16);
        }
        if ((docComment = (PhpDocComment)PhpPsiUtil.getParentByCondition((PsiElement)tag, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF)) == null) {
            return null;
        }
        PsiElement commentOwner = docComment.getOwner();
        PhpDocParamTag paramTag = (PhpDocParamTag)ObjectUtils.tryCast((Object)tag, PhpDocParamTag.class);
        if (paramTag != null && (function = (Function)ObjectUtils.tryCast((Object)commentOwner, Function.class)) != null) {
            return (PhpTypeDeclarationOwner)ContainerUtil.find((Object[])function.getParameters(), p -> p.getDocTag() == paramTag);
        }
        return (PhpTypeDeclarationOwner)ObjectUtils.tryCast((Object)commentOwner, PhpTypeDeclarationOwner.class);
    }

    private static void reorderDocType(PhpDocTag docTag) {
        PhpTypeDeclaration ownerTypeDeclaration = Optional.ofNullable(PhpTypeDeclarationImpl.getTagOwner(docTag)).map(o -> o.getTypeDeclaration()).orElse(null);
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)docTag.getContainingFile(), PhpCodeStyleSettings.class);
        Comparator<PhpDocType> comparator = PhpTypeDeclarationImpl.phpDocTypeComparator(ownerTypeDeclaration, settings);
        List updatedDocTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag.copy(), PhpDocType.class);
        List newOrder = ContainerUtil.sorted((Collection)updatedDocTypes, comparator);
        EntryStream.of((List)newOrder).mapToKey((newIndex, type) -> (PhpDocType)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag, PhpDocType.class).get((int)newIndex)).forKeyValue((oldType, newType) -> oldType.replace((PsiElement)newType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpTypeDeclarationImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReferenceText";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassReferences";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpTypeDeclarationImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextToAdd";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSingleType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTypeReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTextToAdd";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNewDocType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractSingleType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTagOwner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

