/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpFileImpl;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayIndexImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpFileReferenceSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFilePathUtils {
    private static final Pattern VAR = Pattern.compile("\\$\\{?(\\w+)\\}?");
    private static final int MAX_DEPTH = Integer.getInteger("com.jetbrains.php.include.evaluate.depth.max", 15);
    public static final String DIRNAME = "dirname";
    private static final OffsetComparator ourOffsetComparator = new OffsetComparator();

    private PhpFilePathUtils() {
    }

    @Nullable
    public static String getFileName(PsiElement argument) {
        try {
            return PhpFilePathUtils.evaluate(argument);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Nullable
    static String evaluate(PsiElement element) throws UnsupportedOperationException {
        try {
            return PhpFilePathUtils.evaluate(element, new HashMap<PsiElement, String>(), 0);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating element '" + element.getText() + "' in " + element.getContainingFile(), e);
        }
    }

    @Nullable
    static String evaluate(PsiElement element, Map<PsiElement, String> visited, int depth) {
        Object assignmentExpression;
        ArrayIndex index;
        PhpPsiElement value;
        String name;
        Object v;
        PsiFile file;
        if (element == null) {
            return null;
        }
        if (visited.containsKey(element)) {
            return visited.get(element);
        }
        if (depth > MAX_DEPTH) {
            throw new UnsupportedOperationException("Expression is too complex, reached maximum allowed depth of " + MAX_DEPTH + " tree levels at " + element + " '" + element.getText() + "'");
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.PARENTHESIZED_EXPRESSION)) {
            PhpPsiElement child = ((PhpPsiElement)element).getFirstPsiChild();
            if (child == null) {
                return PhpFilePathUtils.cache(visited, element, null);
            }
            element = child;
        }
        if ((element instanceof Variable || element instanceof ConstantReference || element instanceof FunctionReference) && (file = element.getContainingFile()) instanceof PhpFileImpl && (v = ((PhpFileImpl)file).findDefinedVariableValue(element.getText())) != null) {
            return PhpFilePathUtils.cache(visited, element, (String)v);
        }
        if (element instanceof ClassConstantReference) {
            Collection constants = PhpIndex.getInstance((Project)element.getProject()).getBySignature(((ClassConstantReference)element).getSignature());
            for (ResolveResult[] constant : constants) {
                if (!(constant instanceof Field)) continue;
                return PhpFilePathUtils.cache(visited, element, StringUtil.unquoteString((String)StringUtil.defaultIfEmpty((String)((Field)constant).getDefaultValuePresentation(), (String)"")));
            }
        }
        if (element instanceof ConstantReference) {
            ResolveResult[] constant;
            name = ((ConstantReference)element).getName();
            if ("__DIR__".equals(name)) {
                PsiDirectory directory = element.getContainingFile().getOriginalFile().getContainingDirectory();
                return PhpFilePathUtils.cache(visited, element, directory != null ? directory.getVirtualFile().getPath() + "/" : null);
            }
            if ("__FILE__".equals(name)) {
                return PhpFilePathUtils.cache(visited, element, element.getContainingFile().getOriginalFile().getVirtualFile().getPath());
            }
            ResolveResult[] results = ((ConstantReference)element).multiResolve(false);
            if (EnvironmentUtil.getValue((String)"PHP_STABLE_ORDER") != null) {
                Arrays.sort(results, ourOffsetComparator);
            }
            constant = results;
            int n = constant.length;
            for (int i = 0; i < n; ++i) {
                ResolveResult result = constant[i];
                PsiElement target = result.getElement();
                if (!(target instanceof Constant)) continue;
                PsiElement value2 = ((Constant)target).getValue();
                return PhpFilePathUtils.cache(visited, element, PhpFilePathUtils.evaluate(value2, visited, depth + 1));
            }
        }
        if (element instanceof ArrayAccessExpression && (value = ((ArrayAccessExpression)element).getValue()) instanceof Variable && "_SERVER".contentEquals(((Variable)value).getNameCS()) && (index = ((ArrayAccessExpression)element).getIndex()) != null && (index = ((ArrayIndexImpl)index).getValue()) instanceof StringLiteralExpression && ((StringLiteralExpression)index).getContents().equals("DOCUMENT_ROOT")) {
            String path = PhpRuntimeConfiguration.getInstance(element.getProject()).getResolvedDocumentRootPath();
            return PhpFilePathUtils.cache(visited, element, StringUtil.isEmpty((String)path) ? element.getProject().getBaseDir().getPath() : path);
        }
        if (element instanceof Variable) {
            ArrayIndex results;
            for (ArrayIndex result : results = ((Variable)element).multiResolve(false)) {
                PhpPsiElement value3;
                String v2;
                PsiElement target = result.getElement();
                if (!(target instanceof Variable) || (assignmentExpression = (AssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)target, AssignmentExpression.class, (boolean)true)) == null || assignmentExpression.getVariable() != target || (v2 = PhpFilePathUtils.evaluate((PsiElement)(value3 = assignmentExpression.getValue()), visited, depth + 1)) == null) continue;
                return PhpFilePathUtils.cache(visited, element, v2);
            }
            return PhpFilePathUtils.cache(visited, element, null);
        }
        if (element instanceof FunctionReference) {
            name = ((FunctionReference)element).getName();
            if (name != null && (name.equalsIgnoreCase(DIRNAME) || name.equalsIgnoreCase("realpath") || name.equalsIgnoreCase("getcwd"))) {
                PsiElement p = ((FunctionReference)element).getParameter(0);
                if (p != null) {
                    String v3 = PhpFilePathUtils.evaluate(p, visited, depth + 1);
                    if (v3 != null) {
                        int slash = v3.lastIndexOf(47, v3.length() - 2);
                        return PhpFilePathUtils.cache(visited, element, name.equalsIgnoreCase(DIRNAME) && slash >= 0 ? v3.substring(0, slash) : v3);
                    }
                } else {
                    PsiDirectory directory = element.getContainingFile().getOriginalFile().getContainingDirectory();
                    return PhpFilePathUtils.cache(visited, element, directory != null ? directory.getVirtualFile().getPath() : null);
                }
            }
            return PhpFilePathUtils.cache(visited, element, null);
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.STRING)) {
            String text = element.getText();
            Matcher matcher = VAR.matcher(text);
            int s = 0;
            while (matcher.find(s)) {
                s = matcher.end();
                String name2 = matcher.group(1);
                String v4 = ((PhpFileImpl)element.getContainingFile().getOriginalFile()).findDefinedVariableValue("$" + name2);
                if (v4 == null) {
                    Variable variable;
                    Collection byName = PhpIndex.getInstance((Project)element.getProject()).getVariablesByName(name2);
                    assignmentExpression = byName.iterator();
                    while (assignmentExpression.hasNext() && (v4 = PhpFilePathUtils.evaluate((PsiElement)(variable = (Variable)assignmentExpression.next()), visited, depth + 1)) == null) {
                    }
                }
                if (v4 != null) {
                    text = text.replace(matcher.group(), v4);
                }
                if (s > 0 && s < text.length()) continue;
            }
            text = text.substring(1, text.length() - 1);
            text = StringUtil.trimStart((String)text, (String)"./");
            return PhpFilePathUtils.cache(visited, element, text);
        }
        if (element instanceof BinaryExpression) {
            PsiElement[] elements = element.getChildren();
            if (PhpPsiUtil.isOfType(element, PhpElementTypes.CONCATENATION_EXPRESSION) && elements.length > 0) {
                StringBuilder b = new StringBuilder();
                for (PsiElement e : elements) {
                    String v5 = PhpFilePathUtils.evaluate(e, visited, depth + 1);
                    b.append(v5 != null ? v5 : e.getText());
                }
                return PhpFilePathUtils.cache(visited, element, b.toString());
            }
        }
        return PhpFilePathUtils.cache(visited, element, null);
    }

    private static String cache(@NotNull Map<PsiElement, String> visited, PsiElement element, String result) {
        if (visited == null) {
            PhpFilePathUtils.$$$reportNull$$$0(0);
        }
        visited.put(element, result);
        return result;
    }

    @Nullable
    public static PsiFile getIncludedFile(PsiFile containingFile, PsiElement argument) {
        String relPath;
        VirtualFile included;
        VirtualFile virtualFile = containingFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            virtualFile = (VirtualFile)containingFile.getOriginalFile().getUserData(IndexingDataKeys.VIRTUAL_FILE);
            assert (virtualFile != null);
        }
        if ((included = virtualFile.findFileByRelativePath("../" + (relPath = PhpFilePathUtils.getFileName(argument)))) == null && relPath != null) {
            included = VirtualFileManager.getInstance().findFileByUrl(relPath);
        }
        PsiFile file = included != null ? containingFile.getManager().findFile(included) : null;
        return file instanceof PhpFile ? (PhpFile)file : null;
    }

    @NotNull
    public static String getStaticPath(PhpPsiElement argument) {
        PhpPsiElement child = PhpFilePathUtils.getStaticElement(argument);
        if (child == null) {
            return "";
        }
        String r = child.getText();
        r = r.length() > 1 ? r.substring(1, r.length() - 1) : "";
        String string = r = StringUtil.trimStart((String)r, (String)"./");
        if (string == null) {
            PhpFilePathUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static PhpPsiElement getStaticElement(PhpPsiElement argument) {
        PhpPsiElement child = argument;
        if (child == null) {
            return null;
        }
        if (PhpPsiUtil.isOfType((PsiElement)child, PhpElementTypes.PARENTHESIZED_EXPRESSION)) {
            child = child.getFirstPsiChild();
        }
        if (child instanceof StringLiteralExpression) {
            return child;
        }
        if (child instanceof BinaryExpression && PhpPsiUtil.isOfType((PsiElement)child, PhpElementTypes.CONCATENATION_EXPRESSION)) {
            PsiElement[] elements = child.getChildren();
            for (int i = elements.length - 1; i >= 0; --i) {
                PsiElement element = elements[i];
                if (!(element instanceof PhpPsiElement)) continue;
                if (!(element instanceof StringLiteralExpression)) break;
                return (StringLiteralExpression)element;
            }
        }
        return null;
    }

    public static int getFilePathRelativeOffset(int textOffset, PhpPsiElement argument) {
        PhpPsiElement element = PhpFilePathUtils.getStaticElement(argument);
        if (element != null) {
            return element.getTextOffset() - textOffset + (element.getText().startsWith("./", 1) ? 3 : 1);
        }
        return 0;
    }

    @Nullable
    public static String getDynamicPath(PhpPsiElement argument) {
        int index;
        PhpPsiElement child = argument;
        if (child instanceof ParenthesizedExpression) {
            child = ((ParenthesizedExpression)child).getArgument();
        }
        if (child instanceof StringLiteralExpression) {
            return null;
        }
        String full = PhpFilePathUtils.getFileName((PsiElement)argument);
        String s = PhpFilePathUtils.getStaticPath(argument);
        String dynamic = null;
        if (full != null && s.length() > 0 && (index = full.indexOf(s)) >= 0) {
            dynamic = full.substring(0, index);
        }
        return dynamic;
    }

    @NlsSafe
    public static String computeFilePath(String value, TextRange rangeInParent, ASTNode node, String elementText) {
        ASTNode leaf = node.findLeafElementAt(rangeInParent.getStartOffset());
        if (leaf == null) {
            throw new RuntimeException("null leaf node @offset " + rangeInParent.getStartOffset() + "in '" + elementText + "'");
        }
        PsiElement element = leaf.getPsi().getParent();
        assert (element != null);
        boolean isReadingString = PhpElementTypes.STRING.equals(element.getNode().getElementType());
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        while (offset < value.length()) {
            if (isReadingString) {
                int quoteOffset;
                if (value.charAt(offset) == '\"' || value.charAt(offset) == '\'') {
                    ++offset;
                }
                if ((quoteOffset = value.indexOf(34, offset)) < 0) {
                    quoteOffset = value.indexOf(39, offset);
                }
                if (quoteOffset < offset) {
                    quoteOffset = value.length();
                }
                sb.append(value, offset, quoteOffset);
                offset = quoteOffset + 2;
            } else {
                int pointOffset = value.indexOf(46, offset);
                if (pointOffset < 0) {
                    pointOffset = value.length();
                }
                String idValue = null;
                if (element instanceof Variable || element instanceof ConstantReference || element instanceof FunctionReference) {
                    try {
                        idValue = PhpFilePathUtils.evaluate(element);
                    }
                    catch (UnsupportedOperationException e) {
                        idValue = null;
                    }
                    if (idValue != null && idValue.startsWith("file://")) {
                        idValue = idValue.substring(7);
                    }
                }
                if (idValue != null) {
                    sb.append(idValue);
                }
                for (offset = pointOffset + 1; offset < value.length() && value.charAt(offset) == ' '; ++offset) {
                }
            }
            if (offset < value.length() && (value.charAt(offset) == '\"' || value.charAt(offset) == '\'')) {
                isReadingString = true;
                ++offset;
                continue;
            }
            isReadingString = false;
        }
        return sb.toString();
    }

    public static PsiReference @NotNull [] getReferences(final PsiElement element, final PhpPsiElement argument) {
        if (PhpFilePathUtils.getStaticPath(argument).length() > 0) {
            FileReference[] fileReferences = new PhpFileReferenceSet(element, argument, null).getAllReferences();
            if (fileReferences.length > 0) {
                if (fileReferences == null) {
                    PhpFilePathUtils.$$$reportNull$$$0(2);
                }
                return fileReferences;
            }
            PsiReference psiReference = new PsiReference(){

                @NotNull
                public PsiElement getElement() {
                    PsiElement psiElement = element.getFirstChild();
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiElement;
                }

                @NotNull
                public TextRange getRangeInElement() {
                    TextRange textRange = element.getFirstChild().getTextRange();
                    if (textRange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return textRange;
                }

                public PsiElement resolve() {
                    return PhpFilePathUtils.getIncludedFile(element.getContainingFile(), (PsiElement)argument);
                }

                @NotNull
                public String getCanonicalText() {
                    String string = this.getRangeInElement().substring(this.getElement().getText());
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                    if (newElementName == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return null;
                }

                public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return null;
                }

                public boolean isReferenceTo(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return element2 instanceof PhpFile && element2 == this.resolve();
                }

                public boolean isSoft() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$1";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElementName";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getRangeInElement";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getCanonicalText";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "handleElementRename";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "bindToElement";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray;
                            objectArray[2] = "isReferenceTo";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            PsiReference[] psiReferenceArray = new PsiReference[]{psiReference};
            if (psiReferenceArray == null) {
                PhpFilePathUtils.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PhpFilePathUtils.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OffsetComparator
    implements Comparator<ResolveResult> {
        private OffsetComparator() {
        }

        @Override
        public int compare(ResolveResult o1, ResolveResult o2) {
            return o1.getElement().getTextOffset() - o2.getElement().getTextOffset();
        }
    }
}

