/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExpressionImpl
extends PhpTypedElementImpl
implements PhpExpression,
PhpElementTypes {
    public PhpExpressionImpl(ASTNode node) {
        super(node);
    }

    protected PhpExpressionImpl(PhpTypedStub stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            PhpExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, nodeType);
    }

    @Nullable
    public PhpPsiElement getValue() {
        PhpPsiElement child = this.getFirstPsiChild();
        if (child == null) {
            return null;
        }
        IElementType type = child.getNode().getElementType();
        return type != PhpElementTypes.HASH_ARRAY_ELEMENT && type != PhpElementTypes.ARRAY_VALUE ? child : null;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpExpressionImpl.$$$reportNull$$$0(1);
        }
        phpElementVisitor.visitPhpExpression((PhpExpression)this);
    }

    @Override
    @NotNull
    public PhpType getType() {
        if (this.getNode().getElementType() == NUMBER) {
            PhpType phpType = this.getNumberType().equals("\\float") ? PhpType.FLOAT : PhpType.INT;
            if (phpType == null) {
                PhpExpressionImpl.$$$reportNull$$$0(2);
            }
            return phpType;
        }
        if (this.getNode().getElementType() == CLOSURE) {
            PhpType phpType = PhpType.CLOSURE;
            if (phpType == null) {
                PhpExpressionImpl.$$$reportNull$$$0(3);
            }
            return phpType;
        }
        PhpType phpType = super.getType();
        if (phpType == null) {
            PhpExpressionImpl.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    @Override
    public String toString() {
        return PhpExpressionImpl.toStringWithValue((PsiElement)this, this.getText());
    }

    @NotNull
    public String getNumberType() {
        IElementType type = this.findChildByType(PhpTokenTypes.tsNUMBERS).getNode().getElementType();
        return PhpTokenTypes.FLOAT_LITERAL.equals(type) ? "\\float" : "\\int";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpExpressionImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

