/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.google.common.base.Predicates;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassFieldsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PhpClassImpl
extends PhpNamedElementImpl<PhpClassStub>
implements PhpClass,
PhpDeprecationAttributeOwner {
    private static final boolean FIELDS_FROM_CONSTRUCTORS = true;
    private static final TokenSet FIELDS_TS = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS});
    private static final Function<PhpClass, Icon> CLASS_ICON_EVALUATOR = clazz -> {
        if (clazz.isTrait()) {
            return PhpIcons.TRAIT;
        }
        if (clazz.isInterface()) {
            return PhpIcons.INTERFACE;
        }
        Ref isTestClassRef = new Ref((Object)false);
        Ref isExceptionClassRef = new Ref((Object)false);
        if (clazz.isValid() && !DumbService.getInstance((Project)clazz.getProject()).isDumb()) {
            PhpClassHierarchyUtils.processSuperClasses((PhpClass)clazz, (boolean)true, (boolean)true, aClass -> {
                if (PhpUnitUtil.isRootTestClass(aClass)) {
                    isTestClassRef.set((Object)true);
                } else if (PhpLangUtil.equalsClassNames("Exception", aClass.getNameCS())) {
                    isExceptionClassRef.set((Object)true);
                }
                return (Boolean)isTestClassRef.get() == false && (Boolean)isExceptionClassRef.get() == false;
            });
        }
        if (((Boolean)isTestClassRef.get()).booleanValue()) {
            if (clazz.isFinal()) {
                return PhpIcons.FINAL_TEST_CLASS;
            }
            if (clazz.isAbstract()) {
                return PhpIcons.ABSTRACT_TEST_CLASS;
            }
            return PhpIcons.PHP_TEST_CLASS;
        }
        if (((Boolean)isExceptionClassRef.get()).booleanValue()) {
            if (clazz.isFinal()) {
                return PhpIcons.FINAL_EXCEPTION;
            }
            if (clazz.isAbstract()) {
                return PhpIcons.ABSTRACT_EXCEPTION;
            }
            return PhpIcons.EXCEPTION;
        }
        if (clazz.isAbstract()) {
            return PhpIcons.ABSTRACT_CLASS;
        }
        if (clazz.isFinal()) {
            return PhpIcons.FINAL_CLASS;
        }
        return PhpIcons.CLASS;
    };
    @VisibleForTesting
    public static final Function<PhpClass, Icon> CLASS_ATTRIBUTE_ICON_EVALUATOR = phpClass -> PhpIcons.withAttribute(phpClass, CLASS_ICON_EVALUATOR.apply((PhpClass)phpClass));
    public static final TokenSet FIELDS = TokenSet.create((IElementType[])new IElementType[]{PhpStubElementTypes.CLASS_FIELD, PhpStubElementTypes.CLASS_CONST});
    private static final Predicate<Method> NOT_DOC_METHOD = t -> !(t instanceof PhpDocMethod);
    private static final Comparator<PhpClass> COMPARATOR = (o1, o2) -> {
        if (o1 == o2 || PhpLangUtil.equalsClassNames(o1.getFQN(), o2.getFQN())) {
            return 0;
        }
        PhpIndex index = PhpIndex.getInstance((Project)o1.getProject());
        if (PhpType.findSuper((String)o2.getFQN(), (String)o1.getFQN(), (PhpIndex)index)) {
            return -1;
        }
        if (PhpType.findSuper((String)o1.getFQN(), (String)o2.getFQN(), (PhpIndex)index)) {
            return 1;
        }
        return 0;
    };

    public PhpClassImpl(ASTNode node) {
        super(node);
    }

    public PhpClassImpl(PhpClassStub stub) {
        super(stub, PhpStubElementTypes.CLASS);
    }

    public Collection<Field> getFields() {
        HashMap<Pair<String, Boolean>, Field> allFields = new HashMap<Pair<String, Boolean>, Field>();
        PhpClassImpl.getFieldsInternal(this, allFields);
        return allFields.values();
    }

    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        Collection<PhpAttribute> collection = PhpClassImpl.getAttributesStubAware(this);
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Nullable
    public PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfo() {
        return FunctionImpl.getDeprecationInfoFromAttribute((PhpAttributesOwner)this);
    }

    private static void getFieldsInternal(PhpClass phpClass, Map<Pair<String, Boolean>, Field> allFields) {
        PhpClassHierarchyUtils.processFields((PhpClass)phpClass, (PhpClass)phpClass, (field, subClass, baseClass) -> {
            @NonNls String name = field.getName();
            if (!StringUtil.isEmpty((String)name)) {
                PhpClass currentContainingClass;
                Pair key = Pair.create((Object)(name = StringUtil.toLowerCase((String)name)), (Object)field.isConstant());
                Field current = (Field)allFields.get(key);
                PhpClass phpClass = currentContainingClass = current == null ? null : current.getContainingClass();
                if (!(current != null && field instanceof MyRenamableFakePsiElement || currentContainingClass != null && !PhpLangUtil.isObject(currentContainingClass) && !currentContainingClass.isTrait())) {
                    allFields.put((Pair<String, Boolean>)key, (Field)field);
                }
            }
            return true;
        }, (boolean)false);
    }

    public Field[] getOwnFields() {
        Collection values = this.getOwnFieldMap().values();
        return values.toArray((Field[])Field.ARRAY_FACTORY.create(values.size()));
    }

    private MultiMap<CharSequence, Field> getOwnFieldMap() {
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> new CachedValueProvider.Result(this.getOwnFieldsInternal(), new Object[]{this}));
    }

    @NotNull
    private Stream<PhpDocProperty> docProperties() {
        PhpDocComment docComment = this.getDocComment();
        if (docComment == null) {
            Stream<PhpDocProperty> stream = Stream.empty();
            if (stream == null) {
                PhpClassImpl.$$$reportNull$$$0(1);
            }
            return stream;
        }
        StreamEx streamEx = StreamEx.of(((PhpDocCommentImpl)docComment).getDocTagByClass(PhpDocTag.class)).map(tag -> (PhpDocProperty)PsiTreeUtil.getStubChildOfType((PsiElement)tag, PhpDocProperty.class)).nonNull();
        if (streamEx == null) {
            PhpClassImpl.$$$reportNull$$$0(2);
        }
        return streamEx;
    }

    private MultiMap<CharSequence, Field> getOwnFieldsInternal() {
        MultiMap fields;
        block13: {
            Method constructor;
            fields = MultiMap.create();
            PhpClassStub stub = (PhpClassStub)this.getGreenStub();
            if (stub == null || stub.hasPropertyTags()) {
                this.docProperties().forEach(phpDocProperty -> {
                    String phpDocPropertyName = phpDocProperty.getName();
                    if (!phpDocPropertyName.isEmpty()) {
                        fields.putValue((Object)phpDocPropertyName, phpDocProperty);
                    }
                });
            }
            if (stub != null) {
                for (PhpClassFieldsList list : (PhpClassFieldsList[])stub.getChildrenByType(FIELDS_TS, PhpClassFieldsList.ARRAY_FACTORY)) {
                    for (Field field : list.getFields()) {
                        fields.putValue((Object)field.getName(), (Object)field);
                    }
                }
            } else {
                for (PsiElement element : this.findChildrenByType(FIELDS_TS)) {
                    for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (!(child instanceof Field)) continue;
                        fields.putValue((Object)((Field)child).getName(), (Object)((Field)child));
                    }
                }
            }
            if ((constructor = this.getOwnConstructor()) != null) {
                for (Parameter parameter : constructor.getParameters()) {
                    if (!(parameter instanceof PhpPromotedFieldParameterImpl)) continue;
                    fields.putValue((Object)parameter.getName(), (Object)((PhpPromotedFieldParameterImpl)parameter));
                }
            }
            if (stub != null && !stub.hasConstructorFields()) break block13;
            if (stub != null) {
                for (PhpClassStub.PhpConstructorFieldStubData data : stub.getConstructionFieldsStubData()) {
                    String name = data.getName();
                    if (fields.containsKey((Object)name)) continue;
                    fields.putValue((Object)name, (Object)new MyRenamableFakePsiElement(data.getRange(), this, data.isDynamic(), data.getType(), name));
                }
            } else {
                for (MyRenamableFakePsiElement field : this.getDynamicFields((MultiMap<CharSequence, Field>)fields)) {
                    if (fields.containsKey((Object)field.getName())) continue;
                    fields.putValue((Object)field.getName(), (Object)field);
                }
            }
        }
        return fields;
    }

    @NotNull
    public Collection<MyRenamableFakePsiElement> getDynamicFields(MultiMap<CharSequence, Field> fields) {
        ArrayList<MyRenamableFakePsiElement> fakeFields = new ArrayList<MyRenamableFakePsiElement>();
        MultiMap<String, FieldReference> map = PhpClassImpl.getConstructorAssignmentsPerField(this);
        for (String name : map.keySet()) {
            FieldReference expression;
            if (fields.containsKey((Object)name) || (expression = (FieldReference)ContainerUtil.getFirstItem((Collection)map.get((Object)name))) == null) continue;
            fakeFields.add(new MyASTRenamableFakePsiElement(this, expression));
        }
        ArrayList<MyRenamableFakePsiElement> arrayList = fakeFields;
        if (arrayList == null) {
            PhpClassImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public Collection<Method> getMethods() {
        HashMap allMethods = new HashMap();
        PhpClassHierarchyUtils.processMethods((PhpClass)this, (PhpClass)this, (method, subClass, baseClass) -> {
            @NonNls String methodName = method.getName();
            if (!StringUtil.isEmpty((String)methodName)) {
                PhpClass currentContainingClass;
                Method current = (Method)allMethods.get(methodName = StringUtil.toLowerCase((String)methodName));
                PhpClass phpClass = currentContainingClass = current == null ? null : current.getContainingClass();
                if (currentContainingClass == null || PhpLangUtil.isObject(currentContainingClass) || current.isAbstract() && currentContainingClass.isTrait() && !method.isAbstract()) {
                    allMethods.put(methodName, method);
                }
            }
            return true;
        }, (boolean)false);
        return allMethods.values();
    }

    public Method[] getOwnMethods() {
        return this.getOwnMethodsMap().values().toArray(Method.EMPTY);
    }

    @NotNull
    private MultiMap<CharSequence, Method> getOwnMethodsMap() {
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> new CachedValueProvider.Result(this.getOwnMethodsInternal(), new Object[]{this, PhpProjectConfigurationFacade.LANGUAGE_LEVEL_CHANGED_MODIFICATION_TRACKER}));
        if (multiMap == null) {
            PhpClassImpl.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    @NotNull
    private MultiMap<CharSequence, Method> getOwnMethodsInternal() {
        PhpDocMethod[] tags2;
        PhpDocComment comment;
        MultiMap result = new MultiMap(CollectionFactory.createCharSequenceMap((boolean)false));
        Method[] normalMethods = (Method[])this.getStubOrPsiChildren(PhpStubElementTypes.CLASS_METHOD, Method.ARRAY_FACTORY);
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        PhpLanguageLevel currentLevel = PhpLanguageLevel.current(this.getProject());
        for (Method method : normalMethods) {
            if (method instanceof MethodImpl && !PhpIndexImpl.suitsPhpStormStubsLanguageLevel((MethodImpl)method, currentLevel)) continue;
            result.putValue((Object)method.getName(), (Object)method);
        }
        if ((stub == null || stub.hasMethodTags()) && (comment = this.getDocComment()) != null && (tags2 = comment.getMethods()).length > 0) {
            for (PhpDocMethod method : tags2) {
                result.putValue((Object)method.getName(), (Object)method);
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            PhpClassImpl.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    public boolean hasMethodTags() {
        PhpDocComment comment = this.getDocComment();
        if (comment == null) {
            return false;
        }
        return comment.getMethods().length > 0;
    }

    public boolean hasPropertyTags() {
        return this.docProperties().findAny().isPresent();
    }

    public boolean hasConstructorFields() {
        for (Field ownField : this.getOwnFieldMap().values()) {
            if (!(ownField instanceof MyRenamableFakePsiElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getSuperName() {
        String superFQN = this.getSuperFQN();
        if (superFQN != null) {
            int i = superFQN.lastIndexOf(92);
            return i >= 0 ? superFQN.substring(i + 1) : superFQN;
        }
        return null;
    }

    public String getSuperFQN() {
        if (this.isInterface()) {
            return null;
        }
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.getSuperclass();
        }
        ClassReference superRef = this.getSuperRef();
        return superRef != null ? superRef.getFQN() : null;
    }

    @Nullable
    private ClassReference getSuperRef() {
        ExtendsList list = this.getExtendsList();
        return (ClassReference)ContainerUtil.getFirstItem((List)list.getReferenceElements());
    }

    @Nullable
    public PhpClass getSuperClass() {
        Collection<PhpClass> classes = this.getSuperClasses();
        return classes.size() == 1 ? classes.iterator().next() : (PhpClass)ContainerUtil.getFirstItem(PhpClassImpl.selectBestClasses(classes, this));
    }

    public Collection<PhpClass> getSuperClasses() {
        return PhpClassHierarchyUtils.getSuperClasses((PhpClass)this);
    }

    public boolean hasStaticMembers() {
        THashSet visited = new THashSet();
        Collection<PhpClassImpl> phpClass = Collections.singleton(this);
        do {
            if (ContainerUtil.exists(phpClass, PhpClass::hasOwnStaticMembers)) {
                return true;
            }
            visited.addAll(phpClass);
        } while (!(phpClass = (Collection)phpClass.stream().flatMap(c -> c.getSuperClasses().stream()).filter(arg_0 -> PhpClassImpl.lambda$hasStaticMembers$12((Set)visited, arg_0)).collect(Collectors.toSet())).isEmpty());
        return false;
    }

    @NotNull
    public static Collection<PhpClass> selectBestClasses(Collection<? extends PhpClass> classes, PhpPsiElement origin) {
        String my = PhpClassImpl.getPath((PsiElement)origin);
        if (my == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpClassImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        Map map = StreamEx.of(classes).toMap(aClass -> PhpClassImpl.getProximity(aClass, origin, my), aClass -> Collections.singleton(aClass), ContainerUtil::union);
        Optional<Integer> max = map.keySet().stream().max(Comparator.comparingInt(Integer::intValue));
        Collection collection = max.isPresent() ? (Collection)map.get(max.get()) : ContainerUtil.emptyList();
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static int getProximity(PhpClass aClass, PhpPsiElement origin, @NotNull String my) {
        if (my == null) {
            PhpClassImpl.$$$reportNull$$$0(8);
        }
        if (aClass.getContainingFile() == origin.getContainingFile()) {
            return Integer.MAX_VALUE;
        }
        String path = PhpClassImpl.getPath((PsiElement)aClass);
        assert (path != null);
        return StringUtil.commonPrefixLength((CharSequence)my, (CharSequence)path);
    }

    @Nullable
    static String getPath(PsiElement e) {
        PsiFile file = e.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile.getPath();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getNamespaceName() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getNamespaceName();
            if (string == null) {
                PhpClassImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = super.getNamespaceName();
        if (string == null) {
            PhpClassImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String @NotNull [] getInterfaceNames() {
        List referenceElements;
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getInterfaces();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(11);
            }
            return stringArray;
        }
        List list = referenceElements = !this.isInterface() ? this.getImplementsList().getReferenceElements() : this.getExtendsList().getReferenceElements();
        if (referenceElements.isEmpty()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                PhpClassImpl.$$$reportNull$$$0(12);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])StreamEx.of((Collection)referenceElements).map(PhpReference::getFQN).nonNull().toArray(String.class);
        if (stringArray == null) {
            PhpClassImpl.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    public PhpClass[] getImplementedInterfaces() {
        ArrayList interfaceList = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getInterfaceNames()) {
            interfaceList.addAll(phpIndex.getInterfacesByFQN(fqn));
        }
        return interfaceList.toArray(PhpClass.EMPTY_ARRAY);
    }

    public boolean hasTraitUses() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasTraitUses();
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)this, () -> new CachedValueProvider.Result((Object)this.useListTargetReferencesFQNs().isNotEmpty(), new Object[]{this}));
    }

    @NotNull
    private JBIterable<String> useListTargetReferencesFQNs() {
        JBIterable jBIterable = this.useListTargetReferences().map(PhpReference::getFQN).filter(Objects::nonNull);
        if (jBIterable == null) {
            PhpClassImpl.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    public String @NotNull [] getTraitNames() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getTraits();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(15);
            }
            return stringArray;
        }
        Set names = (Set)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            THashSet res = new THashSet();
            this.useListTargetReferencesFQNs().forEach(((Set)res)::add);
            return new CachedValueProvider.Result((Object)res, new Object[]{this});
        });
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)names);
        if (stringArray == null) {
            PhpClassImpl.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    public JBIterable<PhpReference> useListTargetReferences() {
        return this.traitUseLists().flatMap(child -> JBIterable.of((Object[])child.getDeclarations())).map(PhpUse::getTargetReference).filter(Objects::nonNull);
    }

    public PhpClass[] getTraits() {
        ArrayList traits = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getTraitNames()) {
            traits.addAll(phpIndex.getTraitsByFQN(fqn));
        }
        return traits.toArray(PhpClass.EMPTY_ARRAY);
    }

    public String @NotNull [] getMixinNames() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getMixins();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(17);
            }
            return stringArray;
        }
        String[] stringArray = (String[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            THashSet names = new THashSet();
            PhpDocComment comment = this.getDocComment();
            if (comment != null) {
                PhpDocTag[] mixinTags;
                for (PhpDocTag tag : mixinTags = comment.getTagElementsByName("@mixin")) {
                    PhpType type = tag.getType();
                    names.addAll(type.getTypes());
                }
            }
            return new CachedValueProvider.Result((Object)ArrayUtilRt.toStringArray((Collection)names), new Object[]{this});
        });
        if (stringArray == null) {
            PhpClassImpl.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    public PhpClass[] getMixins() {
        ArrayList mixins = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getMixinNames()) {
            mixins.addAll(phpIndex.getAnyByFQN(fqn));
        }
        return mixins.toArray(PhpClass.EMPTY_ARRAY);
    }

    @Nullable
    public Method getConstructor() {
        return PhpClassImpl.getConstructors(this, (Set<PhpClass>)new THashSet()).getAny();
    }

    @Nullable
    public Method getOwnConstructor() {
        return PhpClassImpl.getOwnConstructors(this).getAny();
    }

    @Nullable
    private Method findOwnMethodByName(@Nullable CharSequence name, @NotNull Predicate<? super Method> predicate) {
        if (predicate == null) {
            PhpClassImpl.$$$reportNull$$$0(19);
        }
        return (Method)ContainerUtil.find((Iterable)this.findOwnMethodsByName(name).getMethods(), predicate::test);
    }

    public PhpClass.PhpOverloadedMethods findOwnMethodsByName(@Nullable CharSequence name) {
        return name != null ? PhpClass.PhpOverloadedMethods.from((Collection)this.getOwnMethodsMap().get((Object)name)) : PhpClass.PhpOverloadedMethods.EMPTY;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(20);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            ASTNode newNameNode = constantReference.getNameNode();
            assert (newNameNode != null);
            nameNode.getTreeParent().replaceChild(nameNode, newNameNode);
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpClassImpl.$$$reportNull$$$0(21);
        }
        phpElementVisitor.visitPhpClass((PhpClass)this);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = IconManager.getInstance().createDeferredIcon(PhpIcons.CLASS, (Object)this, CLASS_ATTRIBUTE_ICON_EVALUATOR);
        if (icon == null) {
            PhpClassImpl.$$$reportNull$$$0(22);
        }
        return icon;
    }

    public boolean isAbstract() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAbstract();
        }
        return this.isInterface() || PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)this).getElementType() == PhpTokenTypes.kwABSTRACT;
    }

    public boolean isFinal() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isFinal();
        }
        return PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)this).getElementType() == PhpTokenTypes.kwFINAL;
    }

    public boolean isAnonymous() {
        return this.getStub() == null && this.getParent() instanceof NewExpression && this.getNameNode() == null && this.findChildByClass(PsiErrorElement.class) == null;
    }

    public boolean isInterface() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isInterface();
        }
        return PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)this).getElementType() == PhpTokenTypes.kwINTERFACE;
    }

    public boolean isTrait() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isTrait();
        }
        return PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)this).getElementType() == PhpTokenTypes.kwTRAIT;
    }

    public JBIterable<PhpTraitUseRule> traitUseRules() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            if (!stub.hasTraitUses()) {
                return JBIterable.empty();
            }
            return JBIterable.of((Object[])((PhpTraitUseRule[])this.getStubOrPsiChildren(PhpStubElementTypes.TRAIT_USE_RULE, PhpTraitUseRule.ARRAY_FACTORY)));
        }
        return this.traitUseLists().flatMap(useList -> PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)useList, PhpTraitUseRule.class));
    }

    @NotNull
    public JBIterable<PhpUseList> traitUseLists() {
        PsiElement child = this.getFirstChild();
        JBIterable jBIterable = JBIterable.generate((Object)child, PsiElement::getNextSibling).filter(PhpUseList.class);
        if (jBIterable == null) {
            PhpClassImpl.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    public PhpClass[] getSupers() {
        ArrayList<PhpClass> superClasses = new ArrayList<PhpClass>(this.getSuperClasses());
        Collections.addAll(superClasses, this.getImplementedInterfaces());
        Collections.addAll(superClasses, this.getTraits());
        return superClasses.toArray(PhpClass.EMPTY_ARRAY);
    }

    public boolean hasOwnStaticMembers() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasOwnStaticMembers();
        }
        for (Method method : this.getOwnMethods()) {
            if (!method.isStatic()) continue;
            return true;
        }
        for (Field field : this.getOwnFieldMap().values()) {
            if (!field.getModifier().isStatic()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PhpModifier getModifier() {
        if (this.isAbstract()) {
            PhpModifier phpModifier = PhpModifier.PUBLIC_ABSTRACT_DYNAMIC;
            if (phpModifier == null) {
                PhpClassImpl.$$$reportNull$$$0(24);
            }
            return phpModifier;
        }
        if (this.isFinal()) {
            PhpModifier phpModifier = PhpModifier.PUBLIC_FINAL_DYNAMIC;
            if (phpModifier == null) {
                PhpClassImpl.$$$reportNull$$$0(25);
            }
            return phpModifier;
        }
        PhpModifier phpModifier = PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC;
        if (phpModifier == null) {
            PhpClassImpl.$$$reportNull$$$0(26);
        }
        return phpModifier;
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getClassPresentation(this);
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor) {
        PhpClassHierarchyUtils.processSuperClasses((PhpClass)this, (boolean)true, (boolean)false, aClass -> !processor.process((Object)aClass.getDocComment()));
    }

    @NotNull
    public ExtendsList getExtendsList() {
        ExtendsList extendsList = (ExtendsList)this.findChildByClass(ExtendsList.class);
        if (extendsList == null) {
            PhpClassImpl.$$$reportNull$$$0(27);
        }
        return extendsList;
    }

    @NotNull
    public ImplementsList getImplementsList() {
        ImplementsList implementsList = (ImplementsList)this.findChildByClass(ImplementsList.class);
        if (implementsList == null) {
            PhpClassImpl.$$$reportNull$$$0(28);
        }
        return implementsList;
    }

    @Override
    @NotNull
    public PhpType getType() {
        if (this.isAnonymous()) {
            PhpType type = new PhpType().add("__anonymous@" + this.getTextOffset());
            type.add(this.getSuperFQN());
            for (String s : this.getInterfaceNames()) {
                type.add(s);
            }
            if (this.findOwnMethodByName("__invoke") != null) {
                type.add(PhpType.CALLABLE);
            }
            PhpType phpType = type.createImmutableType();
            if (phpType == null) {
                PhpClassImpl.$$$reportNull$$$0(29);
            }
            return phpType;
        }
        String fqn = this.getFQN();
        PhpType phpType = new PhpType().add(fqn).createImmutableType();
        if (phpType == null) {
            PhpClassImpl.$$$reportNull$$$0(30);
        }
        return phpType;
    }

    @Override
    public String toString() {
        return "PhpClass: " + this.getName();
    }

    private static boolean isDynamicReference(@NotNull FieldReference ref) {
        PhpExpression classReference;
        if (ref == null) {
            PhpClassImpl.$$$reportNull$$$0(31);
        }
        return (classReference = ref.getClassReference()) != null && ("$this".equals(classReference.getText()) || "parent".equals(classReference.getText()));
    }

    @Nullable
    public Method findOwnMethodByName(@Nullable CharSequence name) {
        return this.findOwnMethodByName(name, (Predicate<? super Method>)Predicates.alwaysTrue());
    }

    @Nullable
    public Method findMethodByName(@Nullable CharSequence name) {
        return PhpClassImpl.findMethodsByName(this, name, new HashSet<PhpClass>()).getAny();
    }

    @NotNull
    public Collection<Method> findMethodsByName(@Nullable CharSequence name) {
        Collection collection = PhpClassImpl.findMethodsByName(this, name, new HashSet<PhpClass>()).getMethods();
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @NotNull
    @ApiStatus.Internal
    public static PhpClass.PhpOverloadedMethods getConstructors(PhpClass aClass, Set<PhpClass> visited) {
        while (aClass != null && !PhpLangUtil.isObject(aClass)) {
            PhpClass[] traits;
            if (aClass.isInterface()) {
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(33);
                }
                return phpOverloadedMethods;
            }
            if (!visited.add(aClass)) {
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(34);
                }
                return phpOverloadedMethods;
            }
            PhpClass.PhpOverloadedMethods own = PhpClassImpl.getOwnConstructors(aClass);
            if (!own.isEmpty()) {
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = own;
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(35);
                }
                return phpOverloadedMethods;
            }
            for (PhpClass trait : traits = aClass.getTraits()) {
                PhpClass.PhpOverloadedMethods constructors = PhpClassImpl.getConstructors(trait, visited);
                if (constructors.isEmpty()) continue;
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = constructors;
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(36);
                }
                return phpOverloadedMethods;
            }
            aClass = aClass.getSuperClass();
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(37);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    public static PhpClass.PhpOverloadedMethods getOwnConstructors(PhpClass aClass) {
        if (aClass.isInterface()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(38);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods c = aClass.findOwnMethodsByName((CharSequence)"__construct").filter(NOT_DOC_METHOD);
        if (c.isEmpty() && "\\".equals(aClass.getNamespaceName())) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = aClass.findOwnMethodsByName((CharSequence)aClass.getName()).filter(NOT_DOC_METHOD);
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(39);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = c;
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(40);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    @ApiStatus.Internal
    public static PhpClass.PhpOverloadedMethods findMethodsByName(@Nullable PhpClass aClass, @Nullable CharSequence name, Collection<PhpClass> visited) {
        if (aClass == null || name == null || !visited.add(aClass)) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(41);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods ownMethods = aClass.findOwnMethodsByName(name);
        if (!ownMethods.isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = ownMethods;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(42);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods methodsFromTrait = PhpClassImpl.findMethodInTraits(aClass, name, visited);
        if (!methodsFromTrait.isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methodsFromTrait;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(43);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods methodFromSuperClass = PhpClassImpl.findMethodInSuperClass(aClass, name, visited);
        if (!methodFromSuperClass.isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methodFromSuperClass;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(44);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods methodFromInterface = PhpClassImpl.findMethodInInterfaces(aClass, name, visited);
        if (!methodFromInterface.isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methodFromInterface;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(45);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.fromMethods(PhpClassImpl.findMethodInClasses(Arrays.stream(aClass.getMixins()), name, visited).values());
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(46);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    private static Map<PhpClass, PhpClass.PhpOverloadedMethods> findMethodInClasses(Stream<PhpClass> classes, @NotNull CharSequence methodName, Collection<PhpClass> visited) {
        Map<PhpClass, PhpClass.PhpOverloadedMethods> methodsInClasses;
        List sortedClasses;
        if (methodName == null) {
            PhpClassImpl.$$$reportNull$$$0(47);
        }
        if ((sortedClasses = (methodsInClasses = PhpClassImpl.methodsInClasses(classes, methodName, visited)).entrySet().stream().sorted(Map.Entry.comparingByKey(COMPARATOR)).map(Map.Entry::getKey).collect(Collectors.toList())).size() > 1 && COMPARATOR.compare((PhpClass)sortedClasses.get(0), (PhpClass)sortedClasses.get(1)) != 0) {
            Map<PhpClass, PhpClass.PhpOverloadedMethods> map = Map.of((PhpClass)sortedClasses.get(0), methodsInClasses.get(sortedClasses.get(0)));
            if (map == null) {
                PhpClassImpl.$$$reportNull$$$0(48);
            }
            return map;
        }
        Map<PhpClass, PhpClass.PhpOverloadedMethods> map = methodsInClasses;
        if (map == null) {
            PhpClassImpl.$$$reportNull$$$0(49);
        }
        return map;
    }

    @NotNull
    private static Map<PhpClass, PhpClass.PhpOverloadedMethods> methodsInClasses(@NotNull Stream<PhpClass> classes, @NotNull CharSequence methodName, Collection<PhpClass> visited) {
        if (classes == null) {
            PhpClassImpl.$$$reportNull$$$0(50);
        }
        if (methodName == null) {
            PhpClassImpl.$$$reportNull$$$0(51);
        }
        Set methods = (Set)StreamEx.of(classes).flatMap(c -> PhpClassImpl.findMethodsByName(c, methodName, visited).getMethods().stream()).collect(Collectors.toSet());
        Map map = StreamEx.of((Collection)methods).mapToEntry(PhpClassMember::getContainingClass, m -> PhpClass.PhpOverloadedMethods.from(Collections.singleton(m))).toMap((o1, o2) -> PhpClass.PhpOverloadedMethods.fromMethods(Set.of(o1, o2)));
        if (map == null) {
            PhpClassImpl.$$$reportNull$$$0(52);
        }
        return map;
    }

    @NotNull
    private static PhpClass.PhpOverloadedMethods findMethodInSuperClass(@NotNull PhpClass aClass, @NotNull CharSequence name, Collection<PhpClass> visited) {
        PhpClass.PhpOverloadedMethods methodsFromBestClass;
        Map<PhpClass, PhpClass.PhpOverloadedMethods> methodsFromSuperClass;
        if (aClass == null) {
            PhpClassImpl.$$$reportNull$$$0(53);
        }
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(54);
        }
        if ((methodsFromSuperClass = PhpClassImpl.findMethodInClasses(PhpClassHierarchyUtils.getSuperClasses((PhpClass)aClass).stream(), name, visited)).size() == 1) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = (PhpClass.PhpOverloadedMethods)ContainerUtil.getFirstItem(methodsFromSuperClass.values());
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(55);
            }
            return phpOverloadedMethods;
        }
        if (methodsFromSuperClass.size() > 1 && !(methodsFromBestClass = PhpClassImpl.chooseMethodFromBestClass(aClass, methodsFromSuperClass)).isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methodsFromBestClass;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(56);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(57);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    private static PhpClass.PhpOverloadedMethods chooseMethodFromBestClass(@NotNull PhpClass aClass, Map<PhpClass, PhpClass.PhpOverloadedMethods> methodsFromSuperClass) {
        if (aClass == null) {
            PhpClassImpl.$$$reportNull$$$0(58);
        }
        Collection<PhpClass> bestClasses = PhpClassImpl.selectBestClasses(methodsFromSuperClass.keySet(), (PhpPsiElement)aClass);
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.fromMethods((Collection)ContainerUtil.map(bestClasses, methodsFromSuperClass::get));
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(59);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    private static PhpClass.PhpOverloadedMethods findMethodInInterfaces(@NotNull PhpClass aClass, @NotNull CharSequence name, Collection<PhpClass> visited) {
        if (aClass == null) {
            PhpClassImpl.$$$reportNull$$$0(60);
        }
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(61);
        }
        PhpIndex index = PhpIndex.getInstance((Project)aClass.getProject());
        Stream<PhpClass> interfaces = Arrays.stream(aClass.getInterfaceNames()).flatMap(interfaceName -> index.getInterfacesByFQN(interfaceName).stream());
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.fromMethods(PhpClassImpl.findMethodInClasses(interfaces, name, visited).values());
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(62);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    private static PhpClass.PhpOverloadedMethods findMethodInTraits(PhpClass aClass, CharSequence methodName, Collection<PhpClass> visited) {
        for (PhpTraitUseRule rule : aClass.traitUseRules()) {
            for (Method method : rule.getMethods()) {
                if (!method.isValid() || !PhpLangUtil.equalsMethodNames(method.getName(), methodName)) continue;
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.from(Collections.singleton(method));
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(63);
                }
                return phpOverloadedMethods;
            }
        }
        for (PhpClass trait : aClass.getTraits()) {
            PhpClass.PhpOverloadedMethods methods = PhpClassImpl.findMethodsByName(trait, methodName, visited);
            if (methods.isEmpty()) continue;
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methods;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(64);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(65);
        }
        return phpOverloadedMethods;
    }

    @Nullable
    public Field findOwnFieldByName(@Nullable CharSequence name, boolean findConstant) {
        Collection fields = this.getOwnFieldMap().get((Object)name);
        for (Field field : fields) {
            if (field.isConstant() != findConstant) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public Field findFieldByName(@Nullable CharSequence name, boolean findConstant) {
        if (name == null) {
            return null;
        }
        Ref result = new Ref();
        PhpClassHierarchyUtils.processSupers((PhpClass)this, (boolean)true, (boolean)true, aClass -> {
            result.set((Object)aClass.findOwnFieldByName(name, findConstant));
            return result.isNull() || result.get() instanceof MyRenamableFakePsiElement;
        });
        return (Field)result.get();
    }

    @Nullable
    public static PhpClass getContainingClass(@NotNull PhpPsiElement point) {
        if (point == null) {
            PhpClassImpl.$$$reportNull$$$0(66);
        }
        if (point instanceof PhpClass) {
            return (PhpClass)point;
        }
        PhpClass outerClass = PhpClassImpl.getOuterClass(point);
        if (outerClass != null && outerClass.isAnonymous()) {
            return PsiTreeUtil.isAncestor(PhpPsiUtil.getChildByCondition((PsiElement)outerClass, (Condition<? super PsiElement>)ParameterList.INSTANCEOF), (PsiElement)point, (boolean)false) ? PhpClassImpl.getOuterClass((PhpPsiElement)outerClass) : outerClass;
        }
        Method method = (Method)PhpPsiUtil.getParentByCondition((PsiElement)point, true, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
        if (method != null) {
            if (point instanceof Variable && "this".equalsIgnoreCase(point.getName()) && method.isStatic()) {
                return null;
            }
            return method.getContainingClass();
        }
        return outerClass;
    }

    @Nullable
    private static PhpClass getOuterClass(@NotNull PhpPsiElement point) {
        if (point == null) {
            PhpClassImpl.$$$reportNull$$$0(67);
        }
        return (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)point, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
    }

    @NotNull
    public String getPresentableFQN() {
        String fqn = this.getFQN();
        String string = PhpLangUtil.toPresentableFQN(fqn);
        if (string == null) {
            PhpClassImpl.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    public static MultiMap<String, FieldReference> getConstructorAssignmentsPerField(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpClassImpl.$$$reportNull$$$0(69);
        }
        MultiMap<String, FieldReference> multiMap = PhpClassImpl.getAssignmentsPerField(phpClass, new FieldsAssignmentsInMethodsCachedValueProvider(phpClass));
        if (multiMap == null) {
            PhpClassImpl.$$$reportNull$$$0(70);
        }
        return multiMap;
    }

    private static MultiMap<String, FieldReference> getAssignmentsPerField(@NotNull PhpClass phpClass, FieldsAssignmentsInMethodsCachedValueProvider provider) {
        if (phpClass == null) {
            PhpClassImpl.$$$reportNull$$$0(71);
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)phpClass, (CachedValueProvider)provider);
    }

    @NotNull
    public static MultiMap<String, AssignmentExpression> getPhpUnitSetUpAssignmentsPerField(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpClassImpl.$$$reportNull$$$0(72);
        }
        MultiMap<String, FieldReference> fields = PhpClassImpl.getAssignmentsPerField(phpClass, new PhpUnitFieldsAssignmentsInMethodsCachedValueProvider(phpClass));
        MultiMap res = new MultiMap();
        for (Map.Entry e : fields.entrySet()) {
            res.put((Object)((String)e.getKey()), (Collection)ContainerUtil.map((Collection)((Collection)e.getValue()), v -> (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)v, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF)));
        }
        MultiMap multiMap = res;
        if (multiMap == null) {
            PhpClassImpl.$$$reportNull$$$0(73);
        }
        return multiMap;
    }

    private static /* synthetic */ boolean lambda$hasStaticMembers$12(Set visited, PhpClass c) {
        return !PhpLangUtil.isObject(c) && !visited.contains(c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 47: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 47: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "my";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 20: 
            case 54: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 53: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 69: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "docProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethodsMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethodsInternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "selectBestClasses";
                break;
            }
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 47: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "useListTargetReferencesFQNs";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitNames";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMixinNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "traitUseLists";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsList";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsList";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 32: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnConstructors";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodInClasses";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "methodsInClasses";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodInSuperClass";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseMethodFromBestClass";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodInInterfaces";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodInTraits";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFQN";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorAssignmentsPerField";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpUnitSetUpAssignmentsPerField";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProximity";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findOwnMethodByName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicReference";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInClasses";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "methodsInClasses";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInSuperClass";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "chooseMethodFromBestClass";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInInterfaces";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getOuterClass";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorAssignmentsPerField";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentsPerField";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getPhpUnitSetUpAssignmentsPerField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 47: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldsAssignmentsInMethodsCachedValueProvider
    implements CachedValueProvider<MultiMap<String, FieldReference>> {
        protected final PhpClass myClass;

        FieldsAssignmentsInMethodsCachedValueProvider(PhpClass aClass) {
            this.myClass = aClass;
        }

        @NotNull
        public CachedValueProvider.Result<MultiMap<String, FieldReference>> compute() {
            final MultiMap accessMap = new MultiMap();
            final MultiMap instructionsMap = new MultiMap();
            for (Method method : this.getMethods()) {
                PhpControlFlow flow;
                int numberOfInstructions;
                if (method == null || (numberOfInstructions = (flow = method.getControlFlow()).getInstructions().length) == 0) continue;
                PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)flow.getExitPoint(), false, new PhpInstructionProcessor(){

                    public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                        return this.processFieldAccessInstruction((PhpAccessInstruction)instruction);
                    }

                    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                        return this.processFieldAccessInstruction((PhpAccessInstruction)instruction);
                    }

                    private boolean processFieldAccessInstruction(PhpAccessInstruction instruction) {
                        FieldReference reference = (FieldReference)ObjectUtils.tryCast((Object)instruction.getAnchor(), FieldReference.class);
                        if (reference == null) {
                            return true;
                        }
                        AssignmentExpression expr = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
                        if (expr == null || !instruction.getAccess().isWrite()) {
                            return true;
                        }
                        try {
                            PhpExpression classReference = reference.getClassReference();
                            if (classReference != null && ("$this".equals(classReference.getText()) || "self".equals(classReference.getText())) && reference.getNameNode() != null) {
                                @NonNls String name = reference.getName();
                                if (numberOfInstructions < 1000) {
                                    for (PhpAccessInstruction alreadyProcessedSuccessor : instructionsMap.get((Object)name)) {
                                        if (!PhpControlFlowUtil.isPredecessor((PhpInstruction)alreadyProcessedSuccessor, (PhpInstruction)instruction)) continue;
                                        return true;
                                    }
                                }
                                if (StringUtil.isNotEmpty((String)name)) {
                                    accessMap.putValue((Object)name, (Object)reference);
                                    instructionsMap.putValue((Object)name, (Object)instruction);
                                }
                            }
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("expr = " + expr.getText() + " for " + myClass.getText(), e);
                        }
                        return true;
                    }
                });
            }
            return new CachedValueProvider.Result((Object)accessMap, new Object[]{this.myClass});
        }

        protected Collection<Method> getMethods() {
            Method constructor = this.myClass.getOwnConstructor();
            return constructor != null ? Collections.singleton(constructor) : Collections.emptyList();
        }
    }

    private static class PhpUnitFieldsAssignmentsInMethodsCachedValueProvider
    extends FieldsAssignmentsInMethodsCachedValueProvider {
        PhpUnitFieldsAssignmentsInMethodsCachedValueProvider(PhpClass aClass) {
            super(aClass);
        }

        @Override
        protected Collection<Method> getMethods() {
            SmartList res = new SmartList();
            ContainerUtil.addIfNotNull((Collection)res, (Object)this.myClass.findOwnMethodByName((CharSequence)"setUp"));
            ContainerUtil.addIfNotNull((Collection)res, (Object)this.myClass.findOwnMethodByName((CharSequence)"setUpBeforeClass"));
            return res;
        }
    }

    public static class MyASTRenamableFakePsiElement
    extends MyRenamableFakePsiElement {
        public MyASTRenamableFakePsiElement(PhpClass containingClass, @NotNull FieldReference ref) {
            if (ref == null) {
                MyASTRenamableFakePsiElement.$$$reportNull$$$0(0);
            }
            super(ref.getTextRange(), containingClass, PhpClassImpl.isDynamicReference(ref), MyASTRenamableFakePsiElement.getType(ref), ref.getName());
        }

        @NotNull
        private static PhpType getType(@NotNull FieldReference ref) {
            if (ref == null) {
                MyASTRenamableFakePsiElement.$$$reportNull$$$0(1);
            }
            PhpTypeAnalyserVisitor visitor = new PhpTypeAnalyserVisitor();
            visitor.addTypeFromExpression((PhpExpression)ref);
            PhpType phpType = visitor.getType();
            if (phpType == null) {
                MyASTRenamableFakePsiElement.$$$reportNull$$$0(2);
            }
            return phpType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyASTRenamableFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyASTRenamableFakePsiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyRenamableFakePsiElement
    extends RenameableFakePsiElement
    implements Field {
        private final TextRange myRange;
        protected final PhpType myType;
        protected final boolean myDynamic;
        protected final String myName;

        protected MyRenamableFakePsiElement(TextRange range, PhpClass containingClass, boolean dynamic, @NotNull PhpType type, String name) {
            if (type == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(0);
            }
            super((PsiElement)containingClass);
            this.myRange = range;
            this.myType = type;
            this.myDynamic = dynamic;
            this.myName = name;
        }

        public boolean isValid() {
            return super.getParent().isValid() && super.isValid();
        }

        @Nullable
        private FieldReference findFieldReference() {
            PsiElement elementAt;
            for (elementAt = this.getContainingFile().findElementAt(this.myRange.getStartOffset()); elementAt != null && !elementAt.getTextRange().equals((Object)this.myRange); elementAt = elementAt.getParent()) {
            }
            return (FieldReference)ObjectUtils.tryCast((Object)elementAt, FieldReference.class);
        }

        public String getTypeName() {
            return PhpBundle.message("constructor.field", new Object[0]);
        }

        public Icon getIcon() {
            return null;
        }

        @NotNull
        public String getFQN() {
            String string = this.getContainingClass().getFQN() + "->" + this.getName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getNamespaceName() {
            String string = this.getContainingClass().getNamespaceName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isDeprecated() {
            return false;
        }

        public boolean isInternal() {
            return false;
        }

        public PsiElement getParent() {
            return this.findFieldReference();
        }

        public ASTNode getNameNode() {
            FieldReference reference = this.findFieldReference();
            return reference != null ? reference.getNameNode() : null;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public TextRange getTextRange() {
            return this.myRange;
        }

        @NotNull
        public CharSequence getNameCS() {
            String string = this.getName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        public PhpDocComment getDocComment() {
            return null;
        }

        public void processDocs(Processor<PhpDocComment> processor) {
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)this, (method, subClass, baseClass) -> !processor.process((Object)method.getDocComment()));
        }

        @NotNull
        public PhpModifier getModifier() {
            PhpModifier phpModifier = this.myDynamic ? PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC : PhpModifier.PUBLIC_IMPLEMENTED_STATIC;
            if (phpModifier == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(5);
            }
            return phpModifier;
        }

        @NotNull
        public PhpClass getContainingClass() {
            PhpClass phpClass = (PhpClass)super.getParent();
            if (phpClass == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(6);
            }
            return phpClass;
        }

        public boolean isConstant() {
            return false;
        }

        public PsiElement getDefaultValue() {
            return null;
        }

        public String getDefaultValuePresentation() {
            return null;
        }

        @Nullable
        public PhpClassFieldsList getParentList() {
            return null;
        }

        public boolean isWriteAccess() {
            return true;
        }

        public PhpPsiElement getFirstPsiChild() {
            return null;
        }

        public PhpPsiElement getNextPsiSibling() {
            return null;
        }

        public PhpPsiElement getPrevPsiSibling() {
            return null;
        }

        @NotNull
        public PhpType getType() {
            PhpType phpType = this.myType;
            if (phpType == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(7);
            }
            return phpType;
        }

        public PsiElement getNameIdentifier() {
            return null;
        }

        public String toString() {
            return "FakeConstructorField " + this.getName();
        }

        @Nullable
        public PhpFieldType getTypeDeclaration() {
            return null;
        }

        @NotNull
        public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            FieldReference fieldReference = this.findFieldReference();
            if (fieldReference == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(9);
            }
            return fieldReference;
        }

        public boolean isDynamic() {
            return this.myDynamic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyRenamableFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyRenamableFakePsiElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFQN";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameCS";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifier";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingClass";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

