/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocParamTagImpl;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpASTElementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterListImpl
extends PhpASTElementImpl
implements ParameterList {
    @NotNull
    private static final Condition<PsiElement> NAME_NODE = e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.IDENTIFIER, PhpTokenTypes.opCOLON);
    private static final Condition<PsiElement> PARAMETER_CONDITION = Conditions.not(ParameterListImpl.anyOf(PhpPsiUtil.PSI_COMMENT_INSTANCEOF, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF, NAME_NODE));
    private static final Condition<PsiElement> SKIP_INSIDE_NAMED_ARGUMENT_PART = Conditions.or(PsiWhiteSpace.class::isInstance, PsiComment.class::isInstance);

    @NotNull
    private static <T> Condition<T> anyOf(Condition<T> ... conditions) {
        if (conditions.length == 0) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                ParameterListImpl.$$$reportNull$$$0(0);
            }
            return condition;
        }
        Condition condition = conditions[0];
        for (int i = 1; i < conditions.length; ++i) {
            condition = Conditions.or(condition, conditions[i]);
        }
        Condition condition2 = condition;
        if (condition2 == null) {
            ParameterListImpl.$$$reportNull$$$0(1);
        }
        return condition2;
    }

    public ParameterListImpl(ASTNode node) {
        super(node);
    }

    public PsiElement @NotNull [] getParameters() {
        List<PsiElement> childrenByCondition = PhpPsiUtil.getChildren((PsiElement)this, PARAMETER_CONDITION);
        PsiElement[] psiElementArray = childrenByCondition.isEmpty() ? PsiElement.EMPTY_ARRAY : childrenByCondition.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ParameterListImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Nullable
    public PsiElement getParameter(int index) {
        if (index < 0) {
            return null;
        }
        int counter = 0;
        for (Object cur = PhpPsiUtil.getChildByCondition((PsiElement)this, PARAMETER_CONDITION); cur != null; cur = cur.getNextSibling()) {
            if (!(cur.getNode() instanceof CompositeElement) || !PARAMETER_CONDITION.value(cur) || counter++ != index) continue;
            return cur;
        }
        return null;
    }

    public void removeParameter(@NotNull PsiElement parameter) {
        PhpDocParamTagImpl docTag;
        if (parameter == null) {
            ParameterListImpl.$$$reportNull$$$0(3);
        }
        PsiElement identifier = ParameterListImpl.getNameIdentifier(parameter);
        if (parameter instanceof ParameterImpl && (docTag = (PhpDocParamTagImpl)((ParameterImpl)parameter).getDocTag()) != null) {
            docTag.deleteWithLeadingAsterisk();
        }
        if (identifier != null) {
            this.deleteChildRange(identifier, parameter.getPrevSibling());
        }
        if (this.getParameters().length == 1) {
            if (this.hasTrailingComma()) {
                this.getLastChild().delete();
            }
            parameter.delete();
        } else {
            PhpCodeEditUtil.removeStatementWithDelivery(parameter, PhpTokenTypes.opCOMMA);
        }
    }

    @Nullable
    public PsiElement getParameter(@NotNull String name) {
        if (name == null) {
            ParameterListImpl.$$$reportNull$$$0(4);
        }
        return PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)((Condition)e -> {
            PsiElement identifier = ParameterListImpl.getNameIdentifier(e);
            return PARAMETER_CONDITION.value(e) && identifier != null && name.equalsIgnoreCase(identifier.getText());
        }));
    }

    @Nullable
    public PsiElement getParameter(@NotNull String name, int index) {
        if (name == null) {
            ParameterListImpl.$$$reportNull$$$0(5);
        }
        return Optional.ofNullable(this.getParameter(name)).orElse(this.getParameter(index));
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            ParameterListImpl.$$$reportNull$$$0(6);
        }
        phpElementVisitor.visitPhpParameterList((ParameterList)this);
    }

    @Nullable
    public static PsiElement getNameIdentifier(@Nullable PsiElement argument) {
        if (argument == null) {
            return null;
        }
        PsiElement colon = PhpPsiUtil.getPrevSibling(argument, SKIP_INSIDE_NAMED_ARGUMENT_PART);
        if (!PhpPsiUtil.isOfType(colon, PhpTokenTypes.opCOLON)) {
            return null;
        }
        PsiElement identifier = PhpPsiUtil.getPrevSibling(colon, SKIP_INSIDE_NAMED_ARGUMENT_PART);
        return PhpPsiUtil.isOfType(identifier, PhpTokenTypes.IDENTIFIER) ? identifier : null;
    }

    @NotNull
    public Collection<PhpNamedArgumentPart> getNamedArgumentsParts() {
        PsiElement child = this.getFirstChild();
        ArrayList<PhpNamedArgumentPart> res = new ArrayList<PhpNamedArgumentPart>();
        while (child != null) {
            PsiElement colon;
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.IDENTIFIER) && (colon = PhpPsiUtil.getNextSibling(child, SKIP_INSIDE_NAMED_ARGUMENT_PART)) != null) {
                res.add(new PhpNamedArgumentPart(child, colon));
                child = colon;
            }
            child = PhpPsiUtil.getNextSibling(child, SKIP_INSIDE_NAMED_ARGUMENT_PART);
        }
        ArrayList<PhpNamedArgumentPart> arrayList = res;
        if (arrayList == null) {
            ParameterListImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            ParameterListImpl.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    public boolean hasTrailingComma() {
        return PhpPsiUtil.isOfType(this.getLastChild(), PhpTokenTypes.opCOMMA);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ParameterListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "anyOf";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ParameterListImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedArgumentsParts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeParameter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpNamedArgumentPart {
        @NotNull
        private final PsiElement myNameIdentifier;
        @NotNull
        private final PsiElement myColon;

        public PhpNamedArgumentPart(@NotNull PsiElement nameIdentifier, @NotNull PsiElement colon) {
            if (nameIdentifier == null) {
                PhpNamedArgumentPart.$$$reportNull$$$0(0);
            }
            if (colon == null) {
                PhpNamedArgumentPart.$$$reportNull$$$0(1);
            }
            this.myNameIdentifier = nameIdentifier;
            this.myColon = colon;
        }

        @NotNull
        public PsiElement getNameIdentifier() {
            PsiElement psiElement = this.myNameIdentifier;
            if (psiElement == null) {
                PhpNamedArgumentPart.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @NotNull
        public PsiElement getColon() {
            PsiElement psiElement = this.myColon;
            if (psiElement == null) {
                PhpNamedArgumentPart.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        public TextRange getRangeInParent() {
            return TextRange.create((int)this.myNameIdentifier.getTextRangeInParent().getStartOffset(), (int)this.myColon.getTextRangeInParent().getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colon";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ParameterListImpl$PhpNamedArgumentPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ParameterListImpl$PhpNamedArgumentPart";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameIdentifier";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

