/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.FunctionReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceImpl
extends MemberReferenceImpl
implements MethodReference {
    private static final TokenSet NN = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsKEYWORDS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER})});

    public MethodReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            MethodReferenceImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpMethodReference((MethodReference)this);
    }

    public ParameterList getParameterList() {
        return (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    public PsiElement @NotNull [] getParameters() {
        ParameterList list = this.getParameterList();
        PsiElement[] psiElementArray = list != null ? list.getParameters() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            MethodReferenceImpl.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    @Nullable
    public PhpExpression getClassReference() {
        PhpUse[] declarations;
        PhpExpression reference = super.getClassReference();
        if (reference != null) {
            return reference;
        }
        PhpTraitUseRule rule = (PhpTraitUseRule)PhpPsiUtil.getParentByCondition((PsiElement)this, true, (Condition<? super PsiElement>)PhpTraitUseRule.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (rule != null && (declarations = ((PhpUseList)rule.getParent()).getDeclarations()).length == 1) {
            return declarations[0].getTargetReference();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        Collection<? extends PhpNamedElement> result = super.resolveLocal();
        if (!result.isEmpty()) {
            Collection<? extends PhpNamedElement> collection = result;
            if (collection == null) {
                MethodReferenceImpl.$$$reportNull$$$0(2);
            }
            return collection;
        }
        return this.resolveTraitUseRule(true);
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        Collection<? extends PhpNamedElement> targets = this.resolveLocal();
        Collection<PhpNamedElement> targetsWithNonRecursiveCalls = FunctionReferenceImpl.getNonRecursiveTargets((FunctionReference)this, targets);
        PhpType res = FunctionReferenceImpl.getTypeFromRecursiveTargets(targets, targetsWithNonRecursiveCalls);
        PhpType phpType = res.add(this.getType(targetsWithNonRecursiveCalls));
        if (phpType == null) {
            MethodReferenceImpl.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        if (this.getParent() instanceof PhpTraitUseRule && !(this.getFirstPsiChild() instanceof ClassReference)) {
            return this.resolveTraitUseRule(false);
        }
        Collection<? extends PhpNamedElement> collection = super.resolveGlobal(incompleteCode);
        if (collection == null) {
            MethodReferenceImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private Collection<? extends PhpNamedElement> resolveTraitUseRule(boolean localOnly) {
        if (!(this.getParent() instanceof PhpTraitUseRule)) {
            List list = Collections.emptyList();
            if (list == null) {
                MethodReferenceImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        LinkedHashSet<PhpNamedElement> res = new LinkedHashSet<PhpNamedElement>();
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)this, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (containingClass != null) {
            for (PhpClass trait : containingClass.getTraits()) {
                res.addAll(this.resolveMember(trait, localOnly));
            }
        }
        LinkedHashSet<PhpNamedElement> linkedHashSet = res;
        if (linkedHashSet == null) {
            MethodReferenceImpl.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    public Set<PhpNamedElement> resolveMember(@NotNull PhpClass klass, boolean localOnly) {
        PhpClass containingClass;
        if (klass == null) {
            MethodReferenceImpl.$$$reportNull$$$0(7);
        }
        if (localOnly) {
            PhpClass.PhpOverloadedMethods methods = klass.findOwnMethodsByName((CharSequence)this.getName());
            return new HashSet<PhpNamedElement>(methods.getMethods());
        }
        PhpClass.PhpOverloadedMethods methods = PhpClassImpl.findMethodsByName(klass, this.getName(), new HashSet<PhpClass>());
        if (!methods.isEmpty() && (containingClass = methods.getAny().getContainingClass()) != null && !PhpLangUtil.isObject(containingClass)) {
            return MethodReferenceImpl.chooseOverloadedMethods((ParameterListOwner)this, methods);
        }
        return Collections.emptySet();
    }

    public static Set<PhpNamedElement> chooseOverloadedMethods(ParameterListOwner reference, PhpClass.PhpOverloadedMethods overloadedMethods) {
        return StreamEx.of((Collection)overloadedMethods.getMethods()).groupingBy(PhpClassMember::getContainingClass).values().stream().flatMap(m -> MethodReferenceImpl.chooseOverloadedMethods(reference, m).stream()).collect(Collectors.toSet());
    }

    @NotNull
    private static Set<PhpNamedElement> chooseOverloadedMethods(ParameterListOwner reference, Collection<Method> methods) {
        if (methods.size() == 1) {
            return new HashSet<Method>(methods);
        }
        Method methodWithMatchingSignatures = (Method)ContainerUtil.find(methods, m -> MethodReferenceImpl.signatureMatches(reference, m));
        return methodWithMatchingSignatures != null ? Collections.singleton(methodWithMatchingSignatures) : new HashSet<Method>(methods);
    }

    private static boolean signatureMatches(ParameterListOwner call, Method method) {
        Object[] parameters;
        HashMap<PsiElement, ProblemDescriptor> problems = new HashMap<PsiElement, ProblemDescriptor>();
        Object[] arguments = call.getParameters();
        if (!(arguments.length <= (parameters = method.getParameters()).length || parameters.length > 0 && ((Parameter)ArrayUtil.getLastElement((Object[])parameters)).isVariadic())) {
            return false;
        }
        PhpParamsInspection.checkMissingParameter((PhpPsiElement)call, Arrays.asList(arguments), Arrays.asList(parameters), problems, true, true);
        if (!problems.isEmpty()) {
            return false;
        }
        PhpParamsInspection.checkParametersTypes(PhpParamsInspection.createCachedTypeFunc((PsiElement[])arguments), (PhpPsiElement)call, Arrays.asList(arguments), Arrays.asList(parameters), problems, true);
        if (!problems.isEmpty()) {
            return false;
        }
        return !ContainerUtil.exists((Object[])arguments, MethodReferenceImpl::isTypeAmbiguous);
    }

    private static boolean isTypeAmbiguous(PsiElement argument) {
        PhpType t = new PhpType().add(argument).global(argument.getProject());
        return t.isEmpty() || t.hasUnknown();
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            MethodReferenceImpl.$$$reportNull$$$0(8);
        }
        if (element instanceof PhpTraitUseRule) {
            List methods = ((PhpTraitUseRule)element).getMethods();
            return Arrays.stream(this.multiResolve(false)).map(ResolveResult::getElement).anyMatch(methods::contains);
        }
        return super.isReferenceTo(element);
    }

    @Override
    protected PhpTypeSignatureKey getTypeSignatureKey() {
        return PhpTypeSignatureKey.METHOD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/MethodReferenceImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/MethodReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTraitUseRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

