/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MemberReferenceImpl
extends PhpReferenceImpl
implements MemberReference {
    protected MemberReferenceImpl(ASTNode node) {
        super(node);
    }

    @Nullable
    public PhpExpression getClassReference() {
        PhpPsiElement firstPsiChild = this.getFirstPsiChild();
        if (firstPsiChild instanceof PhpExpression) {
            return (PhpExpression)firstPsiChild;
        }
        return null;
    }

    @NotNull
    public PhpModifier.State getReferenceType() {
        PhpExpression ref = this.getClassReference();
        if (ref != null) {
            if (!(ref instanceof Variable) && !(ref instanceof FieldReference) && "parent".equals(ref.getName())) {
                PhpModifier.State state = PhpModifier.State.PARENT;
                if (state == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(0);
                }
                return state;
            }
            PsiElement nextSibling = ref.getNextSibling();
            if (PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.SCOPE_RESOLUTION)) {
                PhpModifier.State state = PhpModifier.State.STATIC;
                if (state == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(1);
                }
                return state;
            }
        }
        PhpModifier.State state = PhpModifier.State.DYNAMIC;
        if (state == null) {
            MemberReferenceImpl.$$$reportNull$$$0(2);
        }
        return state;
    }

    public boolean hasNullSafeDereference() {
        PhpExpression reference = this.getClassReference();
        return this.isNullSafeDereference() || reference instanceof MemberReference && ((MemberReference)reference).hasNullSafeDereference();
    }

    public boolean isNullSafeDereference() {
        PhpExpression reference1 = this.getClassReference();
        return PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)reference1, true), PhpTokenTypes.opQUEST);
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        return MemberReferenceImpl.resolveLocal(this);
    }

    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = this.getType(this.resolveLocal());
        if (phpType == null) {
            MemberReferenceImpl.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    @NotNull
    protected PhpType getType(Collection<? extends PhpNamedElement> phpNamedElements) {
        PhpType resultType = new PhpType();
        for (PhpNamedElement phpNamedElement : phpNamedElements) {
            PhpType type = phpNamedElement.getType();
            Set types = type.getTypes();
            for (String s : types) {
                if (("$this".equals(s) || "static".equals(s)) && phpNamedElement instanceof PhpClassMember) {
                    resultType.add((PsiElement)((PhpClassMember)phpNamedElement).getContainingClass());
                    continue;
                }
                resultType.add(s);
            }
        }
        PhpExpression classReference = this.getClassReference();
        PhpType phpType = new PhpType();
        for (String name : resultType.getTypes()) {
            if (name.equals("static") && classReference instanceof ClassReference) {
                PhpType phpType2 = phpType.add(((ClassReference)classReference).resolveLocalType());
                if (phpType2 == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(4);
                }
                return phpType2;
            }
            phpType.add(name);
        }
        PhpType phpType3 = phpType;
        if (phpType3 == null) {
            MemberReferenceImpl.$$$reportNull$$$0(5);
        }
        return phpType3;
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> resolveLocal(@NotNull MemberReferenceImpl reference) {
        if (reference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(6);
        }
        THashSet result = new THashSet();
        PhpExpression classReference = reference.getClassReference();
        if (classReference instanceof PhpReference) {
            Set<? extends PhpNamedElement> c;
            if (MemberReferenceImpl.getDepth(classReference) >= 100) {
                Set set = Collections.emptySet();
                if (set == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(7);
                }
                return set;
            }
            if (PhpLangUtil.isThisReference((PsiElement)classReference) && (c = MemberReferenceImpl.resolveThisReference(reference)) != null) {
                result.addAll(c);
                THashSet tHashSet = result;
                if (tHashSet == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(8);
                }
                return tHashSet;
            }
            Collection phpNamedElements = ((PhpReference)classReference).resolveLocal();
            for (PhpNamedElement element : phpNamedElements) {
                AssignmentExpression parentAssignment;
                if (element instanceof Variable && classReference instanceof Variable && (parentAssignment = (AssignmentExpression)ObjectUtils.tryCast((Object)element.getParent(), AssignmentExpression.class)) != null && parentAssignment.getVariable() == element && PsiTreeUtil.isAncestor((PsiElement)parentAssignment.getValue(), (PsiElement)classReference, (boolean)false)) continue;
                PhpType type = element.getType();
                Set types = type.getTypes();
                PsiFile file = reference.getContainingFile();
                if (!(file instanceof PhpFile)) continue;
                MultiMap defs = ((PhpFile)file).getTopLevelDefs();
                for (String fqn : types) {
                    Set<PhpClass> aClasses = fqn.startsWith("__anonymous@") ? Collections.singleton(PhpCompletionContributor.findAnonymousClass((PsiElement)reference, fqn)) : defs.get((Object)fqn);
                    for (PhpNamedElement phpNamedElement : aClasses) {
                        if (!(phpNamedElement instanceof PhpClass) || ((PhpClass)phpNamedElement).isTrait()) continue;
                        Set<? extends PhpNamedElement> elements = reference.resolveMember((PhpClass)phpNamedElement, true);
                        result.addAll(elements);
                    }
                }
            }
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            MemberReferenceImpl.$$$reportNull$$$0(9);
        }
        return tHashSet;
    }

    @Nullable
    public static Set<? extends PhpNamedElement> resolveThisReference(@NotNull MemberReferenceImpl reference) {
        PhpClass aClass;
        if (reference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(10);
        }
        if ((aClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)reference, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && !aClass.isTrait()) {
            return reference.resolveMember(aClass, true);
        }
        return null;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        THashSet result = new THashSet();
        PhpExpression classReference = this.getClassReference();
        if (classReference != null) {
            if (MemberReferenceImpl.getDepth(classReference) >= 100) {
                Set set = Collections.emptySet();
                if (set == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(11);
                }
                return set;
            }
            Project project = this.getProject();
            result.addAll(MemberReferenceImpl.resolveInHierarchy(this));
            if (result.isEmpty()) {
                PhpType phpType = classReference.getGlobalType();
                for (String fqn : phpType.getTypes()) {
                    MemberReferenceImpl.lookInSubclasses(project, this, fqn).forEach(((Set)result)::add);
                }
            }
        }
        Collection collection = PhpReferenceImpl.extendedResolve2(this, result);
        if (collection == null) {
            MemberReferenceImpl.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public static Collection<? extends PhpNamedElement> resolveInHierarchy(@NotNull MemberReference memberReference) {
        if (memberReference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(13);
        }
        return (Collection)CachedValuesManager.getCachedValue((PsiElement)memberReference, () -> {
            Set classReferenceTypes;
            PhpExpression classReference = memberReference.getClassReference();
            Set set = classReferenceTypes = classReference != null ? classReference.getGlobalType().filterPlurals().getTypes() : Collections.emptySet();
            if (classReference != null && IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace((String)String.format("Resolve member reference: %s\nClass reference: %s\n Class type: %s", memberReference.getText(), classReference.getText(), classReferenceTypes));
            }
            return CachedValueProvider.Result.createSingleDependency(MemberReferenceImpl.resolveInHierarchyInner(memberReference, classReferenceTypes), (Object)PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    private static Collection<? extends PhpNamedElement> resolveInHierarchyInner(MemberReference memberReference, Collection<String> classReferenceTypes) {
        Project project = memberReference.getProject();
        THashSet result = new THashSet();
        PhpClass aClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)memberReference, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        for (String fqn : classReferenceTypes) {
            if (aClass != null && PhpLangUtil.equalsClassNames(aClass.getFQN(), fqn)) {
                result.addAll(((MemberReferenceImpl)memberReference).resolveMember(aClass, false));
                if (!result.isEmpty() || !aClass.isTrait()) continue;
                AtomicInteger count = new AtomicInteger(0);
                PhpIndex.getInstance((Project)project).processNestedTraitUsages(aClass, null, arg_0 -> MemberReferenceImpl.lambda$resolveInHierarchyInner$1(memberReference, (Set)result, count, arg_0));
                continue;
            }
            Collection<PhpClass> classes = ((MemberReferenceImpl)memberReference).findClasses(project, fqn);
            if (aClass != null && classes.contains(aClass)) {
                result.addAll(((MemberReferenceImpl)memberReference).resolveMember(aClass, false));
                continue;
            }
            for (PhpClass phpClass : classes) {
                result.addAll(((MemberReferenceImpl)memberReference).resolveMember(phpClass, false));
            }
        }
        return PhpReferenceImpl.extendedResolve2((PhpReference)memberReference, result);
    }

    public static Stream<? extends PhpNamedElement> lookInSubclasses(Project project, @NotNull MemberReference memberReference, @NotNull String classFqn) {
        PhpExpression classReference;
        if (memberReference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(14);
        }
        if (classFqn == null) {
            MemberReferenceImpl.$$$reportNull$$$0(15);
        }
        if (memberReference.isStatic() && (classReference = memberReference.getClassReference()) instanceof ClassReference && !PhpLangUtil.isStaticReference((ClassReference)classReference)) {
            return Stream.empty();
        }
        if (!(memberReference instanceof MemberReferenceImpl) || PhpLangUtil.equalsClassNames("\\stdClass", classFqn)) {
            return Stream.empty();
        }
        return PhpIndex.getInstance((Project)project).getAllSubclasses(classFqn).stream().flatMap(subclass -> ((MemberReferenceImpl)memberReference).resolveMember((PhpClass)subclass, true).stream()).distinct();
    }

    @NotNull
    private Collection<PhpClass> findClasses(Project project, @NotNull String fqn) {
        PhpClass phpClass;
        if (fqn == null) {
            MemberReferenceImpl.$$$reportNull$$$0(16);
        }
        List<PhpClass> classes = fqn.startsWith("__anonymous@") ? ((phpClass = (PhpClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.getContainingFile(), (int)Integer.parseInt(fqn.substring("__anonymous@".length())), PhpClass.class, (boolean)true)) != null ? Collections.singletonList(phpClass) : ContainerUtil.emptyList()) : PhpIndex.getInstance((Project)project).getAnyByFQN(fqn);
        Set set = ContainerUtil.union(PhpLangUtil.getLocalClasses((PsiElement)this, fqn), (Collection)classes);
        if (set == null) {
            MemberReferenceImpl.$$$reportNull$$$0(17);
        }
        return set;
    }

    public static int getDepth(PhpExpression reference) {
        int d = 0;
        while (reference instanceof MemberReference && ++d <= 101) {
            reference = ((MemberReference)reference).getClassReference();
        }
        return d;
    }

    @NotNull
    public String getSignature() {
        PhpExpression reference = this.getClassReference();
        if (reference instanceof ClassReference && PhpLangUtil.isParentReference((PsiElement)reference)) {
            PhpClass containingClass;
            Function method = (Function)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)Function.INSTANCEOF);
            PhpClass phpClass = containingClass = method instanceof Method ? ((Method)method).getContainingClass() : null;
            if (containingClass != null) {
                String rs = PhpTypeSignatureKey.CLASS.sign((CharSequence)containingClass.getFQN());
                String string = PhpTypeSignatureKey.PARENT.sign((CharSequence)this.getTypeSignatureKey().sign((CharSequence)(rs + "." + this.getName())));
                if (string == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(18);
                }
                return string;
            }
        }
        StringBuilder result = new StringBuilder();
        if (reference != null) {
            Set types = reference.getType().getTypes();
            for (String type : types) {
                String rs;
                if (PhpType.isNotExtendablePrimitiveType((String)type) || (rs = PhpTypeSignatureKey.CLASS.signIfUnsigned(type)).length() <= 2) continue;
                if (result.length() > 0) {
                    result.append('|');
                }
                result.append(this.isFluentMethodCall(rs) ? rs : this.getTypeSignatureKey().sign((CharSequence)(rs + "." + this.getName())));
            }
        }
        String string = result.toString();
        if (string == null) {
            MemberReferenceImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    private boolean isFluentMethodCall(String signature) {
        return this.isSignedByCurrentMemberReference(signature) && this.isSignedByCurrentMemberReference(MemberReferenceImpl.extractClassReference(signature));
    }

    @NotNull
    private static String extractClassReference(String signature) {
        String string = signature.substring(2, signature.lastIndexOf(46));
        if (string == null) {
            MemberReferenceImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    private boolean isSignedByCurrentMemberReference(String rs) {
        return this.getTypeSignatureKey().isSigned(rs) && rs.substring(rs.lastIndexOf(46) + 1).equals(this.getName());
    }

    public boolean isStatic() {
        return this.findChildByType(PhpTokenTypes.SCOPE_RESOLUTION) != null;
    }

    protected abstract PhpTypeSignatureKey getTypeSignatureKey();

    public abstract Set<? extends PhpNamedElement> resolveMember(@NotNull PhpClass var1, boolean var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            MemberReferenceImpl.$$$reportNull$$$0(21);
        }
        if (!(element instanceof PhpClassMember)) return false;
        if (!Arrays.stream(this.multiResolve(false)).filter(ResolveResult::isValidResult).map(ResolveResult::getElement).anyMatch(element::equals)) return false;
        return true;
    }

    private static /* synthetic */ boolean lambda$resolveInHierarchyInner$1(MemberReference memberReference, Set result, AtomicInteger count, PhpClass aClass1) {
        Set<? extends PhpNamedElement> elements = ((MemberReferenceImpl)memberReference).resolveMember(aClass1, false);
        result.addAll(elements);
        return result.size() < 100 && count.incrementAndGet() < 1000;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/MemberReferenceImpl";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/MemberReferenceImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClassReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveThisReference";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveInHierarchy";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lookInSubclasses";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

