/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpReferenceContributor;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpPotentialGlobalEntryTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionReferenceImpl
extends PhpReferenceImpl
implements FunctionReference {
    public FunctionReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpFunctionCall((FunctionReference)this);
    }

    @Nullable
    public ParameterList getParameterList() {
        return (ParameterList)PsiTreeUtil.getChildOfType((PsiElement)this, ParameterList.class);
    }

    public PsiElement @NotNull [] getParameters() {
        ParameterList list = this.getParameterList();
        PsiElement[] psiElementArray = list != null ? list.getParameters() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    @Nullable
    public String getName() {
        PhpPsiElement child = this.getFirstPsiChild();
        if (child instanceof StringLiteralExpression) {
            return ((StringLiteralExpression)child).getContents();
        }
        return super.getName();
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        Collection<? extends PhpNamedElement> locals = this.resolveLocal();
        String name = this.getName();
        String namespaceName = this.getNamespaceName();
        boolean allowGlobal = FunctionReferenceImpl.allowGlobal(this);
        THashSet result = new THashSet();
        for (PhpNamedElement phpNamedElement : locals) {
            if (phpNamedElement instanceof PhpUse) {
                PhpReference reference = ((PhpUse)phpNamedElement).getTargetReference();
                if (reference == null) continue;
                name = reference.getName();
                namespaceName = reference.getNamespaceName();
                allowGlobal = false;
                continue;
            }
            if (!(phpNamedElement instanceof Function)) continue;
            result.add(phpNamedElement);
        }
        if (result.size() == 0) {
            if (StringUtil.isNotEmpty((String)name)) {
                PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
                Collection collection = phpIndex.getFunctionsByName(name);
                Collection filtered = phpIndex.filterByNamespace(collection, namespaceName, allowGlobal);
                result.addAll(filtered);
            } else {
                PhpReference reference = FunctionReferenceImpl.getReference(FunctionReferenceImpl.unparenthesize(this.getFirstPsiChild()));
                if (reference != null) {
                    PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
                    for (String type : reference.getGlobalType().getTypes()) {
                        for (PhpClass phpClass : phpIndex.getAnyByFQN(type)) {
                            PhpClass containingClass;
                            Method invoke2 = phpClass.findMethodByName((CharSequence)"__invoke");
                            if (invoke2 == null || (containingClass = invoke2.getContainingClass()) == null || PhpLangUtil.isObject(containingClass)) continue;
                            result.add(invoke2);
                        }
                    }
                }
            }
        }
        Collection collection = PhpReferenceImpl.extendedResolve2(this, result);
        if (collection == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public String getSignature() {
        PhpCallbackReferenceBase.PhpClassMemberCallbackReference callbackReference;
        String name = this.getName();
        if (StringUtil.isNotEmpty((String)name)) {
            String sign = PhpTypeSignatureKey.FUNCTION.sign((CharSequence)this.getFQN());
            if (this.getImmediateNamespaceName().isEmpty() && !"\\".equals(this.getNamespaceName())) {
                String string = PhpPotentialGlobalEntryTP.TYPE_KEY.sign((CharSequence)sign);
                if (string == null) {
                    FunctionReferenceImpl.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = sign;
            if (string == null) {
                FunctionReferenceImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        PhpPsiElement array = this.getFirstPsiChild();
        if (array instanceof ArrayCreationExpression && (callbackReference = PhpReferenceContributor.getCallbackRefFromArray((ArrayCreationExpression)array)) != null) {
            return FunctionReferenceImpl.getSignature(callbackReference.getClassRef(), callbackReference.getValue());
        }
        PhpReference reference = FunctionReferenceImpl.getReference(FunctionReferenceImpl.unparenthesize(this.getFirstPsiChild()));
        if (reference != null) {
            return FunctionReferenceImpl.getSignature((PsiElement)reference, "__invoke");
        }
        return "";
    }

    @NotNull
    private static String getSignature(PsiElement classReference, String methodName) {
        StringBuilder signature = new StringBuilder();
        for (String type : new PhpType().add(classReference).getTypes()) {
            if (PhpType.isNotExtendablePrimitiveType((String)type)) continue;
            if (signature.length() > 0) {
                signature.append("|");
            }
            signature.append(PhpTypeSignatureKey.METHOD.sign((CharSequence)(PhpTypeSignatureKey.CLASS.signIfUnsigned(type) + "." + methodName)));
        }
        String string = signature.toString();
        if (string == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public PhpType resolveLocalType() {
        Collection<? extends PhpNamedElement> targets = this.resolveLocal();
        Collection<PhpNamedElement> targetsWithNonRecursiveCalls = FunctionReferenceImpl.getNonRecursiveTargets(this, targets);
        PhpType res = FunctionReferenceImpl.getTypeFromRecursiveTargets(targets, targetsWithNonRecursiveCalls);
        PhpType phpType = res.add(PhpCodeInsightUtil.getLocalType(this, targetsWithNonRecursiveCalls));
        if (phpType == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @NotNull
    public static PhpType getTypeFromRecursiveTargets(Collection<? extends PhpNamedElement> targets, Collection<PhpNamedElement> targetsWithNonRecursiveCalls) {
        PhpType res = new PhpType();
        targets.stream().filter(t -> !targetsWithNonRecursiveCalls.contains(t)).map(t -> new PhpType().add(t.getDeclaredType()).add(t.getDocType())).forEach(arg_0 -> ((PhpType)res).add(arg_0));
        PhpType phpType = res;
        if (phpType == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    @NotNull
    public static Collection<PhpNamedElement> getNonRecursiveTargets(FunctionReference reference, Collection<? extends PhpNamedElement> targets) {
        HashSet<PhpNamedElement> targetsWithNonRecursiveCalls = new HashSet<PhpNamedElement>();
        for (PhpNamedElement phpNamedElement : targets) {
            if (phpNamedElement instanceof Function && PhpLangUtil.equalsFunctionNames(reference.getName(), phpNamedElement.getName()) && PsiTreeUtil.isAncestor((PsiElement)phpNamedElement, (PsiElement)reference, (boolean)false)) continue;
            targetsWithNonRecursiveCalls.add(phpNamedElement);
        }
        HashSet<PhpNamedElement> hashSet = targetsWithNonRecursiveCalls;
        if (hashSet == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        THashSet result = new THashSet();
        String name = this.getName();
        if (StringUtil.isEmpty((String)name)) {
            PhpPsiElement functionNameIdentifierElement = FunctionReferenceImpl.unparenthesize(this.getFirstPsiChild());
            PhpReference reference = FunctionReferenceImpl.getReference(functionNameIdentifierElement);
            if (reference != null) {
                if (reference instanceof Variable) {
                    FunctionReferenceImpl.addAssignedClosures((Variable)reference, (Set<? super PhpNamedElement>)result);
                }
                this.addResolvedInvokeMethods(reference, (Set<PhpNamedElement>)result);
            } else if (PhpPsiUtil.isOfType((PsiElement)functionNameIdentifierElement, PhpElementTypes.CLOSURE)) {
                result.add((PhpNamedElement)functionNameIdentifierElement.getFirstPsiChild());
            }
            THashSet tHashSet = result;
            if (tHashSet == null) {
                FunctionReferenceImpl.$$$reportNull$$$0(9);
            }
            return tHashSet;
        }
        String immediateNS = this.getImmediateNamespaceName();
        boolean skipUses = immediateNS.length() > 0 && immediateNS.charAt(0) == '\\' || PhpPsiUtil.getParentByCondition((PsiElement)this, false, (Condition<? super PsiElement>)PhpUse.INSTANCEOF) != null && PhpPsiUtil.getParentByCondition((PsiElement)this, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) == null;
        PsiFile file = this.getContainingFile();
        if (file instanceof PhpFile) {
            MultiMap map = ((PhpFile)file).getTopLevelDefs();
            String fqn = this.getNamespaceName() + name;
            Collection its = map.get((Object)fqn);
            if (immediateNS.isEmpty() && its.isEmpty()) {
                its = map.get((Object)("\\" + name));
            }
            for (PhpNamedElement it : its) {
                if (!(it instanceof Function) && (!(it instanceof PhpUse) || skipUses || !PhpUseImpl.isOfFunction((PhpUse)it) || !immediateNS.isEmpty())) continue;
                result.add(it);
            }
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(10);
        }
        return tHashSet;
    }

    private void addResolvedInvokeMethods(PhpReference reference, Set<PhpNamedElement> result) {
        PsiFile file = this.getContainingFile();
        if (file instanceof PhpFile) {
            MultiMap definitions = ((PhpFile)file).getTopLevelDefs();
            for (String type : reference.resolveLocalType().getTypes()) {
                for (PhpNamedElement phpClass : definitions.get((Object)type)) {
                    Method invoke2;
                    if (!(phpClass instanceof PhpClass) || (invoke2 = ((PhpClass)phpClass).findOwnMethodByName((CharSequence)"__invoke")) == null) continue;
                    result.add((PhpNamedElement)invoke2);
                }
            }
        }
    }

    public static void addAssignedClosures(@NotNull Variable reference, Set<? super PhpNamedElement> result) {
        if (reference == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(11);
        }
        FunctionReferenceImpl.addAssignedClosures(reference, result, PhpPsiUtil.getScopeHolder((PsiElement)reference));
    }

    @Nullable
    public static PhpNamedElement getAssignedClosure(PsiElement variable) {
        AssignmentExpression ae = (AssignmentExpression)PhpPsiUtil.getParentByCondition(variable, true, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        return ae != null ? FunctionReferenceImpl.getAssignedClosure(variable, ae) : null;
    }

    @Nullable
    private static PhpNamedElement getAssignedClosure(PsiElement variable, @NotNull AssignmentExpression assignmentExpression) {
        PhpPsiElement value;
        if (assignmentExpression == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(12);
        }
        if (assignmentExpression.getVariable() == variable && PhpPsiUtil.isOfType((PsiElement)(value = assignmentExpression.getValue()), PhpElementTypes.CLOSURE)) {
            return (PhpNamedElement)value.getFirstPsiChild();
        }
        return null;
    }

    private static void addAssignedClosures(Variable reference, final Set<? super PhpNamedElement> result, @Nullable PhpScopeHolder scope) {
        Function function;
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstructionInScopeHolder(scope, (PhpPsiElement)reference, PhpAccessVariableInstruction.class);
        final Ref processedAssignment = new Ref((Object)Boolean.FALSE);
        final String variableName = reference.getName();
        if (instruction != null) {
            PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    AssignmentExpression ae;
                    if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName) && instruction.getAccess().isWrite() && (ae = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)instruction.getAnchor(), true, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null) {
                        PhpNamedElement closure = FunctionReferenceImpl.getAssignedClosure((PsiElement)instruction.getAnchor(), ae);
                        if (closure != null) {
                            result.add(closure);
                        }
                        processedAssignment.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }
            });
        }
        if (!((Boolean)processedAssignment.get()).booleanValue() && (function = (Function)ObjectUtils.tryCast((Object)scope, Function.class)) != null && function.isClosure()) {
            PhpScopeHolder outerScope = (PhpScopeHolder)PhpPsiUtil.getParentByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
            boolean shortArrow = FunctionImpl.isShortArrowFunction(function);
            Variable usedVariable = (Variable)ContainerUtil.find(PhpControlFlowBuilder.getUsedVariables(function, outerScope), v -> (shortArrow || v != reference) && PhpLangUtil.equalsVariableNames(v.getName(), variableName));
            if (usedVariable != null) {
                FunctionReferenceImpl.addAssignedClosures(usedVariable, result, outerScope);
            }
        }
    }

    @Nullable
    private static PhpReference getReference(PhpPsiElement element) {
        if (element instanceof NewExpression) {
            return ((NewExpression)element).getClassReference();
        }
        return (PhpReference)ObjectUtils.tryCast((Object)element, PhpReference.class);
    }

    private static PhpPsiElement unparenthesize(PhpPsiElement element) {
        if (element instanceof ParenthesizedExpression) {
            return ((ParenthesizedExpression)element).extract();
        }
        return element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(13);
        }
        if (element instanceof Function || element instanceof PhpUse) {
            ResolveResult[] results;
            if (element instanceof Function && PhpLangUtil.equalsFunctionNames(this.getFQN(), ((Function)element).getFQN())) {
                return true;
            }
            for (ResolveResult result : results = this.multiResolve(false)) {
                if (!result.isValidResult() || result.getElement() != element) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getFQN() {
        Collection<? extends PhpNamedElement> elements = this.resolveLocal();
        if (elements.size() == 1) {
            return ((PhpNamedElement)ContainerUtil.getFirstItem(elements)).getFQN();
        }
        return super.getFQN();
    }

    @Nullable
    public static Function resolveFunction(PhpReference reference) {
        return StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FunctionReferenceImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FunctionReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromRecursiveTargets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonRecursiveTargets";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAssignedClosures";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedClosure";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

