/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpScope;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpScopeImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.inspections.type.PhpMissingReturnTypeInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpAvailableInLanguageLevelRangeElement;
import com.jetbrains.php.lang.psi.stubs.PhpDeprecationInfoOwnerStub;
import com.jetbrains.php.lang.psi.stubs.PhpFunctionStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionImpl
extends PhpNamedElementImpl<PhpNamedStub>
implements Function,
StubBasedPsiElement<NamedStub>,
PhpDeprecationAttributeOwner,
PhpAvailableInLanguageLevelRangeElement {
    private static final Predicate<String> NOT_PLURAL_OR_ARRAY = t -> !PhpType.isPluralType((String)t) && !PhpType.isArray((String)t);
    public static final String AVAILABLE_IN_LANGUAGE_LEVEL_RANGE_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\Internal\\PhpStormStubsElementAvailable";
    private PhpScope myScope;

    public FunctionImpl(ASTNode node) {
        super(node);
    }

    protected FunctionImpl(PhpNamedStub stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            FunctionImpl.$$$reportNull$$$0(0);
        }
        super(stub, nodeType);
    }

    @Override
    public PhpDocComment getDocComment() {
        PhpDocComment comment = null;
        if (this.isClosure()) {
            PsiElement parent = this.getParent();
            if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE) && (comment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)parent)) == null && ((parent = parent.getParent()) instanceof AssignmentExpression || parent instanceof PhpReturn || parent instanceof ParameterList && ((ParameterList)parent).getParameter(0) == this.getParent()) && (comment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)parent)) == null && (parent = parent.getParent()) instanceof Statement) {
                comment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)((Statement)parent));
            }
            if (comment != null) {
                comment.putUserData(PhpDocComment.OWNER_KEY, (Object)this);
            }
            return comment;
        }
        return super.getDocComment();
    }

    public FunctionImpl(PhpFunctionStub stub) {
        super(stub, PhpStubElementTypes.FUNCTION);
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getFunctionPresentation(this);
    }

    public Parameter @NotNull [] getParameters() {
        if (this.getGreenStub() != null) {
            return this.getStubParameters();
        }
        ParameterList element = this.getParameterList();
        if (element == null) {
            if (Parameter.EMPTY_ARRAY == null) {
                FunctionImpl.$$$reportNull$$$0(1);
            }
            return Parameter.EMPTY_ARRAY;
        }
        List<Parameter> childrenOfType = PhpPsiUtil.getChildren((PsiElement)element, (Condition<? super PsiElement>)Parameter.INSTANCEOF);
        Parameter[] parameterArray = childrenOfType.isEmpty() ? Parameter.EMPTY_ARRAY : childrenOfType.toArray(Parameter.EMPTY_ARRAY);
        if (parameterArray == null) {
            FunctionImpl.$$$reportNull$$$0(2);
        }
        return parameterArray;
    }

    private Parameter @NotNull [] getStubParameters() {
        Parameter[] parameterArray = (Parameter[])this.getStubOrPsiChildren(PhpStubElementTypes.PARAMETER, Parameter.ARRAY_FACTORY);
        if (parameterArray == null) {
            FunctionImpl.$$$reportNull$$$0(3);
        }
        return parameterArray;
    }

    private ParameterList getParameterList() {
        return (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
    }

    @Nullable
    public Parameter getParameter(int index) {
        if (index < 0) {
            return null;
        }
        if (this.getGreenStub() != null) {
            Parameter[] parameters = this.getStubParameters();
            return index < parameters.length ? parameters[index] : null;
        }
        return PhpPsiUtil.getNthChildOfClass((PsiElement)this.getParameterList(), index, Parameter.class);
    }

    public boolean hasRefParams() {
        Parameter parameter;
        Parameter[] parameters;
        boolean hasRefParams = false;
        Parameter[] parameterArray = parameters = this.getParameters();
        int n = parameterArray.length;
        for (int i = 0; i < n && !(hasRefParams = (parameter = parameterArray[i]).isPassByRef()); ++i) {
        }
        return hasRefParams;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FunctionImpl.$$$reportNull$$$0(4);
        }
        if ((nameNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            ASTNode node = constantReference.getNameNode();
            assert (node != null);
            nameNode.getTreeParent().replaceChild(nameNode, node);
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            FunctionImpl.$$$reportNull$$$0(5);
        }
        phpElementVisitor.visitPhpFunction((Function)this);
    }

    @Override
    public Icon getIcon() {
        return PhpIcons.FUNCTION;
    }

    public boolean isClosure() {
        return this.getName().length() == 0;
    }

    protected boolean isReturningByReferenceFromAST() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null && PhpPsiUtil.findPrevSiblingOfAnyType(nameNode.getPsi(), PhpTokenTypes.opBIT_AND) != null;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getFQN() {
        String string = this.getNamespaceName() + this.getName();
        if (string == null) {
            FunctionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public PhpType getType() {
        if (ContainerUtil.exists((Object[])this.getParameters(), p -> !p.getAttributes("\\JetBrains\\PhpStorm\\Internal\\ReturnTypeContract").isEmpty())) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PhpType typeFromLanguage = ParameterImpl.getTypeFromLanguageMap(this);
        PhpType phpType = typeFromLanguage != null ? typeFromLanguage : super.getType();
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    @NotNull
    public PhpType getLocalType(boolean interactive) {
        PhpType type = this.getLocalTypeInner(interactive);
        PhpType phpType = this.stubFunctionWithMetaDirective() ? type.filterOut(t -> PhpType.isArray((String)t) || PhpType.isMixedType((String)t)) : type;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    @NotNull
    private PhpType getLocalTypeInner(boolean interactive) {
        PhpType onlyArrayPluralInferredType;
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getType();
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(10);
            }
            return phpType;
        }
        PhpType type = new PhpType();
        PhpType docType = !interactive ? this.getDocType() : PhpType.EMPTY;
        type.add(docType);
        PhpType declaredType = this.getDeclaredType();
        boolean hasPluralDocType = docType.getTypes().stream().anyMatch(PhpType::isPluralType);
        boolean declaredTypeIsArray = declaredType.filterNull().equals((Object)PhpType.ARRAY);
        if (!declaredTypeIsArray || !hasPluralDocType) {
            type.add(declaredType);
        } else if (declaredType.isNullable()) {
            type.add(PhpType.NULL);
        }
        type = this.computeDeclaredType(type);
        if (!declaredType.isEmpty() && !declaredTypeIsArray) {
            PhpType phpType = type;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        PhpType inferredType = this.getInferredType();
        if (type.isEmpty()) {
            PhpType phpType = inferredType;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(12);
            }
            return phpType;
        }
        if (declaredTypeIsArray && !(onlyArrayPluralInferredType = inferredType.filterOut(NOT_PLURAL_OR_ARRAY)).isEmpty()) {
            inferredType = onlyArrayPluralInferredType;
            type = type.filter(PhpType.ARRAY);
        }
        inferredType.getTypes().stream().filter(s -> s != null && !"\\void".equals(s) && !PhpType.isMixedType((String)s) && !PhpType.isUnresolved((String)s)).filter(s -> !hasPluralDocType || !"\\array".equals(s)).forEach(arg_0 -> ((PhpType)type).add(arg_0));
        PhpType phpType = type;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(13);
        }
        return phpType;
    }

    @NotNull
    protected PhpType computeDeclaredType(PhpType typeFromDeclaration) {
        PhpType phpType = typeFromDeclaration;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    @NotNull
    public PhpType getDeclaredType() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getDeclaredType();
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(15);
            }
            return phpType;
        }
        PhpReturnType returnTypeElement = this.getTypeDeclaration();
        if (returnTypeElement != null) {
            PhpType phpType = returnTypeElement.getType();
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(16);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(17);
        }
        return phpType;
    }

    @NotNull
    public PhpType getDocType() {
        PhpDocComment docComment = this.getDocComment();
        if (docComment != null) {
            PhpDocReturnTag returnTag = docComment.getReturnTag();
            PhpType phpType = new PhpType().add((PsiElement)returnTag);
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(18);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(19);
        }
        return phpType;
    }

    private boolean stubFunctionWithMetaDirective() {
        PhpDocComment comment = this.getDocComment();
        return comment != null && comment.getTagElementsByName("@meta").length > 0;
    }

    @NotNull
    public PhpType getInferredType() {
        PsiElement argument;
        final PhpType type = new PhpType();
        if (this instanceof Method && ((Method)this).isAbstract()) {
            PhpType phpType = type;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(20);
            }
            return phpType;
        }
        if (this.isClosure() && FunctionImpl.isShortArrowFunction(this) && (argument = FunctionImpl.getShortArrowFunctionArgument(this)) != null) {
            type.add(FunctionImpl.getType(argument));
            PhpType phpType = type;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(21);
            }
            return phpType;
        }
        final int[] returnCount = new int[]{0};
        final Ref hasEmptyType = new Ref((Object)false);
        PhpInstructionProcessor processor = new PhpInstructionProcessor(){

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                returnCount[0] = returnCount[0] + 1;
                PsiElement argument = instruction.getArgument();
                if (!FunctionImpl.this.isSelfReferencedFunction(argument)) {
                    PhpType phpType = FunctionImpl.getType(argument);
                    if (phpType.isEmpty()) {
                        hasEmptyType.set((Object)true);
                    }
                    type.add(phpType);
                }
                return super.processReturnInstruction(instruction);
            }

            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                returnCount[0] = returnCount[0] + 1;
                PsiElement argument = instruction.getArgument();
                if (argument != null) {
                    type.add(argument.getParent());
                }
                type.add("\\Generator");
                return super.processYieldInstruction(instruction);
            }
        };
        PhpControlFlowUtil.processFlow(this.getControlFlow(), processor);
        if (returnCount[0] == 0 && type.isEmpty()) {
            type.add(PhpType.VOID);
        } else if (type.isEmpty() || ((Boolean)hasEmptyType.get()).booleanValue()) {
            type.add(PhpType.MIXED);
        }
        PhpType phpType = type;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(22);
        }
        return phpType;
    }

    private boolean isSelfReferencedFunction(PsiElement argument) {
        if (argument instanceof FunctionReference) {
            Collection elements = ((FunctionReference)argument).resolveLocal();
            return ContainerUtil.getOnlyItem((Collection)elements) == this;
        }
        return false;
    }

    @Nullable
    public PhpReturnType getReturnType() {
        return (PhpReturnType)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpReturnType.INSTANCEOF);
    }

    public PhpReturnType getTypeDeclaration() {
        return this.getReturnType();
    }

    public boolean updateType(@NotNull PhpType type) {
        if (type == null) {
            FunctionImpl.$$$reportNull$$$0(23);
        }
        if (super.updateType(type)) {
            return true;
        }
        PhpChangeSignatureProcessor.addReturnType((Function)this, PhpMissingReturnTypeInspection.createTypeHint((PhpScopeHolder)this, type));
        return true;
    }

    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        Collection<PhpAttribute> collection = FunctionImpl.getAttributesStubAware(this);
        if (collection == null) {
            FunctionImpl.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @Nullable
    public PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfo() {
        return FunctionImpl.getDeprecationInfoFromAttribute((PhpAttributesOwner)this);
    }

    @Override
    @Nullable
    public String getAvailableInLanguageLevelFrom() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub instanceof PhpAvailableInLanguageLevelRangeElement) {
            return ((PhpAvailableInLanguageLevelRangeElement)stub).getAvailableInLanguageLevelFrom();
        }
        return this.getAvailableInLanguageLevelFromAstBased();
    }

    @Nullable
    private String getAvailableInLanguageLevelFromAstBased() {
        return FunctionImpl.findParameterByNameOrIndex(this.getAvailableInLanguageLevelRangeParameter(), "from", 0);
    }

    @Nullable
    private String getAvailableInLanguageLevelToAstBased() {
        return FunctionImpl.findParameterByNameOrIndex(this.getAvailableInLanguageLevelRangeParameter(), "to", 1);
    }

    private PsiElement[] getAvailableInLanguageLevelRangeParameter() {
        PhpAttribute item = (PhpAttribute)ContainerUtil.getFirstItem((Collection)this.getAttributes(AVAILABLE_IN_LANGUAGE_LEVEL_RANGE_ATTRIBUTE_FQN));
        if (item == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        return item.getParameters();
    }

    @Override
    @Nullable
    public String getAvailableInLanguageLevelTo() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub instanceof PhpAvailableInLanguageLevelRangeElement) {
            return ((PhpAvailableInLanguageLevelRangeElement)stub).getAvailableInLanguageLevelTo();
        }
        return this.getAvailableInLanguageLevelToAstBased();
    }

    @Nullable
    public static PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfoFromAttribute(@NotNull PhpAttributesOwner attributeOwner) {
        StubElement stub;
        if (attributeOwner == null) {
            FunctionImpl.$$$reportNull$$$0(25);
        }
        if (attributeOwner instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)attributeOwner).getGreenStub()) instanceof PhpDeprecationInfoOwnerStub) {
            return ((PhpDeprecationInfoOwnerStub)stub).getDeprecationInfo();
        }
        PhpAttribute attribute = (PhpAttribute)ContainerUtil.getFirstItem((Collection)attributeOwner.getAttributes("\\JetBrains\\PhpStorm\\Deprecated"));
        if (attribute == null) {
            return null;
        }
        PsiElement[] parameters = attribute.getParameters();
        String reason = FunctionImpl.findParameterByNameOrIndex(parameters, "reason", 0);
        PsiElement replacementDeprecationAttributeParameter = FunctionImpl.getReplacementDeprecationAttributeParameter(parameters);
        String replaceWith = replacementDeprecationAttributeParameter instanceof StringLiteralExpression ? ((StringLiteralExpression)replacementDeprecationAttributeParameter).getContents() : null;
        String version = FunctionImpl.findParameterByNameOrIndex(parameters, "since", 2);
        return new PhpDeprecationAttributeOwner.PhpDeprecationInfo(version, reason, replaceWith);
    }

    public static PsiElement getReplacementDeprecationAttributeParameter(PsiElement[] parameters) {
        return FunctionImpl.getElement(parameters, "replacement", 1);
    }

    private static String findParameterByNameOrIndex(PsiElement[] parameters, String name, int index) {
        PsiElement s = FunctionImpl.getElement(parameters, name, index);
        return s instanceof StringLiteralExpression ? ((StringLiteralExpression)s).getContents() : null;
    }

    @Nullable
    private static PsiElement getElement(PsiElement[] parameters, String name, int index) {
        PsiElement byName = (PsiElement)ContainerUtil.find((Object[])parameters, p -> {
            PsiElement identifier = ParameterListImpl.getNameIdentifier(p);
            return identifier != null && identifier.getText().equals(name);
        });
        return byName != null ? byName : (index < parameters.length && ParameterListImpl.getNameIdentifier(parameters[index]) == null ? parameters[index] : null);
    }

    @NotNull
    private static PhpType getType(@Nullable PsiElement value) {
        if (value != null) {
            if (PhpLangUtil.isThisReference(value)) {
                PhpClass aClass = PhpClassImpl.getContainingClass((PhpPsiElement)value);
                if (aClass != null) {
                    PhpType phpType = new PhpType().add(PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign((CharSequence)aClass.getFQN()));
                    if (phpType == null) {
                        FunctionImpl.$$$reportNull$$$0(26);
                    }
                    return phpType;
                }
                PhpType phpType = PhpType.EMPTY;
                if (phpType == null) {
                    FunctionImpl.$$$reportNull$$$0(27);
                }
                return phpType;
            }
            PhpType phpType = new PhpType().add(value);
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(28);
            }
            return phpType;
        }
        PhpType phpType = PhpType.VOID;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(29);
        }
        return phpType;
    }

    public Collection<String> getDocExceptions() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub instanceof PhpFunctionStub) {
            return ((PhpFunctionStub)stub).getDocExceptions();
        }
        return FunctionImpl.getDocExceptions(this);
    }

    public boolean isReturningByReference() {
        PhpFunctionStub stub = (PhpFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isReturningByReference();
        }
        return this.isReturningByReferenceFromAST();
    }

    @NotNull
    protected static Collection<String> getDocExceptions(@NotNull Function function) {
        PhpDocComment docComment;
        if (function == null) {
            FunctionImpl.$$$reportNull$$$0(30);
        }
        if ((docComment = function.getDocComment()) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                FunctionImpl.$$$reportNull$$$0(31);
            }
            return set;
        }
        Collection collection = Arrays.stream(docComment.getExceptionClasses()).flatMap(type -> type.getTypes().stream()).collect(PhpStringUtil.toCaseInsensitiveSet());
        if (collection == null) {
            FunctionImpl.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @NotNull
    public PhpControlFlow getControlFlow() {
        PhpControlFlow phpControlFlow = this.getScope().getControlFlow();
        if (phpControlFlow == null) {
            FunctionImpl.$$$reportNull$$$0(33);
        }
        return phpControlFlow;
    }

    @NotNull
    public PhpScope getScope() {
        if (this.myScope == null) {
            this.myScope = new PhpScopeImpl((PhpScopeHolder)this);
        }
        PhpScope phpScope = this.myScope;
        if (phpScope == null) {
            FunctionImpl.$$$reportNull$$$0(34);
        }
        return phpScope;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        if (this.myScope != null) {
            this.myScope.clear();
        }
    }

    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        Set<CharSequence> set = Collections.emptySet();
        if (set == null) {
            FunctionImpl.$$$reportNull$$$0(35);
        }
        return set;
    }

    @NotNull
    public static PhpType getDeclaredType(@NotNull Function function) {
        if (function == null) {
            FunctionImpl.$$$reportNull$$$0(36);
        }
        PhpType phpType = new PhpType().add(function.getDeclaredType()).add(function.getDocType());
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(37);
        }
        return phpType;
    }

    public static boolean isShortArrowFunction(@Nullable Function function) {
        return function != null && function.getNode().findChildByType(PhpTokenTypes.kwFN) != null;
    }

    @Nullable
    public static PsiElement getShortArrowFunctionArgument(@NotNull Function function) {
        ASTNode hash;
        if (function == null) {
            FunctionImpl.$$$reportNull$$$0(38);
        }
        if ((hash = function.getNode().findChildByType(PhpTokenTypes.opHASH_ARRAY)) == null) {
            return null;
        }
        return PhpPsiUtil.getNextSiblingIgnoreWhitespace(hash.getPsi(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FunctionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeOwner";
                break;
            }
            case 30: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FunctionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 7: 
            case 8: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalTypeInner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDeclaredType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocExceptions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecationInfoFromAttribute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDocExceptions";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getShortArrowFunctionArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

