/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldReferenceImpl
extends MemberReferenceImpl
implements FieldReference {
    private static final TokenSet NN = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER, PhpTokenTypes.kwCLASS});

    public FieldReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        Collection<? extends PhpNamedElement> elements = super.resolveGlobal(incompleteCode);
        if (!elements.isEmpty()) {
            Collection<? extends PhpNamedElement> collection = elements;
            if (collection == null) {
                FieldReferenceImpl.$$$reportNull$$$0(0);
            }
            return collection;
        }
        PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(this, PhpAccessFieldByVariableInstruction.class);
        PhpExpression classReference = this.getClassReference();
        if (classReference != null && instruction != null && instruction.getAccess().isRead()) {
            ArrayList fakeElements = new ArrayList();
            Ref canBeDefined = new Ref();
            Ref canBeUndefined = new Ref();
            PhpUndefinedFieldInspection.processReachability(classReference, this.getName(), (PhpInstruction)instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, f -> fakeElements.add(new DynamicallyDeclaredField((FieldReference)f)));
            if (canBeDefined.get() == Boolean.TRUE) {
                ArrayList arrayList = fakeElements;
                if (arrayList == null) {
                    FieldReferenceImpl.$$$reportNull$$$0(1);
                }
                return arrayList;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            FieldReferenceImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = FieldReferenceImpl.isClassNameLiteral(this) ? PhpType.STRING : super.resolveLocalType();
        if (phpType == null) {
            FieldReferenceImpl.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    public static boolean isClassNameLiteral(@NotNull FieldReference reference) {
        if (reference == null) {
            FieldReferenceImpl.$$$reportNull$$$0(4);
        }
        return PsiUtilCore.getElementType((ASTNode)reference.getNameNode()) == PhpTokenTypes.kwCLASS;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            FieldReferenceImpl.$$$reportNull$$$0(5);
        }
        phpElementVisitor.visitPhpFieldReference((FieldReference)this);
    }

    @Override
    public ASTNode getNameNode() {
        PsiElement lastChild = this.getLastChild();
        if (lastChild instanceof Variable && (!this.isStatic() || lastChild.getPrevSibling().getNode().getElementType().equals(PhpTokenTypes.DOLLAR))) {
            return null;
        }
        if (lastChild instanceof LeafPsiElement) {
            return NN.contains(lastChild.getNode().getElementType()) ? lastChild.getNode() : null;
        }
        ASTNode node = lastChild.getNode();
        ASTNode out = node.findChildByType(NN);
        if (out != null) {
            return out;
        }
        return TreeUtil.findChildBackward((ASTNode)node, PhpStubElementTypes.VARIABLE);
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name != null && name.length() > 0 && name.charAt(0) == '$' ? name.substring(1) : name;
    }

    @Override
    public CharSequence getNameCS() {
        CharSequence name = super.getNameCS();
        return name != null && name.length() > 0 && name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name;
    }

    public boolean isConstant() {
        CharSequence name = super.getNameCS();
        return name != null && (name.length() == 0 || name.charAt(0) != '$');
    }

    public Set<PhpNamedElement> resolveMember(@NotNull PhpClass klass, boolean localOnly) {
        if (klass == null) {
            FieldReferenceImpl.$$$reportNull$$$0(6);
        }
        return FieldReferenceImpl.resolveMemberImpl(this, klass, localOnly);
    }

    public static Set<PhpNamedElement> resolveMemberImpl(MemberReference reference, @NotNull PhpClass klass, boolean localOnly) {
        if (klass == null) {
            FieldReferenceImpl.$$$reportNull$$$0(7);
        }
        boolean isStatic = !reference.getReferenceType().isDynamic();
        boolean lookForConstant = (reference instanceof ClassConstantReference || reference instanceof FieldReference && ((FieldReference)reference).isConstant()) && isStatic;
        Field field = !localOnly ? klass.findFieldByName(reference.getNameCS(), lookForConstant) : klass.findOwnFieldByName(reference.getNameCS(), lookForConstant);
        if (field != null) {
            if (field.isConstant() != lookForConstant) {
                return Collections.emptySet();
            }
            if (field.getModifier().isStatic() != isStatic) {
                return Collections.emptySet();
            }
            return Collections.singleton(field);
        }
        return Collections.emptySet();
    }

    @Override
    public PsiElement handleElementRename(@NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FieldReferenceImpl.$$$reportNull$$$0(8);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ASTNode node;
            ASTNode aSTNode = node = nameNode.getElementType() == PhpTokenTypes.IDENTIFIER ? PhpPsiElementFactory.createFieldReferenceUsingThis(this.getProject(), name).getNameNode() : PhpPsiElementFactory.createVariable(this.getProject(), name, true).getNameNode();
            assert (node != null);
            nameNode.getTreeParent().replaceChild(nameNode, node);
        }
        return this;
    }

    public boolean isWriteAccess() {
        return this.isWriteAccess(true);
    }

    public boolean isWriteAccess(boolean global) {
        FieldReferenceImpl that = this;
        PsiElement parent = this.getParent();
        while (parent instanceof ArrayAccessExpression) {
            that = parent;
            parent = parent.getParent();
        }
        if (VariableImpl.inMultiAssignment(parent)) {
            return true;
        }
        if (parent instanceof AssignmentExpression) {
            return ((AssignmentExpression)parent).getVariable() == that;
        }
        if (parent instanceof UnaryExpression && (PhpPsiUtil.isOfType(parent, PhpElementTypes.INFIX_WRITE_EXPRESSION) || PhpPsiUtil.isOfType(parent, PhpElementTypes.POSTFIX_EXPRESSION))) {
            return true;
        }
        return PhpCodeInsightUtil.isPassByRefParameter((PsiElement)that, global);
    }

    @Override
    protected PhpTypeSignatureKey getTypeSignatureKey() {
        return PhpTypeSignatureKey.FIELD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FieldReferenceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FieldReferenceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isClassNameLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class DynamicallyDeclaredField
    extends RenameableFakePsiElement
    implements PhpNamedElement {
        private final FieldReference myReference;

        private DynamicallyDeclaredField(FieldReference reference) {
            super(reference.getParent());
            this.myReference = reference;
        }

        @Nullable
        public ASTNode getNameNode() {
            return this.myReference.getNameNode();
        }

        @NotNull
        @NlsSafe
        public String getName() {
            String string = StringUtil.notNullize((String)this.myReference.getName());
            if (string == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public CharSequence getNameCS() {
            String string = this.getName();
            if (string == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public PhpDocComment getDocComment() {
            return null;
        }

        public void processDocs(Processor<PhpDocComment> processor) {
        }

        @Nullable
        public String getTypeName() {
            return PhpBundle.message("dynamically.declared.field", new Object[0]);
        }

        public Icon getIcon() {
            return PhpIcons.FIELD;
        }

        @NotNull
        @NlsSafe
        public String getFQN() {
            String string = StringUtil.notNullize((String)this.myReference.getFQN());
            if (string == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        @NlsSafe
        public String getNamespaceName() {
            String string = this.myReference.getNamespaceName();
            if (string == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isDeprecated() {
            return false;
        }

        public boolean isInternal() {
            return false;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            ASTNode node = this.myReference.getNameNode();
            return node != null ? node.getPsi() : null;
        }

        @NotNull
        public PhpType getType() {
            PhpType phpType = this.myReference.getType();
            if (phpType == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(4);
            }
            return phpType;
        }

        @Nullable
        public PhpPsiElement getFirstPsiChild() {
            return this.myReference.getFirstPsiChild();
        }

        @Nullable
        public PhpPsiElement getNextPsiSibling() {
            return this.myReference.getNextPsiSibling();
        }

        @Nullable
        public PhpPsiElement getPrevPsiSibling() {
            return this.myReference.getPrevPsiSibling();
        }

        public int getTextOffset() {
            PsiElement identifier = this.getNameIdentifier();
            return identifier != null ? identifier.getTextRange().getStartOffset() : this.myReference.getTextOffset();
        }

        @Nullable
        public String getLocationString() {
            return PhpPresentationUtil.getPresentablePathForFile(this.getContainingFile().getVirtualFile(), this.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/lang/psi/elements/impl/FieldReferenceImpl$DynamicallyDeclaredField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameCS";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFQN";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

