/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassMemberIconProvider;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.ConstantImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassFieldsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpFieldStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldImpl
extends PhpNamedElementImpl<PhpFieldStub>
implements Field,
StubBasedPsiElement<PhpFieldStub>,
PhpDeprecationAttributeOwner {
    private static final TokenSet NN = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER}), PhpTokenTypes.tsKEYWORDS});

    public FieldImpl(ASTNode node) {
        super(node);
    }

    public FieldImpl(PhpFieldStub stub, IStubElementType type) {
        super(stub, type);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            FieldImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpField((Field)this);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpClassMemberIconProvider.getFieldIcon(this);
    }

    @Override
    @Nullable
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getFieldPresentation(this);
    }

    @Override
    @NotNull
    public String getName() {
        String name = super.getName();
        String string = name.charAt(0) == '$' ? name.substring(1) : name;
        if (string == null) {
            FieldImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        CharSequence name = super.getNameCS();
        return name.length() > 0 ? (name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name) : "";
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FieldImpl.$$$reportNull$$$0(2);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ASTNode node;
            ASTNode aSTNode = node = this.isConstant() ? PhpPsiElementFactory.createClassConstantReferenceUsingSelf(this.getProject(), name).getNameNode() : PhpPsiElementFactory.createVariable(this.getProject(), name, true).getNameNode();
            if (node != null) {
                nameNode.getTreeParent().replaceChild(nameNode, node);
            }
        }
        return this;
    }

    @NotNull
    public PhpModifier getModifier() {
        PhpModifier.State state = PhpModifier.State.DYNAMIC;
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        PhpFieldStub fieldStub = (PhpFieldStub)this.getGreenStub();
        if (fieldStub != null) {
            if (fieldStub.isPrivate()) {
                access = PhpModifier.Access.PRIVATE;
            }
            if (fieldStub.isProtected()) {
                access = PhpModifier.Access.PROTECTED;
            }
            if (fieldStub.isStatic()) {
                state = PhpModifier.State.STATIC;
            }
        } else {
            PhpModifierList modifierList;
            PhpClassFieldsList list = this.getParentList();
            PhpModifierList phpModifierList = modifierList = list != null ? list.getModifierList() : null;
            if (modifierList != null) {
                ASTNode[] nodes;
                for (ASTNode node : nodes = modifierList.getNode().getChildren(PhpTokenTypes.tsVARIABLE_MODIFIERS)) {
                    if (node.getElementType() == PhpTokenTypes.kwPRIVATE) {
                        access = PhpModifier.Access.PRIVATE;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwPROTECTED) {
                        access = PhpModifier.Access.PROTECTED;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwPUBLIC || node.getElementType() == PhpTokenTypes.kwVAR) {
                        access = PhpModifier.Access.PUBLIC;
                        continue;
                    }
                    if (node.getElementType() != PhpTokenTypes.kwSTATIC) continue;
                    state = PhpModifier.State.STATIC;
                }
            }
        }
        if (this.isConstant()) {
            state = PhpModifier.State.STATIC;
        }
        PhpModifier phpModifier = PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)state);
        if (phpModifier == null) {
            FieldImpl.$$$reportNull$$$0(3);
        }
        return phpModifier;
    }

    public boolean isConstant() {
        return false;
    }

    @Nullable
    public PsiElement getDefaultValue() {
        return this.getFirstPsiChild();
    }

    @Nullable
    public String getDefaultValuePresentation() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            return ((PhpFieldStub)stub).getDefaultValuePresentation();
        }
        return ConstantImpl.getValuePresentationInternal(this.getDefaultValue());
    }

    @Nullable
    public PhpClassFieldsList getParentList() {
        return (PhpClassFieldsList)ObjectUtils.tryCast((Object)this.getParent(), PhpClassFieldsList.class);
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        PhpClassFieldsList parent = this.getParentList();
        return parent != null ? PhpPsiUtil.getDocCommentFor((PhpPsiElement)parent) : null;
    }

    @Nullable
    public PhpClass getContainingClass() {
        return (PhpClass)this.getStubOrPsiParentOfType(PhpClass.class);
    }

    public boolean isWriteAccess() {
        return true;
    }

    @Override
    @NotNull
    public String getFQN() {
        PhpClass containingClass = this.getContainingClass();
        return containingClass != null ? containingClass.getFQN() + "." + (this.isConstant() ? "" : "$") + this.getName() : "";
    }

    @NotNull
    public PhpType getDeclaredType() {
        PhpFieldStub stub = (PhpFieldStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getDeclaredType();
            if (phpType == null) {
                FieldImpl.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)this, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
        if (typeDeclaration == null || this.isConstant()) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                FieldImpl.$$$reportNull$$$0(5);
            }
            return phpType;
        }
        PhpType type = new PhpType();
        if (typeDeclaration.isNullable()) {
            type.add(PhpType.NULL);
        }
        for (ClassReference typeClassReference : typeDeclaration.getClassReferences()) {
            type.add(typeClassReference.resolveLocalType());
        }
        PhpType phpType = type;
        if (phpType == null) {
            FieldImpl.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        PhpClassFieldsList parent = this.getParentList();
        Collection<PhpAttribute> collection = parent != null ? FieldImpl.getAttributesStubAware((PhpClassFieldsListImpl)parent) : Collections.emptyList();
        if (collection == null) {
            FieldImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Nullable
    public PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfo() {
        return FunctionImpl.getDeprecationInfoFromAttribute((PhpAttributesOwner)this);
    }

    public static Set<? extends PhpNamedElement> collectFieldDeclarations(@NotNull PhpPsiElement point) {
        if (point == null) {
            FieldImpl.$$$reportNull$$$0(8);
        }
        return FieldImpl.getCollectDeclarations(point, false);
    }

    private static Set<? extends PhpNamedElement> getCollectDeclarations(PhpPsiElement point, final boolean constants) {
        PhpClass parent = PhpClassImpl.getContainingClass(point);
        if (parent == null) {
            return Collections.emptySet();
        }
        THashSet fieldSet = new THashSet();
        parent.acceptChildren((PsiElementVisitor)new PhpRecursiveElementVisitor((Set)fieldSet){
            final /* synthetic */ Set val$fieldSet;
            {
                this.val$fieldSet = set;
            }

            public void visitPhpField(Field field) {
                if (constants == field.isConstant()) {
                    this.val$fieldSet.add(field);
                }
            }

            public void visitPhpFunction(Function function) {
            }

            public void visitPhpMethod(Method method) {
            }
        });
        return fieldSet;
    }

    public static Set<? extends PhpNamedElement> collectClassConstDeclarations(@NotNull PhpPsiElement point) {
        if (point == null) {
            FieldImpl.$$$reportNull$$$0(9);
        }
        return FieldImpl.getCollectDeclarations(point, true);
    }

    @NotNull
    public PhpType getDocType() {
        PhpDocComment comment = this.getDocComment();
        PhpDocParamTag varTag = comment != null ? comment.getVarTag() : null;
        PhpType phpType = varTag != null ? varTag.getType() : PhpType.EMPTY;
        if (phpType == null) {
            FieldImpl.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @Nullable
    public PhpFieldType getTypeDeclaration() {
        return (PhpFieldType)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)this, (Condition<? super PsiElement>)((Condition)PhpFieldType.class::isInstance));
    }

    public boolean updateType(@NotNull PhpType type) {
        if (type == null) {
            FieldImpl.$$$reportNull$$$0(11);
        }
        FieldImpl.changeFieldType(this.getProject(), this, type);
        return true;
    }

    private static void changeFieldType(@NotNull Project project, @NotNull Field field, @NotNull PhpType newType) {
        PhpClassFieldsList fieldsList;
        if (project == null) {
            FieldImpl.$$$reportNull$$$0(12);
        }
        if (field == null) {
            FieldImpl.$$$reportNull$$$0(13);
        }
        if (newType == null) {
            FieldImpl.$$$reportNull$$$0(14);
        }
        if ((fieldsList = field.getParentList()) == null || !PhpPsiUtil.isOfType((PsiElement)fieldsList, PhpElementTypes.CLASS_FIELDS)) {
            return;
        }
        String newTypeString = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, newType, (PsiElement)field);
        if (PhpHierarchyChecksInspection.isGroupedDeclarations(fieldsList)) {
            PhpClassFieldsList newFieldsList = FieldImpl.copyListWithSingleField(field, fieldsList);
            FieldImpl.changeFieldType(project, (Field)ContainerUtil.getFirstItem((Collection)newFieldsList.getFields()), newFieldsList, newTypeString);
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
            fieldsList.getParent().addAfter((PsiElement)newFieldsList, (PsiElement)fieldsList);
        } else {
            FieldImpl.changeFieldType(project, field, fieldsList, newTypeString);
        }
    }

    @NotNull
    public static PhpClassFieldsList copyListWithSingleField(@NotNull Field field, PhpClassFieldsList list) {
        if (field == null) {
            FieldImpl.$$$reportNull$$$0(15);
        }
        PhpClassFieldsList newFieldsList = (PhpClassFieldsList)list.copy();
        newFieldsList.getFields().stream().filter(f -> !f.getName().equals(field.getName())).forEach(f -> PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)f, PhpTokenTypes.opCOMMA));
        PhpClassFieldsList phpClassFieldsList = newFieldsList;
        if (phpClassFieldsList == null) {
            FieldImpl.$$$reportNull$$$0(16);
        }
        return phpClassFieldsList;
    }

    private static void changeFieldType(@NotNull Project project, @NotNull Field field, @NotNull PhpClassFieldsList fieldsList, @Nullable String typeString) {
        PhpTypeDeclaration typeDeclaration;
        if (project == null) {
            FieldImpl.$$$reportNull$$$0(17);
        }
        if (field == null) {
            FieldImpl.$$$reportNull$$$0(18);
        }
        if (fieldsList == null) {
            FieldImpl.$$$reportNull$$$0(19);
        }
        if ((typeDeclaration = field.getTypeDeclaration()) != null && typeString == null) {
            typeDeclaration.delete();
        } else if (typeDeclaration != null) {
            typeDeclaration.replace((PsiElement)FieldImpl.createFieldType(project, typeString));
        } else if (typeString != null) {
            fieldsList.addBefore((PsiElement)FieldImpl.createFieldType(project, typeString), (PsiElement)field);
        }
    }

    @NotNull
    private static PhpFieldType createFieldType(@NotNull Project project, @NotNull String type) {
        if (project == null) {
            FieldImpl.$$$reportNull$$$0(20);
        }
        if (type == null) {
            FieldImpl.$$$reportNull$$$0(21);
        }
        PhpFieldType phpFieldType = PhpPsiElementFactory.createPhpPsiFromText(project, PhpFieldType.class, "class A { public " + type + " $a; }");
        if (phpFieldType == null) {
            FieldImpl.$$$reportNull$$$0(22);
        }
        return phpFieldType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FieldImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FieldImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "copyListWithSingleField";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldDeclarations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectClassConstDeclarations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "changeFieldType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyListWithSingleField";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFieldType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

