/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import com.intellij.webcore.formatter.comments.CommentWrapper;
import com.intellij.webcore.formatter.comments.DocCommentLineDataBuilder;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

final class PhpDocPostFormatProcessor
implements PostFormatProcessor {
    PhpDocPostFormatProcessor() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PhpDocPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PhpDocPostFormatProcessor.$$$reportNull$$$0(1);
        }
        if (source.getContainingFile().getFileType() == PhpFileType.INSTANCE && PhpDocPostFormatProcessor.shouldWrapLongComments(settings) && source.isValid()) {
            PsiElement psiElement = new PhpDocVisitor(settings, source, source.getProject()).process();
            if (psiElement == null) {
                PhpDocPostFormatProcessor.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        PsiElement psiElement = source;
        if (psiElement == null) {
            PhpDocPostFormatProcessor.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PhpDocPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (rangeToReformat == null) {
            PhpDocPostFormatProcessor.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            PhpDocPostFormatProcessor.$$$reportNull$$$0(6);
        }
        if (source.getFileType() == PhpFileType.INSTANCE && PhpDocPostFormatProcessor.shouldWrapLongComments(settings) && source.isValid()) {
            TextRange textRange = new PhpDocVisitor(settings, (PsiElement)source, source.getProject()).processText(rangeToReformat);
            if (textRange == null) {
                PhpDocPostFormatProcessor.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            PhpDocPostFormatProcessor.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    private static boolean shouldWrapLongComments(CodeStyleSettings settings) {
        return ((PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class)).PHPDOC_WRAP_LONG_LINES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/codeStyle/PhpDocPostFormatProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/codeStyle/PhpDocPostFormatProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpDocVisitor
    extends PhpElementVisitor {
        private final CodeStyleSettings mySettings;
        private TextRange myOriginalRange;
        private final PsiElement mySource;
        private final Document myDocument;
        private int myDelta;
        private final Project myProject;
        private final int myRightMargin;
        private final boolean myAlignDocComments;
        private final CommonCodeStyleSettings myPhpSettings;

        PhpDocVisitor(@NotNull CodeStyleSettings settings, @NotNull PsiElement source, @NotNull Project project) {
            if (settings == null) {
                PhpDocVisitor.$$$reportNull$$$0(0);
            }
            if (source == null) {
                PhpDocVisitor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                PhpDocVisitor.$$$reportNull$$$0(2);
            }
            this.mySettings = settings;
            this.mySource = source;
            this.myDocument = source.getContainingFile().getViewProvider().getDocument();
            this.myPhpSettings = settings.getCommonSettings((Language)PhpLanguage.INSTANCE);
            this.myRightMargin = this.mySettings.getRightMargin((Language)PhpLanguage.INSTANCE);
            this.myAlignDocComments = ((PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class)).ALIGN_PHPDOC_COMMENTS;
            this.myProject = project;
        }

        PsiElement process() {
            if (this.myDocument == null) {
                return this.mySource;
            }
            this.myOriginalRange = this.mySource.getTextRange();
            this.mySource.accept((PsiElementVisitor)this);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(this.myDocument);
            return this.mySource;
        }

        TextRange processText(@NotNull TextRange rangeToReformat) {
            if (rangeToReformat == null) {
                PhpDocVisitor.$$$reportNull$$$0(3);
            }
            if (this.myDocument == null) {
                return rangeToReformat;
            }
            this.myOriginalRange = rangeToReformat;
            this.mySource.accept((PsiElementVisitor)this);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(this.myDocument);
            return this.myOriginalRange.grown(this.myDelta);
        }

        public void visitPhpFile(PhpFile phpFile) {
            super.visitPhpFile(phpFile);
            phpFile.acceptChildren((PsiElementVisitor)this);
        }

        public void visitPhpNamespace(PhpNamespace namespace) {
            namespace.acceptChildren((PsiElementVisitor)this);
        }

        public void visitPhpClass(PhpClass clazz) {
            clazz.acceptChildren((PsiElementVisitor)this);
        }

        public void visitPhpGroupStatement(GroupStatement groupStatement) {
            groupStatement.acceptChildren((PsiElementVisitor)this);
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpDocVisitor.$$$reportNull$$$0(4);
            }
            if (element instanceof PhpDocComment && this.myOriginalRange.contains(element.getTextRange())) {
                TextRange docRange = element.getTextRange();
                int start = docRange.getStartOffset() + this.myDelta;
                int end = docRange.getEndOffset() + this.myDelta;
                String newDoc = CommentWrapper.wrapCommentLines((CommentLineDataBuilder)new DocCommentLineDataBuilder(element, this.myAlignDocComments, this.myPhpSettings), (int)this.myRightMargin);
                if (newDoc != null) {
                    int newLength = newDoc.length();
                    this.myDelta += newLength - element.getTextLength();
                    this.myDocument.replaceString(start, end, (CharSequence)newDoc);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeToReformat";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/codeStyle/PhpDocPostFormatProcessor$PhpDocVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

