/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocParamTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragmentImpl;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpTypeCodeFragment;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpParameterType;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.util.PhpContractUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPsiElementFactory {
    private static final Logger LOG = Logger.getInstance(PhpPsiElementFactory.class);
    private static final String CANNOT_CREATE_ELEMENT_FROM_TEXT = "cannot create element from text:\n";

    private PhpPsiElementFactory() {
    }

    public static PsiElement createExtendsList(Project project, String fqnList) {
        return PhpPsiElementFactory.createPhpPsiFromText(project, ExtendsList.class, "interface A extends " + fqnList + " {}");
    }

    public static PsiElement createImplementsList(Project project, String fqnList) {
        return PhpPsiElementFactory.createPhpPsiFromText(project, ImplementsList.class, "class A implements " + fqnList + " {}");
    }

    @NotNull
    public static Method createClassEmptyConstructor(@NotNull Project project) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(0);
        }
        return PhpPsiElementFactory.createMethod(project, "public function __construct(){ }");
    }

    @NotNull
    public static ConstantReference createConstantReference(Project p, @NotNull String constantName) {
        if (constantName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(1);
        }
        ConstantReference element = PhpPsiElementFactory.createFromText(p, ConstantReference.class, constantName);
        assert (element != null) : "createConstantReference failed for '" + constantName + "'";
        ConstantReference constantReference = element;
        if (constantReference == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(2);
        }
        return constantReference;
    }

    @NotNull
    public static ClassConstantReference createClassConstantReferenceUsingSelf(Project p, @NotNull String constantName) {
        if (constantName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(3);
        }
        String exprBuilder = "class A{\npublic function f(){\nself::" + constantName + ";\n}\n}";
        ClassConstantReference element = PhpPsiElementFactory.createFromText(p, ClassConstantReference.class, exprBuilder);
        assert (element != null) : "createClassConstantReferenceUsingSelf failed for '" + constantName + "'";
        ClassConstantReference classConstantReference = element;
        if (classConstantReference == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(4);
        }
        return classConstantReference;
    }

    @NotNull
    public static FieldReference createFieldReferenceUsingSelf(Project p, @NotNull String fieldName) {
        if (fieldName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(5);
        }
        String exprBuilder = "class A{\npublic function f(){\nself::$" + fieldName + "\n}}";
        FieldReference element = PhpPsiElementFactory.createFromText(p, FieldReference.class, exprBuilder);
        assert (element != null) : "createFieldReferenceUsingSelf failed for '" + fieldName + "'";
        FieldReference fieldReference = element;
        if (fieldReference == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(6);
        }
        return fieldReference;
    }

    @NotNull
    public static FieldReference createFieldReferenceUsingThis(Project p, @NotNull String fieldName) {
        if (fieldName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(7);
        }
        String exprBuilder = "class A{\npublic function f(){\n$this->" + fieldName + "\n}}";
        FieldReference element = PhpPsiElementFactory.createFromText(p, FieldReference.class, exprBuilder);
        assert (element != null) : "createFieldReferenceUsingThis failed for '" + fieldName + "'";
        FieldReference fieldReference = element;
        if (fieldReference == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(8);
        }
        return fieldReference;
    }

    @NotNull
    public static FieldReference createFieldReference(Project p, @NotNull String objectParam, @NotNull String fieldName) {
        if (objectParam == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(9);
        }
        if (fieldName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(10);
        }
        String exprBuilder = "class A{\npublic function f(){\n$" + objectParam + "->" + fieldName + "\n}}";
        FieldReference element = PhpPsiElementFactory.createFromText(p, FieldReference.class, exprBuilder);
        assert (element != null) : "createFieldReferenceUsingThis failed for '" + fieldName + "'";
        FieldReference fieldReference = element;
        if (fieldReference == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(11);
        }
        return fieldReference;
    }

    @NotNull
    public static Parameter createParameter(Project p, @NotNull String parameterName) {
        if (parameterName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(12);
        }
        return PhpPsiElementFactory.createComplexParameter(p, "$" + parameterName);
    }

    @NotNull
    public static Parameter createComplexParameter(Project p, @NotNull String parameterText) {
        if (parameterText == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(13);
        }
        String builder = "function foo(" + parameterText + "){}";
        return PhpPsiElementFactory.createPhpPsiFromText(p, Parameter.class, builder);
    }

    @NotNull
    public static Variable createVariable(@NotNull Project project, @NotNull String variableName, boolean dollarPrefix) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(14);
        }
        if (variableName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(15);
        }
        LOG.assertTrue(!variableName.startsWith("$"));
        String text = dollarPrefix ? "$" + variableName + ";" : "\"${" + variableName + "}\";";
        return PhpPsiElementFactory.createPhpPsiFromText(project, Variable.class, text);
    }

    @NotNull
    private static PsiFile createDummyFile(Project p, String fileText) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)p).createFileFromText("DUMMY__." + PhpFileType.INSTANCE.getDefaultExtension(), (FileType)PhpFileType.INSTANCE, (CharSequence)("<?php\n" + fileText), System.currentTimeMillis(), false);
        if (psiFile == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(16);
        }
        return psiFile;
    }

    @NotNull
    public static Statement createStatement(@NotNull Project project, @NotNull String statementText) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(17);
        }
        if (statementText == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(18);
        }
        return PhpPsiElementFactory.createFromText(project, Statement.class, statementText, new int[]{0, 2});
    }

    @NotNull
    public static ClassReference createClassReference(@NotNull Project project, @NotNull String qualifiedName) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(19);
        }
        if (qualifiedName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(20);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, ClassReference.class, "function f() : " + qualifiedName);
    }

    @NotNull
    public static PhpReturnType createReturnType(@NotNull Project project, @NotNull String returnType) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(21);
        }
        if (returnType == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(22);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpReturnType.class, "function f() : " + returnType);
    }

    @NotNull
    public static PhpParameterType createParameterType(@NotNull Project project, @NotNull String type) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(23);
        }
        if (type == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(24);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpParameterType.class, "function f(" + type + " $a) {}");
    }

    @NotNull
    public static PhpReturn createReturnStatement(@NotNull Project project, @Nullable String argument) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(25);
        }
        StringBuilder statementTextBuilder = new StringBuilder();
        statementTextBuilder.append("return");
        if (argument != null) {
            statementTextBuilder.append(" ").append(argument);
        }
        statementTextBuilder.append(";");
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpReturn.class, statementTextBuilder.toString());
    }

    @NotNull
    public static Function createFunction(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(26);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(27);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, Function.class, text);
    }

    @NotNull
    public static FunctionReference createFunctionReference(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(28);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(29);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, FunctionReference.class, text + ";");
    }

    @NotNull
    public static Method createMethod(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(30);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(31);
        }
        String dummyFileTextBuilder = "class A{" + text + "}";
        return PhpPsiElementFactory.createPhpPsiFromText(project, Method.class, dummyFileTextBuilder);
    }

    @NotNull
    public static PhpPsiElement createClassField(@NotNull Project project, @NotNull PhpModifier modifier, @NotNull String name, @Nullable String defaultValue, @Nullable String declaredType) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(32);
        }
        if (modifier == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(33);
        }
        if (name == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(34);
        }
        Object initializer = defaultValue != null ? " = " + defaultValue : "";
        Object formattedTypeString = declaredType != null ? " " + declaredType : "";
        Object fieldName = name.startsWith("$") ? name : "$" + name;
        String dummyFileTextBuilder = "class A{ " + modifier + (String)formattedTypeString + " " + (String)fieldName + (String)initializer + ";}";
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpElementTypes.CLASS_FIELDS, dummyFileTextBuilder);
    }

    @NotNull
    public static PhpPsiElement createClassConstant(@NotNull Project project, @Nullable PhpModifier.Access access, @NotNull String name, @NotNull String defaultValue) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(35);
        }
        if (name == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(36);
        }
        if (defaultValue == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(37);
        }
        String dummyFileTextBuilder = "class A{ " + (access != null ? access.toString() : "") + " const " + name + " = " + defaultValue + ";}";
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpElementTypes.CLASS_CONSTANTS, dummyFileTextBuilder);
    }

    @NotNull
    public static PhpModifierList createModifierList(Project project, PhpModifier modifier) {
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpModifierList.class, "class A {\n" + modifier + " function f() {}}");
    }

    @NotNull
    public static ParameterList createParameterList(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(38);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(39);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, ParameterList.class, "function f(" + text + ")");
    }

    @NotNull
    public static ParameterList createArgumentList(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(40);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(41);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, ParameterList.class, "f(" + text + ")");
    }

    @NotNull
    public static MethodReference createMethodReference(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(42);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(43);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, MethodReference.class, text + ";");
    }

    @Nullable
    public static PhpPsiElement createPhpPsiFromText(Project p, final TokenSet set, @NotNull String text) {
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(44);
        }
        final PhpPsiElement[] ret = new PhpPsiElement[]{null};
        PhpPsiElementFactory.createDummyFile(p, text).accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                ASTNode node = element.getNode();
                if (node != null && set.contains(node.getElementType())) {
                    ret[0] = element;
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/PhpPsiElementFactory$1", "visitElement"));
            }
        });
        return ret[0];
    }

    @NotNull
    public static PhpPsiElement createPhpPsiFromText(Project p, final IElementType type, @NotNull String text) {
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(45);
        }
        final Ref ret = new Ref();
        PsiFile dummyFile = PhpPsiElementFactory.createDummyFile(p, text);
        dummyFile.accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitPhpElement(PhpPsiElement element) {
                ASTNode node = element.getNode();
                if (node != null && node.getElementType() == type) {
                    ret.set((Object)element);
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/PhpPsiElementFactory$2", "visitElement"));
            }
        });
        assert (!ret.isNull()) : "cannot create element from text:\n" + dummyFile.getText();
        PhpPsiElement phpPsiElement = (PhpPsiElement)ret.get();
        if (phpPsiElement == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(46);
        }
        return phpPsiElement;
    }

    @NotNull
    public static <T extends PhpPsiElement> T createPhpPsiFromText(@NotNull Project p, final Class<T> aClass, @NotNull String text) {
        if (p == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(47);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(48);
        }
        final Ref ret = new Ref();
        PsiFile dummyFile = PhpPsiElementFactory.createDummyFile(p, text);
        dummyFile.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                if (aClass.isInstance(element)) {
                    ret.set((Object)element);
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }
        });
        PhpPsiElement element = (PhpPsiElement)ret.get();
        assert (aClass.isInstance(element)) : "cannot create element from text:\n" + dummyFile.getText();
        PhpPsiElement phpPsiElement = element;
        if (phpPsiElement == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(49);
        }
        return (T)phpPsiElement;
    }

    @NotNull
    public static <T extends PsiElement> T createFromText(@NotNull Project p, Class<T> aClass, String text, int[] path) {
        PsiFile dummyFile;
        if (p == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(50);
        }
        PsiFile ret = dummyFile = PhpPsiElementFactory.createDummyFile(p, text);
        for (int skip : path) {
            assert (ret != null) : "cannot create element from text:\n" + dummyFile.getText();
            ret = ret.getFirstChild();
            for (int i = 0; i < skip; ++i) {
                assert (ret != null) : "cannot create element from text:\n" + dummyFile.getText();
                ret = ret.getNextSibling();
            }
        }
        assert (aClass.isInstance(ret)) : "cannot create element from text:\n" + dummyFile.getText();
        PsiFile psiFile = ret;
        if (psiFile == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(51);
        }
        return (T)psiFile;
    }

    @Nullable
    public static <T extends PsiElement> T createFromText(@NotNull Project p, final Class<T> aClass, String text) {
        if (p == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(52);
        }
        final PsiElement[] ret = new PsiElement[]{null};
        PhpPsiElementFactory.createDummyFile(p, text).accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (aClass.isInstance(element)) {
                    ret[0] = element;
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/PhpPsiElementFactory$4", "visitElement"));
            }
        });
        return (T)ret[0];
    }

    public static PsiWhiteSpace createWhiteSpace(Project p) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)p).createFileFromText("DUMMY__." + PhpFileType.INSTANCE.getDefaultExtension(), (FileType)PhpFileType.INSTANCE, (CharSequence)"<?php ", System.currentTimeMillis(), false);
        return (PsiWhiteSpace)psiFile.getChildren()[1];
    }

    public static PsiWhiteSpace createNewLine(Project p) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)p).createFileFromText("DUMMY__." + PhpFileType.INSTANCE.getDefaultExtension(), (FileType)PhpFileType.INSTANCE, (CharSequence)"<?php\n", System.currentTimeMillis(), false);
        return (PsiWhiteSpace)psiFile.getChildren()[1];
    }

    @Nullable
    public static <T extends PsiElement> T createFirstFromText(@NotNull Project p, final Class<T> aClass, String text) {
        if (p == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(53);
        }
        final PsiElement[] ret = new PsiElement[]{null};
        PhpPsiElementFactory.createDummyFile(p, text).accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (aClass.isInstance(element)) {
                    ret[0] = element;
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/PhpPsiElementFactory$5", "visitElement"));
            }
        });
        return (T)ret[0];
    }

    public static PsiElement createFromText(Project p, final IElementType elementType, String text) {
        final PsiElement[] ret = new PsiElement[]{null};
        PhpPsiElementFactory.createDummyFile(p, text).accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                ASTNode node;
                if (element == null) {
                    6.$$$reportNull$$$0(0);
                }
                if ((node = element.getNode()) != null && node.getElementType() == elementType) {
                    ret[0] = element;
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/PhpPsiElementFactory$6", "visitElement"));
            }
        });
        return ret[0];
    }

    public static PsiElement createFromText(Project p, final TokenSet elementType, String text) {
        final PsiElement[] ret = new PsiElement[]{null};
        PhpPsiElementFactory.createDummyFile(p, text).accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                ASTNode node;
                if (element == null) {
                    7.$$$reportNull$$$0(0);
                }
                if ((node = element.getNode()) != null && elementType.contains(node.getElementType())) {
                    ret[0] = element;
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/PhpPsiElementFactory$7", "visitElement"));
            }
        });
        return ret[0];
    }

    public static PsiFile createPsiFileFromText(Project p, String text) {
        return PhpPsiElementFactory.createDummyFile(p, text);
    }

    @NotNull
    public static PhpExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, @NotNull CharSequence text, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(54);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(55);
        }
        @NonNls String name = "fragment." + PhpFileType.INSTANCE.getDefaultExtension();
        return new PhpExpressionCodeFragmentImpl(project, name, text, context, isPhysical);
    }

    @NotNull
    public static PhpTypeCodeFragment createTypeCodeFragment(@NotNull Project project, @NotNull CharSequence text, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(56);
        }
        if (text == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(57);
        }
        @NonNls String name = "fragment." + PhpFileType.INSTANCE.getDefaultExtension();
        return new PhpTypeCodeFragment(project, name, text, context, isPhysical);
    }

    @NotNull
    public static PsiElement createOpConcat(@NotNull Project project) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(58);
        }
        PsiElement psiElement = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opCONCAT, "'1'.'1';");
        if (psiElement == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(59);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createOpConcatAsgn(@NotNull Project project) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(60);
        }
        PsiElement psiElement = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opCONCAT_ASGN, "$a.='1';");
        if (psiElement == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(61);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createArrow(@NotNull Project project) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(62);
        }
        PsiElement psiElement = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.ARROW, "$a->b;");
        if (psiElement == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(63);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createScopeResolution(@NotNull Project project) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(64);
        }
        PsiElement psiElement = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.SCOPE_RESOLUTION, "$a::b;");
        if (psiElement == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(65);
        }
        return psiElement;
    }

    public static PsiElement createQuest(@NotNull Project project) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(66);
        }
        return PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opQUEST, "function f():?string");
    }

    public static PsiElement createColon(@NotNull Project project) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(67);
        }
        return PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opCOLON, "function f():string");
    }

    @NotNull
    public static PsiElement createComma(@NotNull Project project) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(68);
        }
        PsiElement psiElement = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opCOMMA, "function foo($a,$b){}");
        if (psiElement == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(69);
        }
        return psiElement;
    }

    @NotNull
    public static PhpUseList createUseStatement(@NotNull Project project, @NotNull String fqn, @Nullable String alias) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(70);
        }
        if (fqn == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(71);
        }
        return PhpPsiElementFactory.createUseStatementWithKeyword(project, null, fqn, alias);
    }

    @NotNull
    public static PhpUseList createUseStatementWithKeyword(@NotNull Project project, @Nullable String keyword, @NotNull String fqn, @Nullable String alias) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(72);
        }
        if (fqn == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(73);
        }
        PhpContractUtil.assertFqn(fqn);
        PhpContractUtil.assertNoQualifier(alias);
        StringBuilder builder = new StringBuilder("<?php\nuse ");
        if (StringUtil.isNotEmpty((String)keyword)) {
            builder.append(keyword).append(" ");
        }
        builder.append(StringUtil.trimStart((String)fqn, (String)"\\"));
        if (StringUtil.isNotEmpty((String)alias)) {
            builder.append(" as ").append(alias);
        }
        builder.append(";\n");
        PhpUseList phpUseList = PhpPsiElementFactory.createFromText(project, PhpUseList.class, builder.toString());
        if (phpUseList == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(74);
        }
        return phpUseList;
    }

    @NotNull
    public static PhpUseList createTraitClassImport(@NotNull Project project, @NotNull String fqn) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(75);
        }
        if (fqn == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(76);
        }
        PhpUseList phpUseList = PhpPsiElementFactory.createFromText(project, PhpUseList.class, "<?php\n class ClassA {\nuse " + fqn + ";\n}\n");
        if (phpUseList == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(77);
        }
        return phpUseList;
    }

    @NotNull
    public static PhpUseList createGroupUseStatementWithKeyword(@NotNull Project project, @Nullable String keyword, @NotNull String fqn, @NotNull Collection<? extends PhpGroupUseElement> uses) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(78);
        }
        if (fqn == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(79);
        }
        if (uses == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(80);
        }
        return PhpPsiElementFactory.createGroupUseStatement(project, keyword, fqn, uses, false);
    }

    @NotNull
    public static PhpUseList createGroupUseStatement(@NotNull Project project, @Nullable String keyword, @NotNull String fqn, @NotNull Collection<? extends PhpGroupUseElement> uses, boolean trailingComma) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(81);
        }
        if (fqn == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(82);
        }
        if (uses == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(83);
        }
        PhpContractUtil.assertFqn(fqn);
        StringBuilder builder = new StringBuilder("<?php\nuse ");
        if (StringUtil.isNotEmpty((String)keyword)) {
            builder.append(keyword).append(" ");
        }
        builder.append(StringUtil.trimStart((String)fqn, (String)"\\"));
        builder.append('{');
        boolean first = true;
        for (PhpGroupUseElement phpGroupUseElement : uses) {
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            if (StringUtil.isNotEmpty((String)phpGroupUseElement.keyword)) {
                LOG.assertTrue(StringUtil.isEmpty((String)keyword), (Object)"Either a PhpUseList or PhpUse level keyword must be provided, not both");
                builder.append(phpGroupUseElement.keyword).append(" ");
            }
            builder.append(phpGroupUseElement.name);
            if (!StringUtil.isNotEmpty((String)phpGroupUseElement.alias)) continue;
            PhpContractUtil.assertNoQualifier(phpGroupUseElement.alias);
            builder.append(" as ").append(phpGroupUseElement.alias);
        }
        if (trailingComma && !uses.isEmpty()) {
            builder.append(',');
        }
        builder.append("};\n");
        PhpUseList phpUseList = PhpPsiElementFactory.createFromText(project, PhpUseList.class, builder.toString());
        if (phpUseList == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(84);
        }
        return phpUseList;
    }

    @NotNull
    public static PhpNamespaceReference createNamespaceReference(@NotNull Project project, @NotNull String namespaceReference, boolean phpDoc) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(85);
        }
        if (namespaceReference == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(86);
        }
        LOG.assertTrue(!StringUtil.endsWith((CharSequence)namespaceReference, (CharSequence)"\\"));
        LOG.assertTrue(!StringUtil.isEmpty((String)namespaceReference));
        if (phpDoc) {
            PhpNamespaceReference phpNamespaceReference = PhpPsiElementFactory.createFromText(project, PhpNamespaceReference.class, "<?php\n/*** @var " + namespaceReference + "\\Bar */\n");
            if (phpNamespaceReference == null) {
                PhpPsiElementFactory.$$$reportNull$$$0(87);
            }
            return phpNamespaceReference;
        }
        PhpNamespaceReference phpNamespaceReference = PhpPsiElementFactory.createFromText(project, PhpNamespaceReference.class, "<?php\nnew " + namespaceReference + "\\A();\n");
        if (phpNamespaceReference == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(88);
        }
        return phpNamespaceReference;
    }

    @NotNull
    public static PhpDocType createPhpDocType(@NotNull Project project, @NotNull String qualifiedName) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(89);
        }
        if (qualifiedName == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(90);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocType.class, "/** @var " + qualifiedName + "  */\n");
    }

    @NotNull
    public static Collection<PhpDocType> createPhpDocTypes(@NotNull Project project, @NotNull String typePresentation) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(91);
        }
        if (typePresentation == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(92);
        }
        PhpDocParamTagImpl docTag = PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocParamTagImpl.class, "/** @var " + typePresentation + "  */\n");
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag, PhpDocType.class);
        if (list == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(93);
        }
        return list;
    }

    @NotNull
    public static PhpDocRef createPhpDocRef(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(94);
        }
        if (name == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(95);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocRef.class, "/** @see " + name + "  */\n");
    }

    @NotNull
    public static StringLiteralExpression createStringLiteralExpression(@NotNull Project project, @NotNull String content, boolean singleQuote) {
        if (project == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(96);
        }
        if (content == null) {
            PhpPsiElementFactory.$$$reportNull$$$0(97);
        }
        String quote = singleQuote ? "'" : "\"";
        return PhpPsiElementFactory.createPhpPsiFromText(project, StringLiteralExpression.class, quote + content + quote);
    }

    @NotNull
    public static PhpDocTag createPhpDocTag(Project project, String docTagContent) {
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocTag.class, "/** " + docTagContent + "  */\nfunction a() {}");
    }

    public static PsiElement createNamedArgumentNameIdentifier(Project project, String name) {
        return PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, "f(" + name + ": $a);");
    }

    @NotNull
    public static PhpAttributesList createAttributesList(Project project, String attributeText) {
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpAttributesList.class, "#[" + attributeText + "] class a{}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 46: 
            case 49: 
            case 51: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 69: 
            case 74: 
            case 77: 
            case 84: 
            case 87: 
            case 88: 
            case 93: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 46: 
            case 49: 
            case 51: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 69: 
            case 74: 
            case 77: 
            case 84: 
            case 87: 
            case 88: 
            case 93: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 46: 
            case 49: 
            case 51: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 69: 
            case 74: 
            case 77: 
            case 84: 
            case 87: 
            case 88: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/PhpPsiElementFactory";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectParam";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementText";
                break;
            }
            case 20: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 34: 
            case 36: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 47: 
            case 50: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 71: 
            case 73: 
            case 76: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uses";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceReference";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePresentation";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/PhpPsiElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassConstantReferenceUsingSelf";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldReferenceUsingSelf";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldReferenceUsingThis";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldReference";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyFile";
                break;
            }
            case 46: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createPhpPsiFromText";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromText";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpConcat";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpConcatAsgn";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrow";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeResolution";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createComma";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseStatementWithKeyword";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createTraitClassImport";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupUseStatement";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespaceReference";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "createPhpDocTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createClassEmptyConstructor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConstantReference";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 46: 
            case 49: 
            case 51: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 69: 
            case 74: 
            case 77: 
            case 84: 
            case 87: 
            case 88: 
            case 93: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createClassConstantReferenceUsingSelf";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFieldReferenceUsingSelf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFieldReferenceUsingThis";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFieldReference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createComplexParameter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createVariable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createStatement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createClassReference";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createReturnType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createParameterType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createReturnStatement";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createFunction";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionReference";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createClassField";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createClassConstant";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentList";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createMethodReference";
                break;
            }
            case 44: 
            case 45: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createPhpPsiFromText";
                break;
            }
            case 50: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createFromText";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createFirstFromText";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createTypeCodeFragment";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createOpConcat";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createOpConcatAsgn";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createArrow";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createScopeResolution";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createQuest";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createColon";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createComma";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createUseStatement";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createUseStatementWithKeyword";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createTraitClassImport";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createGroupUseStatementWithKeyword";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createGroupUseStatement";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createNamespaceReference";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "createPhpDocType";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createPhpDocTypes";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "createPhpDocRef";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteralExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 46: 
            case 49: 
            case 51: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 69: 
            case 74: 
            case 77: 
            case 84: 
            case 87: 
            case 88: 
            case 93: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

