/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.patterns;

import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.injection.PhpElementPattern;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPatterns
extends PlatformPatterns {
    private static final int STRING_LITERAL_LIMIT = 10000;
    static final Map<String, RunAutomaton> map = ContainerUtil.createWeakKeyWeakValueMap();

    public static PhpElementPattern phpElement() {
        return new PhpElementPattern.Capture<PhpPsiElement>(PhpPsiElement.class);
    }

    public static PhpElementPattern phpFunctionReference() {
        return new PhpElementPattern.Capture<FunctionReference>(FunctionReference.class);
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpLiteralExpression() {
        return PhpPatterns.phpLiteralExpression(null);
    }

    private static PsiElementPattern.Capture<BinaryExpression> phpConcatenationExpression() {
        return (PsiElementPattern.Capture)PhpPatterns.psiElement(BinaryExpression.class).and((ElementPattern)PhpPatterns.psiElement((IElementType)PhpElementTypes.CONCATENATION_EXPRESSION));
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpStringLiteralInsideEval() {
        return (PhpElementPattern.Capture)PhpPatterns.phpLiteralExpression().inside(true, (ElementPattern)PhpPatterns.phpEval(), (ElementPattern)PhpPatterns.not((ElementPattern)PhpPatterns.or((ElementPattern[])new ElementPattern[]{PhpPatterns.phpEval(), PhpPatterns.phpConcatenationExpression()})));
    }

    private static PhpElementPattern.Capture<PhpEval> phpEval() {
        return new PhpElementPattern.Capture<PhpEval>(PhpEval.class);
    }

    public static PhpElementPattern.Capture<PhpExpression> phpFirstArgument(final @Nullable PhpElementPattern.Capture<FunctionReference> functionReferenceCapture) {
        return new PhpElementPattern.Capture<PhpExpression>(PhpExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                PsiElement firstArgument;
                if (!(o instanceof PhpExpression)) {
                    return false;
                }
                ParameterList parameterList = (ParameterList)PhpPsiUtil.getParentByCondition((PsiElement)o, true, (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                PsiElement psiElement = firstArgument = parameterList != null ? parameterList.getParameter(0) : null;
                if (firstArgument == null || !PhpPatterns.unwrapConcatenation(firstArgument).contains(PhpPsiUtil.unparenthesize((PsiElement)o))) {
                    return false;
                }
                if (functionReferenceCapture == null) {
                    return true;
                }
                FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)parameterList.getParent(), FunctionReference.class);
                return functionReferenceCapture.accepts(functionReference);
            }
        };
    }

    @NotNull
    private static Collection<PsiElement> unwrapConcatenation(@Nullable PsiElement argument) {
        if (argument instanceof ParenthesizedExpression) {
            return PhpPatterns.unwrapConcatenation((PsiElement)((ParenthesizedExpression)argument).unparenthesize());
        }
        if (argument instanceof BinaryExpression && ((BinaryExpression)argument).getOperationType() == PhpTokenTypes.opCONCAT) {
            ArrayList<PsiElement> res = new ArrayList<PsiElement>();
            res.addAll(PhpPatterns.unwrapConcatenation(((BinaryExpression)argument).getLeftOperand()));
            res.addAll(PhpPatterns.unwrapConcatenation(((BinaryExpression)argument).getRightOperand()));
            ArrayList<PsiElement> arrayList = res;
            if (arrayList == null) {
                PhpPatterns.$$$reportNull$$$0(0);
            }
            return arrayList;
        }
        Collection<Object> collection = argument != null ? Collections.singleton(argument) : Collections.emptyList();
        if (collection == null) {
            PhpPatterns.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public static PhpElementPattern.Capture<FunctionReference> phpWithName(final @NotNull ElementPattern<String> namePattern) {
        if (namePattern == null) {
            PhpPatterns.$$$reportNull$$$0(2);
        }
        return new PhpElementPattern.Capture<FunctionReference>(new InitialPatternCondition<FunctionReference>(FunctionReference.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof PhpPsiElement && namePattern.accepts((Object)((PhpPsiElement)o).getName());
            }
        });
    }

    public static synchronized PhpElementPattern.Capture<StringLiteralExpression> phpLiteralMatchesBrics(@NotNull String pattern) {
        if (pattern == null) {
            PhpPatterns.$$$reportNull$$$0(3);
        }
        final RunAutomaton runAutomaton = map.computeIfAbsent(pattern, s -> {
            StringBuilder sb = new StringBuilder(s.length() * 5);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ') {
                    sb.append("<whitespacechar>");
                    continue;
                }
                if (Character.isUpperCase(c) && !PhpPatterns.notInSymbolRange(s, i)) {
                    sb.append('[').append(Character.toUpperCase(c)).append(Character.toLowerCase(c)).append(']');
                    continue;
                }
                sb.append(c);
            }
            RegExp regExp = new RegExp(sb.toString());
            return new RunAutomaton(regExp.toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider()), true);
        });
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                StringLiteralExpression expr;
                if (o instanceof StringLiteralExpression && (expr = (StringLiteralExpression)o).getTextLength() < 10000) {
                    String value = expr.getContents();
                    boolean run = runAutomaton.run(value);
                    return run;
                }
                return false;
            }
        });
    }

    private static boolean notInSymbolRange(String s, int i) {
        return i + 1 < s.length() && s.charAt(i + 1) == '-' || i - 1 >= 0 && s.charAt(i - 1) == '-';
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpLiteralExpressionWithValue(final ElementPattern<String> valuePattern) {
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof StringLiteralExpression && valuePattern.accepts((Object)((StringLiteralExpression)o).getContents());
            }
        });
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpLiteralExpression(final String name) {
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                StringLiteralExpression s;
                return o instanceof StringLiteralExpression && (!PhpPsiUtil.isOfType((s = (StringLiteralExpression)o).getParent(), PhpElementTypes.CONCATENATION_EXPRESSION) || s.getPrevPsiSibling() == null) && (name == null && s.getName() == null || name != null && name.equalsIgnoreCase(s.getName()));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/patterns/PhpPatterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapConcatenation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/patterns/PhpPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "phpWithName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "phpLiteralMatchesBrics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

