/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class EchoStatement {
    private static final ParserPart PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            return Expression.parse(builder);
        }
    };

    public static IElementType parse(PhpPsiBuilder builder, boolean isPhpOpenTag) {
        int c;
        PsiBuilder.Marker echo = null;
        if (!isPhpOpenTag) {
            echo = builder.mark();
            builder.advanceLexer();
        }
        if ((c = EchoStatement.parseEchoExpressions(builder)) == 0) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        if (!builder.compare(PhpTokenTypes.PHP_CLOSING_TAG)) {
            builder.match(PhpTokenTypes.opSEMICOLON);
        }
        if (!isPhpOpenTag) {
            echo.done(PhpElementTypes.ECHO);
        }
        return PhpElementTypes.ECHO;
    }

    private static int parseEchoExpressions(PhpPsiBuilder builder) {
        return ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, PARSER_PART.parse(builder), PARSER_PART, false);
    }
}

