/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.primary;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.calls.Function;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class Array {
    public static final ParserPart PART = new ElementPart();

    private static IElementType parseArrayVariable(PhpPsiBuilder builder) {
        builder.compareAndEat(PhpTokenTypes.opVARIADIC);
        if (builder.compareAndEat(PhpTokenTypes.opBIT_AND)) {
            PsiBuilder.Marker var = builder.mark();
            IElementType result = Variable.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("variable1", new Object[0])));
                var.drop();
            } else {
                var.done(result);
            }
            return PhpElementTypes.ARRAY_VALUE;
        }
        return Expression.parse(builder);
    }

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.compare(PhpTokenTypes.kwARRAY) || builder.compare(PhpTokenTypes.chLBRACKET)) {
            marker.done(Array.parseInner(builder));
            IElementType result = PhpElementTypes.ARRAY_CREATION_EXPRESSION;
            return Array.tryParsingArrayDerefOrFunctionCall(builder, result, marker);
        }
        marker.drop();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType tryParsingArrayDerefOrFunctionCall(PhpPsiBuilder builder, IElementType result, PsiBuilder.Marker scalar) {
        while (builder.compare(PhpTokenTypes.chLBRACKET) || builder.compare(PhpTokenTypes.chLPAREN)) {
            scalar = scalar.precede();
            if (builder.compare(PhpTokenTypes.chLBRACKET)) {
                result = PhpElementTypes.ARRAY_ACCESS_EXPRESSION;
                Variable.parseArrayAccessWithOptionalIndex(builder);
            } else {
                result = PhpElementTypes.FUNCTION_CALL;
                Function.parseFunctionCallParameterList(builder);
            }
            scalar.done(result);
        }
        return result;
    }

    public static IElementType parseInner(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.kwARRAY) || builder.compare(PhpTokenTypes.chLBRACKET)) {
            boolean longSyntax = builder.compareAndEat(PhpTokenTypes.kwARRAY);
            if (longSyntax) {
                builder.match(PhpTokenTypes.chLPAREN);
            } else {
                builder.match(PhpTokenTypes.chLBRACKET);
            }
            ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, PART.parse(builder), PART, true, true);
            if (longSyntax) {
                builder.match(PhpTokenTypes.chRPAREN);
            } else {
                builder.match(PhpTokenTypes.chRBRACKET);
            }
            return PhpElementTypes.ARRAY_CREATION_EXPRESSION;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static void tryParsingArrayDeref(PhpPsiBuilder builder, PsiBuilder.Marker scalar) {
        while (builder.compare(PhpTokenTypes.chLBRACKET)) {
            scalar = scalar.precede();
            Variable.parseArrayAccessWithOptionalIndex(builder);
            scalar.done(PhpElementTypes.ARRAY_ACCESS_EXPRESSION);
        }
    }

    public static class ElementPart
    implements ParserPart {
        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker array = builder.mark();
            PsiBuilder.Marker item = builder.mark();
            IElementType result = ElementPart.parseVariable(builder);
            if (result == PhpElementTypes.ARRAY_VALUE) {
                item.done(result);
                array.drop();
                return result;
            }
            if (result != PhpElementTypes.EMPTY_INPUT) {
                boolean hash_array_element = builder.compare(PhpTokenTypes.opHASH_ARRAY);
                if (hash_array_element) {
                    item.done(PhpElementTypes.ARRAY_KEY);
                    builder.advanceLexer();
                    item = builder.mark();
                    IElementType hashValueType = ElementPart.parseVariable(builder);
                    if (hashValueType == PhpElementTypes.EMPTY_INPUT) {
                        builder.error(PhpParserErrors.getExpressionExpectedMessage());
                    }
                }
                item.done(PhpElementTypes.ARRAY_VALUE);
                if (hash_array_element) {
                    array.done(PhpElementTypes.HASH_ARRAY_ELEMENT);
                } else {
                    array.drop();
                }
                return PhpElementTypes.ARRAY_VALUE;
            }
            item.drop();
            array.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }

        private static IElementType parseVariable(PhpPsiBuilder builder) {
            if (builder.compare(PhpTokenTypes.kwLIST)) {
                AssignmentExpression.parseArrayLiteral(builder, true);
                return PhpElementTypes.ARRAY_VALUE;
            }
            return Array.parseArrayVariable(builder);
        }
    }
}

