/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.math;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.math.MultiplicativeExpression;
import java.util.function.Function;

public class AdditiveExpression {
    private static final TokenSet ADDITIVE_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMINUS});
    private static final int MAX_DEPTH = 300;

    public static IElementType parseLeftAssociativeBinary(PhpPsiBuilder builder, TokenSet operator, IElementType resType, Function<PhpPsiBuilder, IElementType> rightPartParser) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = rightPartParser.apply(builder);
        if (result != PhpElementTypes.EMPTY_INPUT && builder.compareAndEat(operator)) {
            boolean ignorePrecede = false;
            int curDepth = 0;
            result = AdditiveExpression.subParse(builder, rightPartParser);
            marker.done(resType);
            marker = marker.precede();
            ++curDepth;
            while (builder.compareAndEat(operator)) {
                result = AdditiveExpression.subParse(builder, rightPartParser);
                if (!ignorePrecede && curDepth > 300) {
                    ignorePrecede = true;
                }
                if (ignorePrecede) continue;
                marker.done(resType);
                marker = marker.precede();
                ++curDepth;
            }
            if (ignorePrecede) {
                marker.done(resType);
                marker = marker.precede();
            }
        }
        marker.drop();
        return result;
    }

    public static IElementType parse(PhpPsiBuilder builder) {
        return AdditiveExpression.parseLeftAssociativeBinary(builder, ADDITIVE_OPERATORS, PhpElementTypes.ADDITIVE_EXPRESSION, MultiplicativeExpression::parse);
    }

    private static IElementType subParse(PhpPsiBuilder builder, Function<PhpPsiBuilder, IElementType> rightSubPartParser) {
        IElementType result = AssignmentExpression.parseWithoutPriority(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = rightSubPartParser.apply(builder);
        }
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        return result;
    }
}

