/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.comparition;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.bit.ShiftExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.math.AdditiveExpression;
import org.jetbrains.annotations.NotNull;

public class RelationalExpression {
    @NotNull
    private static final TokenSet CONCAT_OPERATOR = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCONCAT});

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = RelationalExpression.parseConcat(builder);
        if (result != PhpElementTypes.EMPTY_INPUT && builder.compareAndEat(PhpTokenTypes.tsCOMPARE_ORDER_OPS)) {
            result = AssignmentExpression.parseWithoutPriority(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                result = RelationalExpression.parseConcat(builder);
            }
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            marker.done(PhpElementTypes.RELATIONAL_EXPRESSION);
            return PhpElementTypes.RELATIONAL_EXPRESSION;
        }
        marker.drop();
        return result;
    }

    private static IElementType parseConcat(PhpPsiBuilder builder) {
        return AdditiveExpression.parseLeftAssociativeBinary(builder, CONCAT_OPERATOR, PhpElementTypes.CONCATENATION_EXPRESSION, ShiftExpression::parse);
    }
}

