/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.bit;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.math.AdditiveExpression;

public class ShiftExpression {
    private static final TokenSet SHIFT_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opSHIFT_LEFT, PhpTokenTypes.opSHIFT_RIGHT});

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = AdditiveExpression.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT && builder.compareAndEat(SHIFT_OPERATORS)) {
            result = AssignmentExpression.parseWithoutPriority(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                result = AdditiveExpression.parse(builder);
            }
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            PsiBuilder.Marker newMarker = marker.precede();
            marker.done(PhpElementTypes.SHIFT_EXPRESSION);
            result = PhpElementTypes.SHIFT_EXPRESSION;
            if (builder.compareAndEat(SHIFT_OPERATORS)) {
                ShiftExpression.subParse(builder, newMarker);
            } else {
                newMarker.drop();
            }
        } else {
            marker.drop();
        }
        return result;
    }

    private static IElementType subParse(PhpPsiBuilder builder, PsiBuilder.Marker marker) {
        IElementType result = AssignmentExpression.parseWithoutPriority(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = AdditiveExpression.parse(builder);
        }
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done(PhpElementTypes.SHIFT_EXPRESSION);
        if (builder.compareAndEat(SHIFT_OPERATORS)) {
            ShiftExpression.subParse(builder, newMarker);
        } else {
            newMarker.drop();
        }
        return PhpElementTypes.SHIFT_EXPRESSION;
    }
}

