/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.PostfixExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.PrimaryExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.logical.LogicalNotExpression;

public class UnaryExpression {
    private static final TokenSet CAST_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opBOOLEAN_CAST, PhpTokenTypes.opINTEGER_CAST, PhpTokenTypes.opSTRING_CAST, PhpTokenTypes.opARRAY_CAST, PhpTokenTypes.opOBJECT_CAST, PhpTokenTypes.opUNSET_CAST, PhpTokenTypes.opFLOAT_CAST});
    public static final TokenSet INC_DEC_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opINCREMENT, PhpTokenTypes.opDECREMENT});
    private static final TokenSet opPLUS___opMINUS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMINUS});

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.compareAndEat(CAST_OPERATORS)) {
            IElementType result = UnaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            marker.done(PhpElementTypes.CAST_EXPRESSION);
            return PhpElementTypes.CAST_EXPRESSION;
        }
        if (builder.compareAndEat(PhpTokenTypes.opBIT_NOT)) {
            IElementType result = UnaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            marker.done(PhpElementTypes.INFIX_EXPRESSION);
            return PhpElementTypes.INFIX_EXPRESSION;
        }
        if (builder.compareAndEat(PhpTokenTypes.opNOT)) {
            IElementType result = LogicalNotExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            marker.done(PhpElementTypes.INFIX_EXPRESSION);
            return PhpElementTypes.INFIX_EXPRESSION;
        }
        if (builder.compareAndEat(PhpTokenTypes.opSILENCE)) {
            IElementType result = UnaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            marker.done(PhpElementTypes.SILENCE_EXPRESSION);
            return PhpElementTypes.SILENCE_EXPRESSION;
        }
        if (builder.compareAndEat(INC_DEC_OPERATORS)) {
            IElementType result = PrimaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            marker.done(PhpElementTypes.INFIX_WRITE_EXPRESSION);
            return PhpElementTypes.INFIX_WRITE_EXPRESSION;
        }
        if (builder.compareAndEat(opPLUS___opMINUS)) {
            IElementType result = UnaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            marker.done(PhpElementTypes.INFIX_EXPRESSION);
            return PhpElementTypes.INFIX_EXPRESSION;
        }
        marker.drop();
        IElementType result = AssignmentExpression.parseWithoutPriority(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = PostfixExpression.parse(builder);
        }
        return result;
    }
}

