/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class MatchExpression {
    public static IElementType parse(PhpPsiBuilder builder) {
        if (builder.getTokenType() != PhpTokenTypes.kwMATCH) {
            if (builder.getTokenType() != PhpTokenTypes.IDENTIFIER || !"match".equalsIgnoreCase(builder.getTokenText())) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            builder.remapToMatchKeyword();
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.compare(PhpTokenTypes.SCOPE_RESOLUTION) || builder.compare(PhpTokenTypes.chLBRACKET)) {
            mark.rollbackTo();
            builder.remapToIdentifier();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.match(PhpTokenTypes.chLPAREN);
        IElementType expr = Expression.parse(builder);
        if (expr == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        builder.match(PhpTokenTypes.chRPAREN);
        builder.match(PhpTokenTypes.chLBRACE);
        int numberOfArms = ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, MatchExpression::parseMatchArm, true);
        if (numberOfArms == 0) {
            if (!builder.matchExpressionSupported()) {
                mark.rollbackTo();
                builder.remapToIdentifier();
                return PhpElementTypes.EMPTY_INPUT;
            }
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        builder.match(PhpTokenTypes.chRBRACE);
        mark.done(PhpElementTypes.MATCH_EXPRESSION);
        return PhpElementTypes.MATCH_EXPRESSION;
    }

    private static IElementType parseMatchArm(PhpPsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        IElementType result = MatchExpression.parseMatchArmConditions(builder);
        if (builder.compare(PhpTokenTypes.opHASH_ARRAY) || builder.compare(PhpTokenTypes.opCOLON)) {
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            builder.advanceLexer();
            IElementType body = Expression.parse(builder);
            if (body == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            IElementType matchArmType = result != PhpElementTypes.EMPTY_INPUT ? result : PhpElementTypes.MATCH_ARM;
            mark.done(matchArmType);
            return matchArmType;
        }
        if (result != PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected("=>"));
            if (builder.matchExpressionSupported()) {
                mark.done(result);
                return result;
            }
        }
        mark.drop();
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static IElementType parseMatchArmConditions(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.kwDEFAULT)) {
            builder.compareAndEat(PhpTokenTypes.opCOMMA);
            return PhpElementTypes.DEFAULT_MATCH_ARM;
        }
        int numberOfConditions = ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, Expression::parse, true);
        return numberOfConditions == 0 ? PhpElementTypes.EMPTY_INPUT : PhpElementTypes.MATCH_ARM;
    }
}

