/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.Namespace;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.classes.StaticClassConstant;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class ClassReference {
    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType namespace = Namespace.parseReference(builder);
        if (builder.compare(PhpTokenTypes.IDENTIFIER) || builder.compare(PhpTokenTypes.kwSTATIC)) {
            builder.advanceLexer();
            marker.done(PhpElementTypes.CLASS_REFERENCE);
            return PhpElementTypes.CLASS_REFERENCE;
        }
        if (namespace != PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.IDENTIFIER));
            marker.done(PhpElementTypes.CLASS_REFERENCE);
            return PhpElementTypes.CLASS_REFERENCE;
        }
        marker.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseClassNameReference(PhpPsiBuilder builder) {
        IElementType result;
        PsiBuilder.Marker marker = builder.mark();
        IElementType iElementType = result = builder.compare(PhpTokenTypes.chLPAREN) ? Expression.parse(builder) : ClassReference.parseDynamicClassNameReference(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            Namespace.parseReference(builder);
            if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER) || builder.compareAndEat(PhpTokenTypes.kwSTATIC)) {
                result = PhpElementTypes.CLASS_REFERENCE;
                marker.done(result);
                if (builder.compareAndEat(PhpTokenTypes.SCOPE_RESOLUTION)) {
                    if (builder.compareAndEat(StaticClassConstant.NN)) {
                        result = PhpElementTypes.CLASS_CONSTANT_REFERENCE;
                        marker.precede().done(result);
                    } else {
                        Variable.parseBaseVariable(builder);
                        result = PhpElementTypes.FIELD_REFERENCE;
                        marker.precede().done(result);
                    }
                }
                return result;
            }
            marker.drop();
        } else {
            marker.done(PhpElementTypes.CLASS_REFERENCE);
            result = PhpElementTypes.CLASS_REFERENCE;
        }
        return result;
    }

    private static IElementType parseDynamicClassNameReference(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = Variable.parseBaseVariable(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            while (true) {
                if (builder.compareArrowOrNullsafeArrow()) {
                    marker.done(result);
                    builder.compareAndEat(PhpPsiBuilder.QUESTION_MARKS);
                    builder.advanceLexer();
                    marker = marker.precede();
                    result = Variable.parseObjectProperty(builder);
                    if (result != PhpElementTypes.EMPTY_INPUT) continue;
                    builder.error(PhpParserErrors.expected(PhpBundle.message("object.property", new Object[0])));
                    continue;
                }
                if (builder.compare(PhpTokenTypes.SCOPE_RESOLUTION)) {
                    marker.done(result);
                    marker = marker.precede();
                    builder.advanceLexer();
                    IElementType type = Variable.parseBaseVariable(builder);
                    result = PhpElementTypes.CLASS_CONSTANT_REFERENCE;
                    continue;
                }
                if (!builder.compare(Variable.chLBRACE___chLBRACKET)) break;
                marker.done(result);
                marker = marker.precede();
                result = Variable.parseArrayAccessWithOptionalIndex(builder);
            }
        }
        if (result != PhpElementTypes.EMPTY_INPUT) {
            marker.done(result);
        } else {
            marker.drop();
        }
        return result;
    }
}

