/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.Attributes;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import com.jetbrains.php.lang.parser.parsing.functions.Function;
import com.jetbrains.php.lang.parser.parsing.functions.IsReference;
import com.jetbrains.php.lang.parser.parsing.functions.ParameterList;

public class ClassMethod {
    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker method = builder.mark();
        Attributes.parseAttributesList(builder);
        if (!builder.compare(PhpTokenTypes.tsMODIFIERS) && !builder.compare(PhpTokenTypes.kwFUNCTION)) {
            method.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        ClassMemberModifiers.parseMethodModifiers(builder);
        Attributes.parseAttributesList(builder);
        if (!builder.compare(PhpTokenTypes.kwFUNCTION)) {
            method.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.match(PhpTokenTypes.kwFUNCTION);
        Attributes.parseAttributesList(builder);
        IsReference.parse(builder);
        if (builder.compare(PhpTokenTypes.tsKEYWORDS) || builder.compare(PhpTokenTypes.IDENTIFIER)) {
            builder.advanceLexer();
        } else {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.IDENTIFIER));
        }
        if (builder.compareAndEat(PhpTokenTypes.chLPAREN)) {
            ParameterList.parse(builder, false);
            builder.match(PhpTokenTypes.chRPAREN);
        } else {
            builder.match(PhpTokenTypes.chLPAREN);
        }
        Function.parseReturnType(builder);
        IElementType methodBody = ClassMethod.parseMethodBody(builder);
        if (methodBody != PhpTokenTypes.opSEMICOLON) {
            builder.compareAndEat(PhpTokenTypes.opSEMICOLON);
        }
        method.done(PhpStubElementTypes.CLASS_METHOD);
        return PhpStubElementTypes.CLASS_METHOD;
    }

    private static IElementType parseMethodBody(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.opSEMICOLON)) {
            return PhpTokenTypes.opSEMICOLON;
        }
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
        } else {
            builder.match(PhpTokenTypes.chLBRACE);
        }
        return PhpElementTypes.GROUP_STATEMENT;
    }
}

