/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.Attributes;
import com.jetbrains.php.lang.parser.parsing.TypeDeclaration;
import com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class ClassField {
    private static final ParserPart PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            IElementType result;
            if (!builder.compare(PhpTokenTypes.VARIABLE)) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            PsiBuilder.Marker field = builder.mark();
            builder.match(PhpTokenTypes.VARIABLE);
            if (builder.compareAndEat(PhpTokenTypes.opASGN) && (result = Expression.parse(builder)) == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("initializer", new Object[0])));
            }
            field.done(PhpStubElementTypes.CLASS_FIELD);
            return PhpStubElementTypes.CLASS_FIELD;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result;
        PsiBuilder.Marker classFields = builder.mark();
        Attributes.parseAttributesList(builder);
        if (ClassMemberModifiers.parseVariableModifiers(builder) == PhpElementTypes.EMPTY_INPUT) {
            classFields.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        IElementType typeResult = TypeDeclaration.parseType(builder, PhpElementTypes.FIELD_TYPE);
        if (typeResult != PhpElementTypes.EMPTY_INPUT) {
            Attributes.parseAttributesList(builder);
        }
        if ((result = PARSER_PART.parse(builder)) == PhpElementTypes.EMPTY_INPUT) {
            if (typeResult != PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("variable1", new Object[0])));
            } else {
                classFields.rollbackTo();
                return PhpElementTypes.EMPTY_INPUT;
            }
        }
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, result, PARSER_PART, false);
        builder.match(PhpTokenTypes.opSEMICOLON);
        classFields.done(PhpElementTypes.CLASS_FIELDS);
        return PhpElementTypes.CLASS_FIELDS;
    }
}

