/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.calls;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.calls.Function;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.expressions.PrimaryExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Variable {
    public static final TokenSet chLBRACE___chLBRACKET = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chLBRACE, PhpTokenTypes.chLBRACKET});
    private static final TokenSet chRBRACE___chRBRACKET = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chRBRACKET, PhpTokenTypes.chRBRACE});
    public static final TokenSet START_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE_NAME, PhpTokenTypes.VARIABLE, PhpTokenTypes.DOLLAR, PhpTokenTypes.IDENTIFIER, PhpTokenTypes.kwSTATIC});

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker reference = builder.mark();
        IElementType result = Variable.parseBaseVariableOrFunctionCall(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            while (builder.compareArrowOrNullsafeArrow() || builder.compare(PhpTokenTypes.SCOPE_RESOLUTION) || builder.compare(PhpTokenTypes.chLBRACKET) || builder.compare(PhpTokenTypes.chLBRACE)) {
                reference.done(result);
                reference = reference.precede();
                result = Variable.parseArrayDeref(builder);
                result = Variable.parseMethodCall(builder, result);
            }
        }
        while (builder.compare(PhpTokenTypes.chLPAREN)) {
            reference.done(result);
            reference = reference.precede();
            result = PhpElementTypes.FUNCTION_CALL;
            Function.parseFunctionCallParameterList(builder);
            while (builder.compare(chLBRACE___chLBRACKET) || builder.compareArrowOrNullsafeArrow()) {
                reference.done(result);
                reference = reference.precede();
                if (builder.compare(chLBRACE___chLBRACKET)) {
                    result = Variable.parseArrayDeref(builder);
                    continue;
                }
                result = Variable.parseMethodCall(builder, PhpElementTypes.EMPTY_INPUT);
            }
        }
        reference.drop();
        return result;
    }

    private static IElementType parseMethodCall(PhpPsiBuilder builder, IElementType result) {
        IElementType method;
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.compareAndEat(PhpPsiBuilder.QUESTION_MARKS);
            builder.advanceLexer();
            result = Variable.parseObjectProperty(builder);
        }
        if ((method = Variable.parseMethodOrNot(builder)) != PhpElementTypes.EMPTY_INPUT) {
            result = method;
        }
        return result;
    }

    public static IElementType parseArrayDeref(PhpPsiBuilder builder) {
        if (builder.compareAndEat(chLBRACE___chLBRACKET)) {
            PsiBuilder.Marker mark = builder.mark();
            Expression.parse(builder);
            mark.done(PhpElementTypes.ARRAY_INDEX);
            builder.match(chRBRACE___chRBRACKET);
            return PhpElementTypes.ARRAY_ACCESS_EXPRESSION;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseAssignable(PhpPsiBuilder builder) {
        PsiBuilder.Marker reference = builder.mark();
        IElementType result = Variable.parseBaseVariable(builder);
        while (builder.compareArrowOrNullsafeArrow()) {
            reference.done(result);
            reference = reference.precede();
            builder.compareAndEat(PhpPsiBuilder.QUESTION_MARKS);
            builder.advanceLexer();
            result = Variable.parseObjectProperty(builder);
        }
        if (builder.compare(chLBRACE___chLBRACKET)) {
            reference.done(result);
            return Variable.parseArrayDeref(builder);
        }
        reference.drop();
        return result;
    }

    private static IElementType parseMethodOrNot(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.chLPAREN)) {
            Function.parseFunctionCallParameterList(builder);
            return PhpElementTypes.METHOD_REFERENCE;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseObjectProperty(PhpPsiBuilder builder) {
        PsiBuilder.Marker objectProperty = builder.mark();
        IElementType result = Variable.parseVariableWithoutObjects(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            objectProperty.drop();
            result = Variable.parseVariableName(builder);
        } else {
            objectProperty.done(result);
        }
        if (result == PhpElementTypes.EMPTY_INPUT && !builder.compareAndEat(PhpTokenTypes.kwCLASS)) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("field.name", new Object[0])));
        }
        return PhpElementTypes.FIELD_REFERENCE;
    }

    private static IElementType parseVariableName(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            return PhpElementTypes.FIELD_REFERENCE;
        }
        if (builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
            Expression.parse(builder);
            builder.match(PhpTokenTypes.chRBRACE);
            return PhpElementTypes.FIELD_REFERENCE;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static IElementType parseBaseVariableOrFunctionCall(PhpPsiBuilder builder) {
        PsiBuilder.Marker rollback = builder.mark();
        IElementType result = Variable.parseBaseVariable(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            rollback.drop();
            result = Function.parse(builder);
        } else if (builder.compare(PhpTokenTypes.chLPAREN)) {
            rollback.rollbackTo();
            result = Function.parse(builder);
        } else {
            rollback.drop();
        }
        return result;
    }

    public static IElementType parseBaseVariable(PhpPsiBuilder builder) {
        IElementType result = PhpElementTypes.EMPTY_INPUT;
        if (builder.compare(PhpTokenTypes.chLPAREN)) {
            result = PrimaryExpression.parseParens(builder);
        }
        if (result != PhpElementTypes.PARENTHESIZED_EXPRESSION) {
            result = Variable.parseVariableWithoutObjects(builder);
        }
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = Variable.parseStaticMember(builder);
        }
        return result;
    }

    private static IElementType parseStaticMember(PhpPsiBuilder builder) {
        PsiBuilder.Marker rollback = builder.mark();
        PsiBuilder.Marker var = builder.mark();
        if (ClassReference.parse(builder) != PhpElementTypes.EMPTY_INPUT && builder.compareAndEat(PhpTokenTypes.SCOPE_RESOLUTION)) {
            PsiBuilder.Marker variable = builder.mark();
            boolean variableVariable = builder.compare(PhpTokenTypes.DOLLAR);
            IElementType result = Variable.parseVariableWithoutObjects(builder, var, PhpElementTypes.FIELD_REFERENCE);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                rollback.drop();
                if (result == PhpStubElementTypes.VARIABLE) {
                    if (variableVariable) {
                        variable.done(PhpStubElementTypes.VARIABLE);
                    } else {
                        variable.drop();
                    }
                    return PhpElementTypes.FIELD_REFERENCE;
                }
                variable.drop();
                return result;
            }
            variable.drop();
        }
        rollback.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseVariableWithoutObjects(PhpPsiBuilder builder) {
        return Variable.parseVariableWithoutObjects(builder, null, null);
    }

    public static IElementType parseVariableWithoutObjects(PhpPsiBuilder builder, @Nullable PsiBuilder.Marker variableMarker, @Nullable IElementType outerElement) {
        IElementType result = Variable.parseReferenceVariable(builder, variableMarker, outerElement);
        if (result == PhpElementTypes.EMPTY_INPUT && builder.compare(PhpTokenTypes.DOLLAR)) {
            Variable.parseSimpleIndirectReference(builder);
            PsiBuilder.Marker var = builder.mark();
            IElementType referenceVariable = Variable.parseReferenceVariable(builder);
            if (referenceVariable != PhpElementTypes.EMPTY_INPUT) {
                var.done(referenceVariable);
            } else {
                builder.error(PhpParserErrors.expected(PhpBundle.message("identifier", new Object[0])));
                var.drop();
            }
            return PhpStubElementTypes.VARIABLE;
        }
        return result;
    }

    private static void parseSimpleIndirectReference(PhpPsiBuilder builder) {
        while (builder.compare(PhpTokenTypes.DOLLAR)) {
            PsiBuilder.Marker rollback = builder.mark();
            builder.advanceLexer();
            if (builder.compare(PhpTokenTypes.chLBRACE)) {
                rollback.rollbackTo();
                break;
            }
            rollback.drop();
        }
    }

    private static IElementType parseReferenceVariable(PhpPsiBuilder builder) {
        return Variable.parseReferenceVariable(builder, null, null);
    }

    private static IElementType parseReferenceVariable(PhpPsiBuilder builder, @Nullable PsiBuilder.Marker preceder, @Nullable IElementType outerElement) {
        if (preceder == null) {
            preceder = builder.mark();
        }
        assert (preceder != null);
        IElementType result = Variable.parseCompoundVariable(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            preceder.drop();
            return result;
        }
        while (builder.compare(chLBRACE___chLBRACKET)) {
            preceder.done(outerElement == null ? result : outerElement);
            if (outerElement != null) {
                outerElement = null;
            }
            preceder = preceder.precede();
            if (builder.compare(chLBRACE___chLBRACKET)) {
                result = Variable.parseArrayAccessWithOptionalIndex(builder);
                continue;
            }
            builder.error(PhpParserErrors.unexpected(builder.getTokenType()));
        }
        preceder.drop();
        return result;
    }

    @NotNull
    public static IElementType parseArrayAccessWithOptionalIndex(PhpPsiBuilder builder) {
        boolean bracket = builder.compare(PhpTokenTypes.chLBRACKET);
        builder.advanceLexer();
        PsiBuilder.Marker arrayIndex = builder.mark();
        Variable.parseDimOffset(builder);
        arrayIndex.done(PhpElementTypes.ARRAY_INDEX);
        builder.match(bracket ? PhpTokenTypes.chRBRACKET : PhpTokenTypes.chRBRACE);
        IElementType iElementType = PhpElementTypes.ARRAY_ACCESS_EXPRESSION;
        if (iElementType == null) {
            Variable.$$$reportNull$$$0(0);
        }
        return iElementType;
    }

    private static IElementType parseCompoundVariable(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
            return PhpStubElementTypes.VARIABLE;
        }
        PsiBuilder.Marker rollback = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.DOLLAR) && builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
            rollback.drop();
            Expression.parse(builder);
            builder.match(PhpTokenTypes.chRBRACE);
            return PhpStubElementTypes.VARIABLE;
        }
        rollback.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static void parseDimOffset(PhpPsiBuilder builder) {
        Expression.parse(builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/parser/parsing/calls/Variable", "parseArrayAccessWithOptionalIndex"));
    }
}

