/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.calls;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.Namespace;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.expressions.PrimaryExpression;

public class Function {
    private static final TokenSet AFTER_SCOPE_RES = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER, PhpTokenTypes.DOLLAR, PhpTokenTypes.chLBRACE});
    private static final ParserPart PARAM_LIST_PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            IElementType expression;
            boolean optionalNameParsed = Function.parseOptionalName(builder);
            builder.compareAndEat(PhpTokenTypes.opVARIADIC);
            if (builder.compareAndEat(PhpTokenTypes.opBIT_AND)) {
                PsiBuilder.Marker var = builder.mark();
                IElementType result = Variable.parse(builder);
                if (result == PhpStubElementTypes.VARIABLE) {
                    var.done(PhpStubElementTypes.VARIABLE);
                    return result;
                }
                var.rollbackTo();
            }
            if ((expression = Expression.parse(builder)) == PhpElementTypes.EMPTY_INPUT && optionalNameParsed) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
                return PhpElementTypes.EXPRESSION;
            }
            return expression;
        }
    };

    private static boolean parseOptionalName(PhpPsiBuilder builder) {
        PsiBuilder.Marker nameIdentifier = builder.mark();
        if (Function.eatNamedArgumentPart(builder)) {
            nameIdentifier.drop();
            return true;
        }
        nameIdentifier.rollbackTo();
        return false;
    }

    private static boolean eatNamedArgumentPart(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.tsKEYWORDS) && builder.lookAhead() == PhpTokenTypes.opCOLON) {
            builder.remapToIdentifier();
            builder.advanceLexer();
            builder.advanceLexer();
            return true;
        }
        return builder.compareAndEat(PhpTokenTypes.IDENTIFIER) && builder.compareAndEat(PhpTokenTypes.opCOLON);
    }

    public static IElementType tryToParseDefine(PhpPsiBuilder builder) {
        String text;
        PsiBuilder.Marker functionCall = builder.mark();
        PsiBuilder.Marker namespace = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.NAMESPACE_RESOLUTION)) {
            namespace.done(PhpElementTypes.NS_REFERENCE);
        } else {
            namespace.drop();
        }
        if (builder.compare(PhpTokenTypes.IDENTIFIER) && (text = builder.getTokenText()) != null && text.equalsIgnoreCase("define")) {
            builder.advanceLexer();
            if (builder.compare(PhpTokenTypes.chLPAREN)) {
                Function.parseFunctionCallParameterList(builder);
                functionCall.done(PhpElementTypes.FUNCTION_CALL);
                return PhpStubElementTypes.DEFINE;
            }
        }
        functionCall.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result = Function.tryToParseDefine(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        PsiBuilder.Marker variable = builder.mark();
        result = Variable.parseVariableWithoutObjects(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            variable.done(result);
            Function.parseFunctionCallParameterList(builder);
            return PhpElementTypes.FUNCTION_CALL;
        }
        variable.drop();
        PsiBuilder.Marker rollback = builder.mark();
        Namespace.parseReference(builder);
        if (builder.compare(PhpTokenTypes.IDENTIFIER) || builder.compare(PhpTokenTypes.kwSTATIC) || builder.compare(PhpTokenTypes.chLPAREN)) {
            if (builder.compare(PhpTokenTypes.chLPAREN)) {
                PsiBuilder.Marker parens = builder.mark();
                IElementType parse = PrimaryExpression.parseParens(builder);
                if (parse == PhpElementTypes.PARENTHESIZED_EXPRESSION) {
                    parens.done(PhpElementTypes.PARENTHESIZED_EXPRESSION);
                } else {
                    parens.rollbackTo();
                }
            } else {
                builder.advanceLexer();
            }
            if (builder.compare(PhpTokenTypes.chLPAREN)) {
                rollback.drop();
                Function.parseFunctionCallParameterList(builder);
                return PhpElementTypes.FUNCTION_CALL;
            }
            if (!builder.compare(PhpTokenTypes.SCOPE_RESOLUTION)) {
                rollback.rollbackTo();
                return PhpElementTypes.EMPTY_INPUT;
            }
            rollback.rollbackTo();
            rollback = builder.mark();
            ClassReference.parse(builder);
            builder.match(PhpTokenTypes.SCOPE_RESOLUTION);
            if (builder.compareAndEat(PhpTokenTypes.tsKEYWORDS)) {
                rollback.drop();
                if (builder.compare(PhpTokenTypes.chLPAREN)) {
                    Function.parseFunctionCallParameterList(builder);
                    return PhpElementTypes.METHOD_REFERENCE;
                }
                return PhpElementTypes.CLASS_CONSTANT_REFERENCE;
            }
            if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
                if (builder.compare(PhpTokenTypes.chLPAREN)) {
                    rollback.drop();
                    Function.parseFunctionCallParameterList(builder);
                    return PhpElementTypes.METHOD_REFERENCE;
                }
                rollback.rollbackTo();
                return PhpElementTypes.EMPTY_INPUT;
            }
            if (builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
                IElementType parse = Expression.parse(builder);
                if (parse == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpBundle.message("expression1", new Object[0])));
                }
                builder.match(PhpTokenTypes.chRBRACE);
                if (builder.compare(PhpTokenTypes.chLPAREN)) {
                    rollback.drop();
                    Function.parseFunctionCallParameterList(builder);
                    return PhpElementTypes.METHOD_REFERENCE;
                }
            } else {
                rollback.drop();
                variable = builder.mark();
                result = Variable.parseVariableWithoutObjects(builder);
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(AFTER_SCOPE_RES));
                }
                variable.done(result);
                Function.parseFunctionCallParameterList(builder);
                return PhpElementTypes.METHOD_REFERENCE;
            }
        }
        rollback.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static void parseFunctionCallParameterList(PhpPsiBuilder builder) {
        builder.match(PhpTokenTypes.chLPAREN);
        PsiBuilder.Marker paramList = builder.mark();
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, PARAM_LIST_PARSER_PART.parse(builder), PARAM_LIST_PARSER_PART, true);
        if (builder.compareAndEat(PhpTokenTypes.opCOMMA)) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        paramList.done(PhpElementTypes.PARAMETER_LIST);
        builder.match(PhpTokenTypes.chRPAREN);
    }
}

