/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeDeclaration {
    public static IElementType parseType(PhpPsiBuilder builder, @NotNull IElementType typeDeclarationToken) {
        if (typeDeclarationToken == null) {
            TypeDeclaration.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker typeDeclaration = builder.mark();
        boolean isNullableType = builder.compareAndEat(PhpTokenTypes.opQUEST);
        int numberOfClassReferences = ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, TypeDeclaration.parseSimpleType(builder), b -> {
            b.compareAndEat(PhpTokenTypes.opQUEST);
            return TypeDeclaration.parseSimpleType(b);
        }, PhpTokenTypes.opBIT_OR, false, false);
        if (numberOfClassReferences == 0) {
            if (isNullableType) {
                typeDeclaration.done(typeDeclarationToken);
                builder.error(PhpParserErrors.expected(PhpBundle.message("type", new Object[0])));
                return PhpTokenTypes.opQUEST;
            }
            typeDeclaration.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
        if (numberOfClassReferences > 0 && builder.compareAndEat(PhpTokenTypes.opBIT_OR)) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("type", new Object[0])));
        }
        typeDeclaration.done(typeDeclarationToken);
        return typeDeclarationToken;
    }

    public static IElementType parseSimpleType(PhpPsiBuilder builder) {
        IElementType classReference;
        if (builder.compare(PhpTokenTypes.kwARRAY) || builder.compare(PhpTokenTypes.kwCALLABLE)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done(PhpElementTypes.CLASS_REFERENCE);
            classReference = PhpElementTypes.CLASS_REFERENCE;
        } else {
            classReference = ClassReference.parse(builder);
        }
        TypeDeclaration.parseBrackets(builder);
        return classReference;
    }

    private static void parseBrackets(@NotNull PhpPsiBuilder builder) {
        PsiBuilder.Marker mark;
        if (builder == null) {
            TypeDeclaration.$$$reportNull$$$0(1);
        }
        while (true) {
            mark = builder.mark();
            if (!builder.compareAndEat(PhpTokenTypes.chLBRACKET)) break;
            if (!builder.compareAndEat(PhpTokenTypes.chRBRACKET)) {
                mark.precede().error(PhpParserErrors.unexpected(PhpTokenTypes.chLBRACKET));
            }
            mark.drop();
        }
        mark.drop();
    }

    public static boolean isTypeDeclaration(@Nullable IElementType elementType) {
        return elementType == PhpElementTypes.PARAMETER_TYPE || elementType == PhpElementTypes.RETURN_TYPE || elementType == PhpElementTypes.FIELD_TYPE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclarationToken";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/parser/parsing/TypeDeclaration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseBrackets";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

