/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpParserException;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPsiBuilder {
    private static final int FACTOR = PhpPsiBuilder.isEapOrUnitTestMode() ? 1000 : 10000;
    @NotNull
    public static final TokenSet QUESTION_MARKS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opQUEST, PhpTokenTypes.opCOALESCE});
    private final boolean myArrowFunctionSyntaxSupported;
    private final boolean myMatchExpressionSupported;
    private final boolean myAttributesSupported;
    private final IntSet myRemappedFnTokenIndices;
    private final PsiBuilder psiBuilder;
    private final int myAllowedAdvanceCount;
    private int myAdvanceCount;

    public boolean compareArrowOrNullsafeArrow() {
        if (this.compare(PhpTokenTypes.ARROW)) {
            return true;
        }
        return this.compare(QUESTION_MARKS) && this.rawLookup(1) == PhpTokenTypes.ARROW;
    }

    public boolean attributesSupported() {
        return this.myAttributesSupported;
    }

    public boolean endOfLineRawToken() {
        int textEnd;
        int start = this.psiBuilder.rawTokenTypeStart(0);
        if (start == (textEnd = this.psiBuilder.getOriginalText().length())) {
            return true;
        }
        int end = this.psiBuilder.rawTokenTypeStart(1);
        CharSequence tokenText = this.psiBuilder.getOriginalText().subSequence(start, end);
        return StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"\n") || StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"\r") || StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"?>");
    }

    private static boolean isEapOrUnitTestMode() {
        return ApplicationManager.getApplication().isEAP() || ApplicationManager.getApplication().isUnitTestMode();
    }

    public PhpPsiBuilder(@Nullable Project project, @NotNull PsiBuilder builder) {
        if (builder == null) {
            PhpPsiBuilder.$$$reportNull$$$0(0);
        }
        this.myRemappedFnTokenIndices = new IntOpenHashSet();
        this.psiBuilder = builder;
        int allowedAdvanceCount = PhpPsiBuilder.getLexemeCount(builder) * FACTOR;
        this.myAllowedAdvanceCount = allowedAdvanceCount > 0 ? allowedAdvanceCount : Integer.MAX_VALUE;
        this.myArrowFunctionSyntaxSupported = project != null && PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(project);
        this.myMatchExpressionSupported = project != null && PhpLanguageFeature.MATCH_EXPRESSION.isSupported(project);
        this.myAttributesSupported = project != null && PhpLanguageFeature.ATTRIBUTES.isSupported(project);
    }

    private static int getLexemeCount(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PhpPsiBuilder.$$$reportNull$$$0(1);
        }
        return builder instanceof PsiBuilderImpl ? ((PsiBuilderImpl)builder).getLexemeCount() : 0;
    }

    public boolean compare(IElementType type) {
        return this.getTokenType() == type;
    }

    public boolean compare(TokenSet types) {
        return types.contains(this.getTokenType());
    }

    public IElementType rawLookup(int steps) {
        return this.psiBuilder.rawLookup(steps);
    }

    public IElementType lookAhead() {
        return this.psiBuilder.lookAhead(1);
    }

    public boolean compareAndEat(IElementType type) {
        boolean found = this.compare(type);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    public boolean compareAndEat(TokenSet types) {
        boolean found = this.compare(types);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    public void match(IElementType token) {
        if (!this.compareAndEat(token)) {
            this.error(PhpParserErrors.expected(token));
        }
    }

    public void match(IElementType token, @NotNull @NlsContexts.ParsingError String errorMessage) {
        if (errorMessage == null) {
            PhpPsiBuilder.$$$reportNull$$$0(2);
        }
        if (!this.compareAndEat(token)) {
            this.error(errorMessage);
        }
    }

    public void match(TokenSet tokens) {
        if (!this.compareAndEat(tokens)) {
            this.error(PhpParserErrors.expected(tokens));
        }
    }

    public void match(TokenSet tokens, @NotNull @NlsContexts.ParsingError String errorMessage) {
        if (errorMessage == null) {
            PhpPsiBuilder.$$$reportNull$$$0(3);
        }
        if (!this.compareAndEat(tokens)) {
            this.error(errorMessage);
        }
    }

    public void advanceLexer() {
        ++this.myAdvanceCount;
        this.psiBuilder.advanceLexer();
    }

    public PsiBuilder.Marker mark() {
        return this.psiBuilder.mark();
    }

    public void error(@NotNull @NlsContexts.ParsingError String errorMessage) {
        if (errorMessage == null) {
            PhpPsiBuilder.$$$reportNull$$$0(4);
        }
        this.psiBuilder.error(errorMessage);
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myAdvanceCount > this.myAllowedAdvanceCount || this.myAdvanceCount < 0) {
            Attachment attachment = new Attachment("unparseable.php", this.psiBuilder.getOriginalText().toString());
            throw new PhpParserException("Lexer has been advanced " + (this.myAdvanceCount > 0 ? this.myAdvanceCount : Integer.MAX_VALUE) + " times while the amount of lexeme is " + PhpPsiBuilder.getLexemeCount(this.psiBuilder), attachment);
        }
        IElementType tokenType = this.psiBuilder.getTokenType();
        if (tokenType == PhpTokenTypes.kwFN && !this.myArrowFunctionSyntaxSupported) {
            this.myRemappedFnTokenIndices.add(this.psiBuilder.rawTokenIndex());
            this.psiBuilder.remapCurrentToken(PhpTokenTypes.IDENTIFIER);
            return PhpTokenTypes.IDENTIFIER;
        }
        return tokenType;
    }

    public boolean compareFnWithoutRemapping() {
        IElementType tokenType = this.getTokenType();
        return tokenType == PhpTokenTypes.kwFN || this.isCurrentTokenRemappedFromFn(tokenType);
    }

    private boolean isCurrentTokenRemappedFromFn(IElementType tokenType) {
        if (this.myArrowFunctionSyntaxSupported) {
            return false;
        }
        return tokenType == PhpTokenTypes.IDENTIFIER && this.myRemappedFnTokenIndices.contains(this.psiBuilder.rawTokenIndex());
    }

    public void remapBackToFnIfNeeded() {
        if (this.myArrowFunctionSyntaxSupported) {
            return;
        }
        IElementType tokenType = this.getTokenType();
        if (this.isCurrentTokenRemappedFromFn(tokenType)) {
            this.psiBuilder.remapCurrentToken(PhpTokenTypes.kwFN);
            this.myRemappedFnTokenIndices.remove(this.psiBuilder.rawTokenIndex());
        }
    }

    @Nullable
    @NlsSafe
    public String getTokenText() {
        return this.psiBuilder.getTokenText();
    }

    public boolean eof() {
        return this.psiBuilder.eof();
    }

    public ASTNode getTreeBuilt() {
        return this.psiBuilder.getTreeBuilt();
    }

    public int getCurrentOffset() {
        return this.psiBuilder.getCurrentOffset();
    }

    public boolean arrowFunctionSyntaxSupported() {
        return this.myArrowFunctionSyntaxSupported;
    }

    public boolean matchExpressionSupported() {
        return this.myMatchExpressionSupported;
    }

    public void remapCurrentTokenWithDocQuestion() {
        this.psiBuilder.remapCurrentToken(PhpDocTokenTypes.DOC_QUESTION_MARK);
    }

    public void remapToIdentifier() {
        this.psiBuilder.remapCurrentToken(PhpTokenTypes.IDENTIFIER);
    }

    public void remapToMatchKeyword() {
        this.psiBuilder.remapCurrentToken(PhpTokenTypes.kwMATCH);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/parser/PhpPsiBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLexemeCount";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

