/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.jetbrains.php.PhpBundle;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpParserErrors {
    private static final Map<String, String> expectedCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> unexpectedCache = new ConcurrentHashMap<String, String>();
    private static final Map<TokenSet, CharSequence> errorCache = new ConcurrentHashMap<TokenSet, CharSequence>();
    private static final CharTable CHAR_TABLE = new CharTableImpl();

    private PhpParserErrors() {
    }

    @NlsContexts.ParsingError
    @NotNull
    public static String expected(@Nls String s) {
        String string = expectedCache.computeIfAbsent(s, k -> PhpBundle.message("parser.expected", s));
        if (string == null) {
            PhpParserErrors.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsContexts.ParsingError
    @NotNull
    private static String unexpected(@NotNull String s) {
        if (s == null) {
            PhpParserErrors.$$$reportNull$$$0(1);
        }
        String string = unexpectedCache.computeIfAbsent(s, k -> PhpBundle.message("parser.unexpected", s));
        if (string == null) {
            PhpParserErrors.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Nls
    @NlsContexts.ParsingError
    public static String expected(IElementType type) {
        return PhpParserErrors.expected(PhpParserErrors.getPresentableName(type));
    }

    @NotNull
    @NlsSafe
    private static String getPresentableName(IElementType type) {
        return type != null ? type.toString() : "";
    }

    @NotNull
    @NlsContexts.ParsingError
    public static String unexpected(IElementType type) {
        return PhpParserErrors.unexpected(PhpParserErrors.getPresentableName(type));
    }

    @NotNull
    @NlsContexts.ParsingError
    public static String expected(TokenSet types) {
        String string = PhpBundle.message("parser.expected", PhpParserErrors.setToString(types));
        if (string == null) {
            PhpParserErrors.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static CharSequence setToString(@NotNull TokenSet set) {
        CharSequence cachedString;
        if (set == null) {
            PhpParserErrors.$$$reportNull$$$0(4);
        }
        if ((cachedString = errorCache.get(set)) != null) {
            CharSequence charSequence = cachedString;
            if (charSequence == null) {
                PhpParserErrors.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        THashSet stringSet = new THashSet();
        StringBuilder buffer = new StringBuilder();
        for (IElementType myToken : set.getTypes()) {
            String tokenText = PhpParserErrors.getPresentableName(myToken);
            if (tokenText.length() == 0 || !stringSet.add(tokenText)) continue;
            if (buffer.length() != 0) {
                buffer.append(" or ");
            }
            buffer.append(tokenText);
        }
        String errorString = buffer.toString();
        errorCache.put(set, CHAR_TABLE.intern((CharSequence)errorString));
        String string = errorString;
        if (string == null) {
            PhpParserErrors.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    public static String getExpressionExpectedMessage() {
        return PhpBundle.message("expected.expression", new Object[0]);
    }

    @Nls
    public static String getClassReferenceExpectedMessage() {
        return PhpBundle.message("expected.class.reference", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/parser/PhpParserErrors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "expected";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/parser/PhpParserErrors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unexpected";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setToString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unexpected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

