/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.surround;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.util.PhpTrimRendererVisitor;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpSurroundWithCallBaseIntention
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(PhpSurroundWithCallBaseIntention.class);

    @NotNull
    @NlsSafe
    protected abstract String getCalleeName();

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("surround.with.0", this.getCalleeName());
        if (string == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        PsiElement expressionToSurround;
        if (project == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(3);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        Statement statement = (Statement)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (!PhpLangUtil.isShortEchoTagStatement((PsiElement)statement) && (expressionToSurround = this.getExpressionToSurround(element)) != null) {
            PhpTrimRendererVisitor trimRendererVisitor = new PhpTrimRendererVisitor(15, 5);
            expressionToSurround.accept((PsiElementVisitor)trimRendererVisitor);
            if (expressionToSurround instanceof RWAccess) {
                if (!((RWAccess)expressionToSurround).isWriteAccess()) {
                    this.setText(PhpSurroundWithCallBaseIntention.createText(this.getCalleeName(), trimRendererVisitor.toString()));
                    return true;
                }
            } else {
                this.setText(PhpSurroundWithCallBaseIntention.createText(this.getCalleeName(), trimRendererVisitor.toString()));
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Nls
    private static String createText(@NotNull String calleeName, @NotNull String text) {
        if (calleeName == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(4);
        }
        if (text == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(5);
        }
        String string = PhpBundle.message("surround.with.if.0.1", calleeName, text);
        if (string == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    protected PsiElement getExpressionToSurround(@NotNull PsiElement element) {
        Variable variable;
        if (element == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(7);
        }
        if ((variable = PhpSurroundWithCallBaseIntention.findCleanElementAt(element, Variable.class)) != null) {
            PsiElement[] children = variable.getChildren();
            if (PhpSurroundWithCallBaseIntention.isFieldReference(variable, children)) {
                return children[0];
            }
            return variable;
        }
        ArrayAccessExpression arrayExpression = PhpSurroundWithCallBaseIntention.findCleanElementAt(element, ArrayAccessExpression.class);
        if (arrayExpression != null) {
            return arrayExpression;
        }
        FieldReference fieldReference = PhpSurroundWithCallBaseIntention.findCleanElementAt(element, FieldReference.class);
        if (fieldReference != null) {
            return fieldReference;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T findCleanElementAt(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        PsiElement parent;
        if (element == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(8);
        }
        if (aClass == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(9);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)element, aClass, (boolean)false)) != null && !PsiTreeUtil.hasErrorElements((PsiElement)parent)) {
            return (T)parent;
        }
        return null;
    }

    private static boolean isFieldReference(@NotNull Variable variable, PsiElement @NotNull [] children) {
        if (variable == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(10);
        }
        if (children == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(11);
        }
        return variable.getParent() instanceof StringLiteralExpression && children.length == 1 && children[0] instanceof FieldReference;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(13);
        }
        if (element == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(14);
        }
        PsiElement expressionToSurround = this.getExpressionToSurround(element);
        assert (expressionToSurround != null);
        String text = "if(" + this.getCalleeName() + "(" + PhpSurroundWithCallBaseIntention.getExpressionText(expressionToSurround) + ")){\necho 1;\n}\n";
        Statement ifStatement = PhpPsiElementFactory.createStatement(project, text);
        Statement outerStatement = (Statement)PsiTreeUtil.getParentOfType((PsiElement)expressionToSurround, Statement.class);
        if (outerStatement == null) {
            PhpSurroundWithCallBaseIntention.showErrorMessage(project, editor, PhpBundle.message("intention.can.not.find.statement.to.surround", new Object[0]));
            return;
        }
        PsiElement outerStatementCopy = outerStatement.copy();
        PhpEchoStatement echoStatement = (PhpEchoStatement)PsiTreeUtil.findChildOfType((PsiElement)(ifStatement = outerStatement.replace((PsiElement)ifStatement)), PhpEchoStatement.class);
        if (echoStatement == null) {
            ifStatement.replace(outerStatementCopy);
            PhpSurroundWithCallBaseIntention.showErrorMessage(project, editor, PhpBundle.message("intention.statement.to.surround.failed.message", this.getCalleeName()));
            LOG.error("Can not find place to insert code in if statement: '" + text + "'");
            return;
        }
        echoStatement.replace(outerStatementCopy);
    }

    private static String getExpressionText(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(15);
        }
        if (expression instanceof Variable) {
            return "$" + ((Variable)expression).getName();
        }
        return expression.getText();
    }

    private static void showErrorMessage(@NotNull Project project, @NotNull Editor editor, @NotNull @NlsContexts.DialogMessage String message) {
        if (project == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(17);
        }
        if (message == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editor.getComponent().getRootPane() == null) {
                Messages.showMessageDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            } else {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/surround/PhpSurroundWithCallBaseIntention";
                break;
            }
            case 1: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/surround/PhpSurroundWithCallBaseIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionToSurround";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCleanElementAt";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFieldReference";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionText";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

