/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings.converters;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.intentions.strings.converters.PhpLazyStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringLiteralLazyStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptorImpl;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringRepresentationConverter;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpolationStringRepresentationConverter
implements PhpStringRepresentationConverter<StringLiteralExpression> {
    public static final PhpInterpolationStringRepresentationConverter INSTANCE = new PhpInterpolationStringRepresentationConverter();

    @Override
    @NotNull
    public List<PhpStringPartDescriptor> getStringParts(@NotNull StringLiteralExpression string, @Nullable Editor editor) {
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(0);
        }
        SmartList result = new SmartList();
        boolean singleQuote = string.isSingleQuote();
        for (PsiElement child = string.getFirstChild(); child != null; child = child.getNextSibling()) {
            Project project = string.getProject();
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.HEREDOC_CONTENTS)) {
                String childText = child.getText();
                result.add(new PhpStringLiteralLazyStringPartDescriptor(project, childText, singleQuote));
                continue;
            }
            if (!(child instanceof Variable)) continue;
            PhpPsiElement innerExpression = ((Variable)child).getFirstPsiChild();
            if (innerExpression != null) {
                if (PhpPsiUtil.isOfType(child.getFirstChild(), PhpTokenTypes.DOLLAR_LBRACE) && innerExpression instanceof ArrayAccessExpression) {
                    result.add(new PhpLazyStringPartDescriptor(() -> PhpPsiElementFactory.createPhpPsiFromText(project, ArrayAccessExpression.class, "$" + innerExpression.getText()), ArrayAccessExpression.class, PhpElementTypes.ARRAY_ACCESS_EXPRESSION));
                    continue;
                }
                result.add(new PhpStringPartDescriptorImpl((PsiElement)innerExpression));
                continue;
            }
            String name = ((Variable)child).getName();
            result.add(new PhpLazyStringPartDescriptor((Supplier<? extends PsiElement>)((Supplier<PsiElement>)() -> PhpPsiElementFactory.createVariable(project, name, true)), (Class<? extends PsiElement>)Variable.class, (IElementType)PhpStubElementTypes.VARIABLE));
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    @Override
    public boolean isAvailable(@NotNull StringLiteralExpression string, @Nullable Editor editor) {
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(2);
        }
        return !string.isSingleQuote() && PhpPsiUtil.getChildByCondition((PsiElement)string, (Condition<? super PsiElement>)Variable.INSTANCEOF) != null;
    }

    @Override
    @NotNull
    public StringLiteralExpression createExpression(@NotNull Project project, @NotNull List<PsiElement> parts) {
        if (project == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(3);
        }
        if (parts == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(4);
        }
        boolean useSingleQuote = PhpInterpolationStringRepresentationConverter.allLiteralsAreSingleQuoted(parts);
        StringLiteralExpression stringLiteralExpression = PhpPsiElementFactory.createStringLiteralExpression(project, PhpInterpolationStringRepresentationConverter.createExpressionContent(parts, useSingleQuote), useSingleQuote);
        if (stringLiteralExpression == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(5);
        }
        return stringLiteralExpression;
    }

    @NotNull
    public static String createExpressionContent(@NotNull List<? extends PsiElement> parts) {
        if (parts == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(6);
        }
        return PhpInterpolationStringRepresentationConverter.createExpressionContent(parts, PhpInterpolationStringRepresentationConverter.allLiteralsAreSingleQuoted(parts));
    }

    @NotNull
    private static String createExpressionContent(@NotNull List<? extends PsiElement> parts, boolean useSingleQuote) {
        if (parts == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(7);
        }
        String string = StreamEx.of(parts).map(e -> PhpInterpolationStringRepresentationConverter.getContentForInterpolation(e, useSingleQuote)).joining();
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static boolean allLiteralsAreSingleQuoted(@NotNull List<? extends PsiElement> parts) {
        if (parts == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(9);
        }
        if (!parts.stream().allMatch(StringLiteralExpression.class::isInstance)) {
            return false;
        }
        List singleQuotes = (List)((StreamEx)((StreamEx)StreamEx.of(parts).select(StringLiteralExpression.class).map(StringLiteralExpression::isSingleQuote).distinct()).limit(2L)).collect(Collectors.toList());
        return singleQuotes.size() == 1 && (Boolean)singleQuotes.get(0) != false;
    }

    @Override
    @Nullable
    public StringLiteralExpression getTargetElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(10);
        }
        return (StringLiteralExpression)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
    }

    @NotNull
    private static String getContentForInterpolation(@NotNull PsiElement e, boolean useSingleQuote) {
        if (e == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(11);
        }
        if (e instanceof StringLiteralExpression) {
            if (!useSingleQuote && ((StringLiteralExpression)e).isSingleQuote()) {
                String string = PhpReplaceQuotesIntention.createLiteralWithChangedQuotes((StringLiteralExpression)e).getContents();
                if (string == null) {
                    PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(12);
                }
                return string;
            }
            String string = ((StringLiteralExpression)e).getContents();
            if (string == null) {
                PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (PhpPsiUtil.isOfType(e, PhpElementTypes.NUMBER)) {
            String string = PhpPsiUtil.getLiteralText(e);
            if (string == null) {
                PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = String.format("{%s}", e.getText());
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/converters/PhpInterpolationStringRepresentationConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/converters/PhpInterpolationStringRepresentationConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringParts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionContent";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentForInterpolation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringParts";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allLiteralsAreSingleQuoted";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContentForInterpolation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

