/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.intentions.strings.PhpConvertStringRepresentationIntentionBase;
import com.jetbrains.php.lang.intentions.strings.converters.PhpConcatenationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpInterpolationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringLiteralLazyStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringRepresentationPartsSupplier;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractSelectedStringPartAsConcatenationOperandIntention
extends PhpConvertStringRepresentationIntentionBase<StringLiteralExpression, BinaryExpression> {
    @Override
    protected PhpStringRepresentationPartsSupplier<StringLiteralExpression> getFromRepresentationPartsSupplier() {
        return PhpExtractSelectedStringPartStringRepresentationPartsSupplier.INSTANCE;
    }

    @Override
    protected boolean isAvailable(Project project, StringLiteralExpression targetElement, List<PhpStringPartDescriptor> parts) {
        return super.isAvailable(project, targetElement, parts) && parts.size() > 1;
    }

    @Override
    protected PhpStringRepresentationConverter<BinaryExpression> getToConverter() {
        return PhpConcatenationStringRepresentationConverter.INSTANCE;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("extract.selected.string.part.as.concatenation.operand", new Object[0]);
        if (string == null) {
            PhpExtractSelectedStringPartAsConcatenationOperandIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpExtractSelectedStringPartAsConcatenationOperandIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static TextRange getSelectionRange(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getCurrentCaret();
        return caret.hasSelection() ? TextRange.create((int)caret.getSelectionStart(), (int)caret.getSelectionEnd()) : null;
    }

    @NotNull
    public static TextRange getAbsoluteValueRange(@NotNull StringLiteralExpression element) {
        if (element == null) {
            PhpExtractSelectedStringPartAsConcatenationOperandIntention.$$$reportNull$$$0(2);
        }
        TextRange textRange = element.getValueRange().shiftRight(element.getTextRange().getStartOffset());
        if (textRange == null) {
            PhpExtractSelectedStringPartAsConcatenationOperandIntention.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public static boolean selectionRangeIntersectsStringVariables(@NotNull StringLiteralExpression element, @NotNull TextRange selectionRange) {
        if (element == null) {
            PhpExtractSelectedStringPartAsConcatenationOperandIntention.$$$reportNull$$$0(4);
        }
        if (selectionRange == null) {
            PhpExtractSelectedStringPartAsConcatenationOperandIntention.$$$reportNull$$$0(5);
        }
        return PhpPsiUtil.getChildren((PsiElement)element, (Condition<? super PsiElement>)Variable.INSTANCEOF).stream().map(PsiElement::getTextRange).anyMatch(variableRange -> !selectionRange.contains(variableRange) && selectionRange.intersectsStrict(variableRange));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/PhpExtractSelectedStringPartAsConcatenationOperandIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/PhpExtractSelectedStringPartAsConcatenationOperandIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteValueRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteValueRange";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectionRangeIntersectsStringVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpExtractSelectedStringPartStringRepresentationPartsSupplier
    implements PhpStringRepresentationPartsSupplier<StringLiteralExpression> {
        static final PhpStringRepresentationPartsSupplier<StringLiteralExpression> INSTANCE = new PhpExtractSelectedStringPartStringRepresentationPartsSupplier();

        private PhpExtractSelectedStringPartStringRepresentationPartsSupplier() {
        }

        @Override
        @NotNull
        public List<PhpStringPartDescriptor> getStringParts(@NotNull StringLiteralExpression element, @Nullable Editor editor) {
            TextRange selectionRangeRelativeToElement;
            if (element == null) {
                PhpExtractSelectedStringPartStringRepresentationPartsSupplier.$$$reportNull$$$0(0);
            }
            SmartList result = new SmartList();
            TextRange selectionRange = PhpExtractSelectedStringPartAsConcatenationOperandIntention.getSelectionRange(editor);
            TextRange textRange = selectionRangeRelativeToElement = selectionRange != null ? selectionRange.shiftLeft(PhpExtractSelectedStringPartAsConcatenationOperandIntention.getAbsoluteValueRange(element).getStartOffset()) : null;
            if (selectionRangeRelativeToElement != null) {
                String contents = element.getContents();
                Project project = element.getProject();
                boolean singleQuote = element.isSingleQuote();
                if (selectionRangeRelativeToElement.getStartOffset() > 0) {
                    result.add(new PhpStringLiteralLazyStringPartDescriptor(project, contents.substring(0, selectionRangeRelativeToElement.getStartOffset()), singleQuote));
                }
                result.add(new PhpStringLiteralLazyStringPartDescriptor(project, selectionRangeRelativeToElement.substring(contents), singleQuote));
                if (selectionRangeRelativeToElement.getEndOffset() < contents.length()) {
                    result.add(new PhpStringLiteralLazyStringPartDescriptor(project, contents.substring(selectionRangeRelativeToElement.getEndOffset()), singleQuote));
                }
            }
            SmartList smartList = result;
            if (smartList == null) {
                PhpExtractSelectedStringPartStringRepresentationPartsSupplier.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        @Override
        public boolean isAvailable(@NotNull StringLiteralExpression element, @Nullable Editor editor) {
            TextRange selectionRange;
            if (element == null) {
                PhpExtractSelectedStringPartStringRepresentationPartsSupplier.$$$reportNull$$$0(2);
            }
            if ((selectionRange = PhpExtractSelectedStringPartAsConcatenationOperandIntention.getSelectionRange(editor)) == null || !PhpExtractSelectedStringPartAsConcatenationOperandIntention.getAbsoluteValueRange(element).contains(selectionRange)) {
                return false;
            }
            if (element.isHeredoc() || PhpHeredocToStringIntention.isNowdoc((PsiElement)element)) {
                return false;
            }
            return !PhpExtractSelectedStringPartAsConcatenationOperandIntention.selectionRangeIntersectsStringVariables(element, selectionRange);
        }

        @Override
        @Nullable
        public StringLiteralExpression getTargetElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpExtractSelectedStringPartStringRepresentationPartsSupplier.$$$reportNull$$$0(3);
            }
            return PhpInterpolationStringRepresentationConverter.INSTANCE.getTargetElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/PhpExtractSelectedStringPartAsConcatenationOperandIntention$PhpExtractSelectedStringPartStringRepresentationPartsSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/PhpExtractSelectedStringPartAsConcatenationOperandIntention$PhpExtractSelectedStringPartStringRepresentationPartsSupplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringParts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getStringParts";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargetElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

