/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.intentions.strings.converters.PhpConcatenationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.PhpStringUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpCopyConcatenatedStringToClipboardIntention
extends BaseElementAtCaretIntentionAction {
    private static final String UNKNOWN_EXPRESSION_SYMBOL = "?";
    private static final PhpConcatenationStringRepresentationConverter CONVERTER = PhpConcatenationStringRepresentationConverter.INSTANCE;

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        BinaryExpression expression;
        if (project == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(1);
        }
        return (expression = CONVERTER.getTargetElement(element)) != null && CONVERTER.isAvailable(expression, editor);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        BinaryExpression expression;
        if (project == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(3);
        }
        if ((expression = CONVERTER.getTargetElement(element)) != null) {
            String concatenationResult = StreamEx.of(CONVERTER.getStringParts(expression, editor)).map(PhpStringPartDescriptor::getElement).map(PhpCopyConcatenatedStringToClipboardIntention::resolveConstantDefaultValue).map(PhpCopyConcatenatedStringToClipboardIntention::getContentForClipboard).joining();
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(concatenationResult));
        }
    }

    @NotNull
    private static PsiElement resolveConstantDefaultValue(@NotNull PsiElement element) {
        Field field;
        PsiElement value;
        Constant constant;
        if (element == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(4);
        }
        if (element instanceof ConstantReference && (constant = (Constant)ObjectUtils.tryCast((Object)((ConstantReference)element).resolve(), Constant.class)) != null && (value = constant.getValue()) != null) {
            PsiElement psiElement = value;
            if (psiElement == null) {
                PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        if (element instanceof ClassConstantReference && (field = (Field)ObjectUtils.tryCast((Object)((ClassConstantReference)element).resolve(), Field.class)) != null && (value = field.getDefaultValue()) != null) {
            PsiElement psiElement = value;
            if (psiElement == null) {
                PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(6);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    private static String getContentForClipboard(PsiElement element) {
        return element instanceof StringLiteralExpression ? PhpStringUtil.unescapeText(((StringLiteralExpression)element).getContents(), false, new String[0]) : UNKNOWN_EXPRESSION_SYMBOL;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("copy.concatenated.string.to.clipboard", new Object[0]);
        if (string == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PhpBundle.message("copy.concatenated.string.to.clipboard", new Object[0]);
        if (string == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/PhpCopyConcatenatedStringToClipboardIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/PhpCopyConcatenatedStringToClipboardIntention";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstantDefaultValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstantDefaultValue";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

