/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.stringDoc;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.intentions.strings.PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.rename.PhpHeredocRenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStringToHeredocIntention
extends PsiElementBaseIntentionAction {
    private static final String SINGLE_QUOTE = "'";
    public static final String SLASH = "\\";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String HEREDOC_BEGIN = "<<<";

    @Nullable
    static PsiElement hasSemicolon(PsiElement expression) {
        int nextElementOffset;
        PsiFile file = expression.getContainingFile();
        PsiElement nextElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)(nextElementOffset = expression.getTextRange().getEndOffset()));
        if (nextElement instanceof PsiWhiteSpace) {
            int end = nextElement.getTextRange().getEndOffset();
            nextElement = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)end);
        }
        if (PhpPsiUtil.isOfType(nextElement, PhpTokenTypes.opSEMICOLON)) {
            return nextElement;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        boolean doubleQuoted;
        if (project == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(1);
        }
        String name = "TAG";
        ASTNode node = element.getNode();
        if (PhpPsiUtil.isOfType(node, PhpTokenTypes.chRSINGLE_QUOTE)) {
            element = element.getPrevSibling();
        }
        boolean isSingleQuoted = PhpPsiUtil.isOfType(element, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, PhpTokenTypes.chLSINGLE_QUOTE);
        StringLiteralExpression stringExpression = PhpStringToHeredocIntention.getStringExpression(element);
        boolean bl = doubleQuoted = PhpPsiUtil.isOfType(element, PhpTokenTypes.STRING_LITERAL) || PhpStringToHeredocIntention.stringLiteral(element, PhpTokenTypes.STRING_LITERAL, (PsiElement)stringExpression);
        if (isSingleQuoted || doubleQuoted) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                name = this.getName(project, name, (PsiElement)stringExpression, doubleQuoted);
            }
            if (name != null && stringExpression != null) {
                String docChar;
                String text = stringExpression.getText();
                PsiElement firstChild = stringExpression.getFirstChild();
                if (firstChild == null) {
                    return;
                }
                int lengthOfFirstQuote = firstChild.getTextLength();
                String binary = "";
                String firstChildText = firstChild.getText();
                if (firstChildText.startsWith("b") || firstChildText.startsWith("B")) {
                    binary = firstChildText.substring(0, 1);
                }
                String cutted = text.substring(lengthOfFirstQuote, text.length() - 1);
                cutted = PhpStringToHeredocIntention.unescapeSymbols(cutted, isSingleQuoted);
                String string = docChar = isSingleQuoted ? SINGLE_QUOTE : "";
                if (isSingleQuoted) {
                    name = PhpStringToHeredocIntention.cutQuotes(name);
                }
                int length = cutted.length();
                StringBuilder docText = new StringBuilder().append(binary).append(HEREDOC_BEGIN).append(docChar).append(name).append(docChar).append("\n").append((String)(length > 0 ? cutted + "\n" : "")).append(PhpStringToHeredocIntention.cutQuotes(name));
                PsiFile file = element.getContainingFile();
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
                Document doc = editor.getDocument();
                int expressionTextOffset = stringExpression.getTextOffset();
                int expressionEnd = expressionTextOffset + stringExpression.getTextLength();
                PsiElement semicolon = PhpStringToHeredocIntention.hasSemicolon((PsiElement)stringExpression);
                if (semicolon != null) {
                    StringBuilder toReplace = new StringBuilder().append(";");
                    Object thisStatement = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                    if (thisStatement != null) {
                        PsiElement nextStatement = PhpPsiUtil.getNextSiblingIgnoreWhitespace(thisStatement, true);
                        int semicolonLineNumber = doc.getLineNumber(semicolon.getTextOffset());
                        if (semicolonLineNumber == doc.getLineCount() - 1 || nextStatement != null && semicolonLineNumber == doc.getLineNumber(nextStatement.getTextOffset()) || thisStatement.getTextRange().getEndOffset() > semicolon.getTextOffset() + 1) {
                            toReplace.append("\n");
                        }
                    }
                    if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                        return;
                    }
                    ApplicationManager.getApplication().runWriteAction(() -> doc.replaceString(expressionEnd, semicolon.getTextOffset() + 1, (CharSequence)toReplace));
                } else {
                    docText.append("\n");
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(() -> doc.replaceString(expressionTextOffset, expressionEnd, (CharSequence)docText));
                manager.commitDocument(doc);
            }
        }
    }

    @NotNull
    public static String cutQuotes(@NotNull String name) {
        if (name == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(2);
        }
        if (PhpNameUtil.isPhpIdentifierInDoubleQuotes(name)) {
            name = name.substring(1, name.length() - 1);
        }
        String string = name;
        if (string == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String unescapeSymbols(@NotNull String arg, boolean isSingleQuoted) {
        if (arg == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(4);
        }
        if (isSingleQuoted) {
            arg = arg.replace("\\'", SINGLE_QUOTE);
            arg = arg.replace("\\\\", SLASH);
        } else {
            arg = arg.replace("\\\"", DOUBLE_QUOTE);
        }
        String string = arg;
        if (string == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getName(@NotNull Project project, @Nullable @NlsSafe String name, @Nullable PsiElement expression, boolean doubleQuotes) {
        if (project == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(6);
        }
        return PhpHeredocRenameHandler.getNameFromDialog(project, PhpBundle.message("dialog.title.enter.tag.name", new Object[0]), expression, name, doubleQuotes, true);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(8);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        ASTNode node = element.getNode();
        if (PhpPsiUtil.isOfType(node, PhpTokenTypes.chRSINGLE_QUOTE) || PhpPsiUtil.isOfType(node, PhpTokenTypes.chRDOUBLE_QUOTE)) {
            element = element.getPrevSibling();
        }
        if (node == null) {
            return false;
        }
        StringLiteralExpression stringLiteral = PhpStringToHeredocIntention.getStringExpression(element);
        if (PhpExtractSelectedStringPartAsFormatFunctionArgumentIntention.getSelectedFormatStringParameter(project, stringLiteral) != null) {
            return false;
        }
        if (PhpStringToHeredocIntention.stringLiteral(element, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, (PsiElement)stringLiteral)) {
            this.setText(PhpBundle.message("intention.name.convert.string.literal.to.nowdoc", new Object[0]));
            return true;
        }
        if (PhpStringToHeredocIntention.stringLiteral(element, PhpTokenTypes.STRING_LITERAL, (PsiElement)stringLiteral)) {
            this.setText(PhpBundle.message("intention.name.convert.string.literal.to.heredoc", new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean stringLiteral(@Nullable PsiElement element, @NotNull IElementType elementType, @Nullable PsiElement stringExpression) {
        if (elementType == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(9);
        }
        if (element != null) {
            boolean complexDoubleQuoteString;
            boolean bl = complexDoubleQuoteString = stringExpression != null && stringExpression.getNode().getFirstChildNode().getElementType() == PhpTokenTypes.chLDOUBLE_QUOTE && elementType == PhpTokenTypes.STRING_LITERAL;
            if (PhpPsiUtil.isOfType(element, elementType, PhpTokenTypes.chLSINGLE_QUOTE) || complexDoubleQuoteString) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static StringLiteralExpression getStringExpression(@Nullable PsiElement element) {
        return (StringLiteralExpression)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.convert.string.literal.to.heredoc.nowdoc", new Object[0]);
        if (string == null) {
            PhpStringToHeredocIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/stringDoc/PhpStringToHeredocIntention";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/stringDoc/PhpStringToHeredocIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cutQuotes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSymbols";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cutQuotes";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSymbols";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stringLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

