/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.generators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.intentions.generators.PhpInvalidTemplateException;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConstructorGenerator {
    public static final String PHP_CONSTRUCTOR_TEMPLATE = "PHP Constructor";
    public static final String CLASS_NAME_ATTR = "CLASS_NAME";
    public static final String PARAM_LIST_ATTR = "PARAM_LIST";
    public static final String PARAM_DOC_ATTR = "PARAM_DOC";
    public static final String THROWS_DOC_ATTR = "THROWS_DOC";
    public static final String BODY_ATTR = "BODY";
    @NotNull
    private final Collection<PhpNamedElement> myElements;
    @NotNull
    private final PhpClass myClass;

    public PhpConstructorGenerator(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(0);
        }
        this.myElements = new ArrayList<PhpNamedElement>();
        this.myClass = phpClass;
    }

    public PhpConstructorGenerator withFields(@NotNull Collection<Field> fields) {
        if (fields == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(1);
        }
        this.myElements.addAll(fields);
        return this;
    }

    public PhpConstructorGenerator withParameters(@NotNull Collection<Parameter> parameters) {
        if (parameters == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(2);
        }
        this.myElements.addAll(parameters);
        return this;
    }

    @Nullable
    public Pair<PhpDocComment, Method> createConstructor() throws PhpInvalidTemplateException {
        String constructorTemplate = PhpCodeUtil.getCodeTemplate(PHP_CONSTRUCTOR_TEMPLATE, this.getConstructorAttributes(), this.myClass.getProject());
        constructorTemplate = constructorTemplate.replaceAll("(\\s*\\n)+", "\n");
        return PhpConstructorGenerator.createConstructorFromTemplate(this.myClass.getProject(), this.myClass.isInterface(), constructorTemplate);
    }

    @NotNull
    public static Pair<PhpDocComment, Method> createConstructorFromTemplate(Project project, boolean isInterface, String constructorTemplate) throws PhpInvalidTemplateException {
        Method constructor = PhpCodeUtil.createMethodFromTemplate(project, isInterface, constructorTemplate);
        if (constructor == null) {
            throw new PhpInvalidTemplateException("Invalid template:\n" + constructorTemplate);
        }
        Pair pair = Pair.create((Object)PhpConstructorGenerator.getPhpDoc(constructor), (Object)constructor);
        if (pair == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Nullable
    private static PhpDocComment getPhpDoc(@NotNull Method constructor) {
        PhpPsiElement prev;
        if (constructor == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(4);
        }
        if ((prev = constructor.getPrevPsiSibling()) instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (prev instanceof PhpDocComment) {
            return (PhpDocComment)prev;
        }
        return null;
    }

    private Properties getConstructorAttributes() {
        Properties attributes = new Properties();
        attributes.setProperty(CLASS_NAME_ATTR, this.myClass.getName());
        attributes.setProperty(PARAM_LIST_ATTR, this.getParameterList());
        attributes.setProperty(PARAM_DOC_ATTR, this.getParameterDoc());
        attributes.setProperty(THROWS_DOC_ATTR, "");
        attributes.setProperty(BODY_ATTR, this.getBody());
        return attributes;
    }

    private String getParameterDoc() {
        StringBuilder sb = new StringBuilder();
        for (PhpNamedElement element : this.myElements) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("* ").append("@param ");
            String typeStr = PhpDocUtil.getTypePresentation(this.myClass.getProject(), element.getType(), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)element));
            if (!typeStr.isEmpty()) {
                sb.append(typeStr).append(' ');
            }
            sb.append('$').append(element.getName());
        }
        return sb.toString();
    }

    protected String getParameterList() {
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        for (PhpNamedElement element : this.myElements) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            if (element instanceof Parameter) {
                buf.append(PhpCodeUtil.paramToString((PsiElement)element));
                continue;
            }
            String typeHint = PhpConstructorGenerator.getTypeHint(element);
            if (!typeHint.isEmpty()) {
                buf.append(typeHint).append(' ');
            }
            buf.append("$").append(element.getName());
        }
        return buf.toString();
    }

    private String getBody() {
        StringBuilder fieldAssignments = new StringBuilder();
        StringBuilder parentCallList = new StringBuilder();
        for (PhpNamedElement element : this.myElements) {
            if (element instanceof Field) {
                String fieldName = element.getName();
                fieldAssignments.append("$this->").append(fieldName);
                fieldAssignments.append("=").append('$').append(fieldName);
                fieldAssignments.append(";\n");
                continue;
            }
            if (!(element instanceof Parameter)) continue;
            if (parentCallList.length() > 0) {
                parentCallList.append(',');
            }
            parentCallList.append('$').append(element.getName());
        }
        StringBuilder result = new StringBuilder();
        if (parentCallList.length() > 0 && this.myClass.getConstructor() != null) {
            result.append("parent::__construct(").append((CharSequence)parentCallList).append(");");
            if (fieldAssignments.length() > 0) {
                result.append('\n');
            }
        }
        if (fieldAssignments.length() > 0) {
            result.append((CharSequence)fieldAssignments);
        }
        return result.toString().trim();
    }

    @NotNull
    static String getTypeHint(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(5);
        }
        Project project = element.getProject();
        PhpType type = PhpConstructorGenerator.getTypeWithPreservedSelf(project, element.getType());
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)element);
        String string = PhpAddMethodDeclarationQuickFix.createTypeHint(project, type, (PsiElement)scope, false, PhpLanguageFeature.UNION_TYPES.isSupported(project));
        if (string == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static PhpType getTypeWithPreservedSelf(@NotNull Project project, @NotNull PhpType type) {
        if (project == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(7);
        }
        if (type == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(8);
        }
        PhpType typeWithoutPolymorphic = type.filterOut(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0));
        boolean withSelfOrStaticType = type.size() != typeWithoutPolymorphic.size();
        PhpType globalType = typeWithoutPolymorphic.global(project);
        if (withSelfOrStaticType) {
            PhpType phpType = globalType.add("\\self");
            if (phpType == null) {
                PhpConstructorGenerator.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        PhpType phpType = globalType;
        if (phpType == null) {
            PhpConstructorGenerator.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/generators/PhpConstructorGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/generators/PhpConstructorGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorFromTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHint";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithPreservedSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withFields";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPhpDoc";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithPreservedSelf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

